#include "stdafx.h"
#include "PlyHeader.h"

#include <cassert>


namespace lib_geo
{
namespace ply
{


PlyHeader::PlyHeader(void)
{
	Clear();
}

void PlyHeader::Clear(void)
{
	m_FormatType.clear();

	m_NumVerts      = 0;
	m_VertPropIdx_X = -1;
	m_VertPropIdx_Y = -1;
	m_VertPropIdx_Z = -1;
	m_VertPropIdx_nX = -1;
	m_VertPropIdx_nY = -1;
	m_VertPropIdx_nZ = -1;

	m_NumFaces = 0;

	m_Comments.clear();
}

int PlyHeader::GetMaxPropIdx(void) const
{
	int max_vprop = 0;
	max_vprop = (std::max)(max_vprop, m_VertPropIdx_X);
	max_vprop = (std::max)(max_vprop, m_VertPropIdx_Y);
	max_vprop = (std::max)(max_vprop, m_VertPropIdx_Z);
	max_vprop = (std::max)(max_vprop, m_VertPropIdx_nX);
	max_vprop = (std::max)(max_vprop, m_VertPropIdx_nY);
	max_vprop = (std::max)(max_vprop, m_VertPropIdx_nZ);
	max_vprop += 1;

	return max_vprop;
}

bool PlyHeader::HasNormal(void) const
{
	bool bx = (m_VertPropIdx_nX != -1);
	bool by = (m_VertPropIdx_nY != -1);
	bool bz = (m_VertPropIdx_nZ != -1);

	assert( bx == by && by == bz );
	return (bx && by && bz);
}


}
}
