#include "StdAfx.h"
#include "LanguageLoader.h"

#include <cassert>

#include <QObject>
#include <QString>
#include <QLocale>
#include <QTranslator>
#include <QApplication>

#include "QtPath.h"


namespace qut
{


bool LanguageLoader::LoadLanguageAuto(QTranslator& translator)
{
	if (LoadFromStartupDir(translator))
		return true;

	if (LoadLanguageQtDir(translator))
		return true;

	return false;
}

bool LanguageLoader::LoadLanguageQtDir(QTranslator& translator)
{
	QString qtdir = QtPath::GetQTDir();
	if (qtdir == QObject::tr(""))
	{
		// Qt̃CXg[pX݂Ȃ
		assert(false);
		return false;
	}

	qtdir += "/";

	return LoadLanguageMain(translator, qtdir);
}

bool LanguageLoader::LoadFromStartupDir(QTranslator& translator)
{
	QString d = QApplication::applicationDirPath();
	d += "/";
	return LoadLanguageMain(translator, d);
}

bool LanguageLoader::LoadLanguageMain(QTranslator& translator, const QString& dir)
{
	QString current_locale = QLocale::system().name();

	QString current_langfile = dir;
	current_langfile += "translations/qt_";
	current_langfile += current_locale;

	if (!translator.load(current_langfile))
		return false;

	return true;
}


}
