#include "StdAfx.h"
#include "MatcapImage.h"


namespace gl
{


MatcapImage::MatcapImage(void)
{
}

void MatcapImage::ClearEnv(void)
{
	m_Tex.FinalizeTexture();
	m_Name = "";
}

void MatcapImage::LoadTexture(const char* filename)
{
	ClearEnv();

	gl::TextureConfig config;
	config.m_EnableCompress = false;
	config.m_EnableMipmap = false;

	m_Tex.InitializeTexture();
	m_Tex.LoadTextureFromFile(filename, false);
	m_Tex.SetTextureGLAndReleaseImage(config);
}


void MatcapImage::BindTexture(void)
{
	m_Tex.BindGL();
}

bool MatcapImage::HasImage(void) const
{
	return m_Tex.HasTextureObject();
}

const QString& MatcapImage::GetName(void) const
{
	return m_Name;
}

void MatcapImage::SetName(const QString& name)
{
	m_Name = name;
}


}
