#pragma once

#include <C2/lm/vector2.h>
#include <C2/lm/vector3.h>

#include <vector>


#define VBO_BUFFER_OFFSET(bytes) ((GLubyte *)NULL + (bytes))


class GeometryVBOElementBase
{
public:
	GeometryVBOElementBase(void);
	virtual ~GeometryVBOElementBase(void);

	void GenerateBuffer(void);

	GLuint GetID(void);
	bool HasBuffer(void) const;

	void ReleaseBufferElement(void);

protected:
	GLuint m_BufID;
};


class GeometryVBOElement : public GeometryVBOElementBase
{
public:
	void BindArray(void);
};

class GeometryVBOIndex : public GeometryVBOElementBase
{
public:
	void BindElementArray(void);
};


class GeometryVBO
{
public:
	void Release(void);

	void BindBuffer(void);
	void DrawVBOAll(GLenum primitive_type, bool AutoClose);
	void DisableStates(void);

public:
	GeometryVBOElement m_Vertex;
	GeometryVBOElement m_Normal;
	GeometryVBOElement m_Texture;
	GeometryVBOIndex   m_Index;

	size_t NumTriangles;
};
