#pragma once

#include <C2/gl/Projection.h>
#include <C2/gl/Manipulator.h>

#include <C2/lm/range3.h>


namespace gl
{


enum class ViewPoint
{
	Front,
	Back,
	Left,
	Right,
	Top,
	Bottom,
	Perse,
};


class Camera
{
public:
	enum ProjectionMode
	{
		PROJ_PERS,
		PROJ_ORTHO,
	};

public:
	Camera(void)
	{
		m_Projection.m_Fovy = 45;
		m_ProjMode = PROJ_PERS;
	}

	void Reset(void);

	void ResetViewFront(void);
	void ResetViewBack(void);
	void ResetViewLeft(void);
	void ResetViewRight(void);
	void ResetViewTop(void);
	void ResetViewBottom(void);
	void ResetViewPerse(void);
	void ResetViewPoint(ViewPoint vp);

	void ResetViewKeepAngle(const lm::range3f& r);

	void LookOrigin(void);

	lib_gl::Viewport& GetViewport(void)
	{
		return m_Projection.m_Viewport;
	}
	const lib_gl::Viewport& GetViewport(void) const
	{
		return m_Projection.m_Viewport;
	}

	void SetGLProjection(void);
	void SetGLModelview(void);
	void SetViewportAndMatrix(void);

private:
	void ResetViewOrthoMain(const lm::vec3f& eye_angle, const lm::vec3f& up);
	void ResetViewMain(const lm::range3f& r, const lm::vec3f& ang, const lm::vec3f& up);
	void SetClipRangeAuto(float base_length);

public:
	lib_gl::PersProjection     m_Projection;
	lib_gl::CameraManipulator  m_Manip;

	ProjectionMode m_ProjMode;
};


}
