#pragma once

#include <C2/gl/GlContextShare.h>

#include "SceneMain.h"
#include "View3D.h"
#include "View2D.h"
#include "ViewConfigDlg.h"
#include "FormCustomShader.h"
#include "CrossSectionConfigDlg.h"
#include "MatcapSelectDlg.h"
#include "DlgAssociationEdit.h"
#include "GLWidgetList.h"
#include "FullScreenPanel.h"
#include "FormPyScript.h"

#include "GuiConfig.h"
#include "GuiDataBinder.h"

#include <LibQtGeoViewerCore/Image/SampleTextureBuilder.h>
#include <LibQtGeoViewerCore/GeomFileFormat.h>

#include <QMainWindow>
#include "ui_FormMain.h"

#include <QColorDialog>
#include <QPrinter>
#include <QString>



class FormMain : public QMainWindow
{
	Q_OBJECT

public:
	FormMain(QWidget *parent = 0);
	~FormMain();

	void SetPrimaryObjectIdx(int idx);

	bool OpenGeomFile(const QString& path);

protected:
	virtual void closeEvent(QCloseEvent *e);

	virtual void keyPressEvent(QKeyEvent *e);

	virtual bool eventFilter(QObject * filterobj, QEvent * filterevt);

private:
	void SetContextShare(void);

	void HideFeatures(void);

	void InitializeEventFilter(void);
	void InitializeGLView(void);
	void InitializeStatusBar(void);
	void InitializeCoordinateCombobox(void);
	void InitializeSubDlg(void);
	void InitializeAnimation(void);
	void SaveConfig(void);

	void InitializeFromConfigFiles(void);
	void LoadDefaultConfig(void);

	bool InitializeConfig(QString path);
	void SaveConfigFile(QString path);

	void InitializeMenu(void);
	void InitContextMenu(void);
	void ProcArguments(void);

	void updateView_All(void);
	void updateView_2D(void);
	void updateView_3D(void);

	bool IsCameraFile(const QString& path) const;

	void OpenFixTextureFile(const QString& path);
	bool OpenCameraFile(const QString& path);

	bool IsSupportedTextureExt(const QString& path) const;

	void CenteringSplitter(void);

	void SyncViewSettingsFromGUI(void);
	void SyncUVViewSettingsFromGUI(void);
	void SyncSceneSettingsFromGUI(void);
	void SyncShaderSettingsToGUI(void);

	QAction* GetMenuFromShader(ShaderType type);

	void UpdateViewTypeFromMenu(void);

	bool SaveWindowLayout(const QString& filepath);
	bool LoadWindowLayout(const QString& filepath);

	void AdditionalInitializeOfGeom(int added_count);

	void ClearAllObjects(void);

	void RebuildObjectList(void);

	void ApplyGeomStateFromGUI(void);
	void ApplyGeomStateDataoToGUI(void);

	void ChangeShaderMenuMain(ShaderType type);
	void ChangePostprocMode(PostProcType type);

	void CreateSampleTextureMain(SampleTextureBuilder::TextureType tex_type);

	bool IsAutUVFit(void) const;

	void SetSelectedUVIdx2d(int idx);

	void DeleteSelectedObject();
	void DeleteTableRow(QTableWidget* table, int row);
	void FlipVisibleSelectedObject();
	void ShowObjectOnlySelected(void);
	void ShowAllObject(void);
	void HideAllObject(void);

	void SetObjectTableRow(int row, const GeomObject& obj);
	void SetObjectTableVisibleState(int row, const GeomObject& obj);

	void RefreshObjectSelectState(void);

	Qt::CheckState FilpState(Qt::CheckState state) const;

	void PrintImage(bool WithPreview);

	void ToggleLightCamera(void);

	void LoadEnvMap(QString& path);
	void LoadMatcapImage(QString& path);
	void LoadMatcapImageForCurrentMat(QString& path);

	void ShowAndActivateAndRaise(QDockWidget* widget);

	bool AcceptDropFilterIfUrl(QEvent * filterevt);
	bool IsURLDropFilterEvent(QEvent * filterevt);
	bool FilterEvent_editEnvMap(QObject * filterobj, QEvent * filterevt);
	bool FilterEvent_editMatcap(QObject * filterobj, QEvent * filterevt);
	bool FilterEvent_editMatcapEachMat(QObject * filterobj, QEvent * filterevt);

	bool IsResetSceneOnBeforeLoadFile(void) const;

	QString GetFilePathFromOpenDlg(const QString& title, const QString& filter);
	QString GetFilePathFromSaveDlg(const QString& title, const QString& filter);

	void InitDataBinding(void);
	void InitializeVisiblStateMenu(void);
	void InitializeUVStateMenu(void);
	void InitializeSceneStateMenu(void);
	void InitializeGeomStateMenu(void);
	void InitializeCursorMenu(void);

	void AddGeomStateAction(const QAction* action);

	void UpdateCameraStatus(void);

	float GetSliderNormalizedPos(const QSlider* slider) const;

	QString GetNextDefaultPathForFileDlg(void);

	void SetWidgetColor(QWidget* w, QColor col);
	void SetSelectedMaterialColor(QColor col);

	void AddRecentFile(const QString& path);
	void CreateRecentFilesMenu(const std::vector<QString>& path);
	void CreateRecentFilesFromMenu(std::vector<QString>& path);

	void ResetHoleRange(void);

private slots:
	virtual void dragEnterEvent(QDragEnterEvent* e);
	virtual void dropEvent(QDropEvent* e);

	void on_actionOpen_triggered();

	void on_actionExit_triggered();

	void actionVisibleStates_Triggered(bool);

	void on_actionWindow_ToolBarView_triggered(bool checked);
	void on_actionToolBar_Options_toggled(bool checked);
	void on_actionToolBar_Operation_toggled(bool checked);

	void on_actionCameraDist_triggered();
	void on_actionCameraFront_triggered();
	void on_actionCameraBack_triggered();
	void on_actionCameraLeft_triggered();
	void on_actionCameraRight_triggered();
	void on_actionCameraTop_triggered();
	void on_actionCameraBottom_triggered();
	void on_actionCameraPers_triggered();
	void on_actionCameraLookCenter_triggered();
	void on_actionCameraLookOrigin_triggered();

	void on_actionWindow_3DView_triggered(bool checked);
	void on_actionWindows_DualView_triggered(bool checked);
	void on_actionWindow_UVView_triggered(bool checked);

	void on_actionWindowMaterialList_triggered();
	void on_actionWindowObjectList_triggered();
	void on_actionWindowCameraList_triggered();
	void on_actionWindowScenePanel_triggered();

	void on_listMaterial_currentItemChanged(QListWidgetItem *current, QListWidgetItem *previous);
	void on_tableObject_currentItemChanged(QTableWidgetItem *current, QTableWidgetItem *previous);

	virtual void actionGeomStates_Triggered(bool);
	void on_actionGeomClear_triggered();

	void on_actionUVFitView_triggered();

	void on_actionSelObjectDelete_triggered();
	void on_actionSelObjectReload_triggered();
	void on_actionSelObjectVisible_triggered();
	void on_actionSelObjectVertexOnlyMode_triggered();
	void on_actionSelObjectFlipFace_triggered();
	void on_actionSelObjectOpenDir_triggered();
	void on_actionShowOnlySelected_triggered();
	void on_actionSelObjectTriangulate_triggered();

	void on_actionAddSample_triggered();

	void on_actionShaderDefault_triggered(bool checked);
	void on_actionShaderPhong_triggered(bool checked);
	void on_actionShaderCustom_triggered(bool checked);
	void on_actionNormalColor_triggered(bool checked);
	void on_actionDepthColor_triggered(bool checked);
	void on_actionShadowmap_triggered(bool checked);
	void on_actionEnvmap_triggered(bool checked);
	void on_actionIntegrateShader_triggered(bool checked);
	void on_actionMatcapShader_triggered(bool checked);

	void on_actionCreate_Check_triggered();
	void on_actionCreate_Stripe_V_triggered();
	void on_actionCreate_Stripe_H_triggered();

	void on_pushDeleteSelectedObject_clicked();

	void on_tableObject_cellChanged(int row, int column);

	void on_actionUVResetView_triggered();

	void on_actionWireColor_triggered();
	void on_actionFaceColor_triggered();
	void on_actionBackGroundColor_triggered();

	void on_actionWindowOptions_triggered();
	void on_actionWindowCustomShader_triggered();

	void ConfigChangedDlg_ConfigChanged();
	void CrossSectionDlg_ConfigChanged();

	void OnPaintImage(QPrinter *printer);

	void on_actionPrint_triggered();
	void on_actionPrintPreview_triggered();

	void on_pushButtonAddCameraRecord_clicked();
	void on_pushButtonDeleteCameraRecord_clicked();
	void on_pushCameraRecordClear_clicked();

	void on_listCamera_itemDoubleClicked(QListWidgetItem *item);

	void on_actionSaveCamera_triggered();

	void on_actionProjectionOrtho_triggered();
	void on_actionProjectionPers_triggered();

	void CustomShaderDlg_ShaderBuild();

	void OnRotateTimerUpdated();

	void on_actionRotateCamera_toggled(bool checked);
	void on_actionRotateLight_toggled(bool checked);

	void on_actionCrossSectionDlg_triggered();

	void WireOverlayColorChanged(const QColor & color);
	void FaceDiffuseColorChanged(const QColor & color);
	void BGColorChanged(const QColor & color);
	void SelFaceDiffuseColorChanged(const QColor & color);

	void CopyRGB(lib_graph::color4f& c, const QColor & color);
	void CopyRGBA(lib_graph::color4f& c, const QColor & color);

	void on_actionSelectNext_triggered();
	void on_actionSelectPrev_triggered();
	void on_actionSwitchVisible_triggered();
	void on_actionHideAll_triggered();
	void on_actionShowAll_triggered();

	void on_actionAddGroundPlane_triggered();

	void on_actionVertexBuilder_triggered();

	void on_actionFullScreen_triggered();

	void on_actionResetConfig_triggered();

	void on_toolLoadEnvMap_clicked();

	void on_buttonReleaseEnvImg_clicked();

	void on_sliderEnvReflection_valueChanged(int value);

	void on_comboCoordinate_currentIndexChanged(int index);

	void on_sliderShadowDarkness_valueChanged(int value);

	void on_buttonClearAllGeoms_clicked();

	void on_checkCameraAnimation_toggled(bool checked);

	void on_toolLoadMatcap_clicked();

	void on_buttonReleaseMatcap_clicked();

	void on_buttonLoadMatcapPreset_clicked();

	void on_actionOpenAppdir_triggered();
	void on_actionOpenConfigDir_triggered();

	void MatcapDlg_ListSelectChanged();

	void on_buttonDecGridAxis_clicked();
	void on_buttonIncGridAxis_clicked();
	void on_buttonResetGridAxis_clicked();

	void on_actionActionSelObjectShowOnlyOnce_triggered();

	void View3D_SelectedObjectChanged(int sel_idx);
	void View3D_CameraMoved(void);

	void on_actionCameraFPSMode_toggled(bool arg1);

	void on_actionResetCursor_triggered();
	void on_actionResetMeasure_triggered();

	void on_actionPyScript_triggered();
	void on_actionConsole_triggered();

	void on_actionClearVertSelect_triggered();

	void on_action_About_triggered();

	void on_action_Association_triggered();

	void on_actionLookDepth_triggered();
	void on_actionLook3DCursor_triggered();

	void on_sliderLightPower_valueChanged(int value);

	void on_buttonResetLightPower_clicked();

	void actionVisibleStatesUV_Triggered(bool);
	void actionSceneStates_Toggled(bool);
	void actionCursorMenuStates_Toggled(bool);

	void on_checkHoleAroundCursor_clicked(bool checked);

	void on_sliderCursorHoleRange_valueChanged(int value);

	void on_buttonResetCursorHoleRange_clicked();

	void on_actionSaveImageToMydoc_triggered();

	void on_actionPostProcNone_triggered();
	void on_actionPostProcAntialias_triggered();
	void on_actionPostProcBorder_triggered();
	void on_actionPostProcDepthLayerColor_triggered();
	void on_actionPostProcDepthColor_triggered();
	void on_actionPostProcDepthOfField_triggered();

	void on_sliderDOFPint_valueChanged(int value);
	void on_sliderDOFRange_valueChanged(int value);
	void on_buttonResetDOFPint_clicked();
	void on_buttonResetDOFRange_clicked();

	void on_actionAddCrossSectionRecord_triggered();
	void on_actionClearCrossSectionRecord_triggered();

	void on_buttonClearMatCapEachMaterial_clicked();
	void on_buttonClearCurrentMatNormalMap_clicked();

	void on_buttonDiffuse_clicked();

	void OnOpenRecent();

	void on_checkShowOnlySelect_toggled(bool checked);

private:
	Ui::FormMainClass ui;

	ViewConfigDlg          m_ViewConfigDlg;
	FormCustomShader       m_CustomShaderDlg;
	FormPyScript           m_PyScriptDlg;
	CrossSectionConfigDlg  m_CrossSectionDlg;
	FullScreenPanel        m_FullscreenPanel;
	MatcapSelectDlg        m_MatcapDlg;
	DlgAssociationEdit     m_AssociationDlg;

private:
	SceneMain    m_Scene;

	View3D       m_View3d;
	View2D       m_View2d;
	GLWidgetList m_Widgets;

	lib_gl::GlContextShare m_ContextShare;

	QColorDialog m_WireColorSelDlg;
	QColorDialog m_DiffuseColorSelDlg;
	QColorDialog m_BGColorSelDlg;
	QColorDialog m_SelDiffuseColorSelDlg;

	QTimer m_RotationTimer;

	QActionGroup* m_AGroup_Window;
	QActionGroup* m_AGroup_Shader;
	QActionGroup* m_AGroup_PProc;

	QLabel* m_StatusBar0;
	QLabel* m_StatusBar1;

	QString m_LastFileDialogDir;

	DataBinderMap m_Binder_ViewConfig;
	DataBinderMap m_Binder_UVConfig;
	DataBinderMap m_Binder_Scene;
	DataBinderMap m_Binder_Cursor;

	bool m_EnableAllFeatures;
};
