#pragma once

class Modifier
{
public:
	Modifier(void)
	{
		Alt   = false;
		Shift = false;
		Ctrl  = false;
	}

	Modifier(const QMouseEvent* e)
	{
		FromQtEvent(e);
	}

	Modifier(const QWheelEvent* e)
	{
		FromQtEvent(e);
	}

	Modifier(const QKeyEvent* e)
	{
		FromQtEvent(e);
	}

	void FromQtEvent(const QMouseEvent* e)
	{
		Alt   = ( ( e->modifiers() & Qt::AltModifier     ) != 0 );
		Shift = ( ( e->modifiers() & Qt::ShiftModifier   ) != 0 );
		Ctrl  = ( ( e->modifiers() & Qt::ControlModifier ) != 0 );
	}

	void FromQtEvent(const QWheelEvent* e)
	{
		Alt   = ( ( e->modifiers() & Qt::AltModifier     ) != 0 );
		Shift = ( ( e->modifiers() & Qt::ShiftModifier   ) != 0 );
		Ctrl  = ( ( e->modifiers() & Qt::ControlModifier ) != 0 );
	}

	void FromQtEvent(const QKeyEvent* e)
	{
		Alt   = ( ( e->modifiers() & Qt::AltModifier     ) != 0 );
		Shift = ( ( e->modifiers() & Qt::ShiftModifier   ) != 0 );
		Ctrl  = ( ( e->modifiers() & Qt::ControlModifier ) != 0 );
	}

	bool IsNone(void) const
	{
		return (!Alt && !Shift && !Ctrl);
	}

	bool IsAltOnly(void) const
	{
		return (Alt && !Shift && !Ctrl);
	}

	bool IsShiftOnly(void) const
	{
		return (!Alt && Shift && !Ctrl);
	}

	bool IsCtrlOnly(void) const
	{
		return (!Alt && !Shift && Ctrl);
	}

	bool Flag_A(void) const { return (Alt && !Shift && !Ctrl); }
	bool Flag_S(void) const { return (!Alt && Shift && !Ctrl); }
	bool Flag_C(void) const { return (!Alt && !Shift && Ctrl); }
	bool Flag_AS(void) const { return (Alt && Shift && !Ctrl); }
	bool Flag_SC(void) const { return (!Alt && Shift && Ctrl); }
	bool Flag_AC(void) const { return (Alt && !Shift && Ctrl); }
	bool Flag_ASC(void) const { return (Alt && Shift && Ctrl); }

public:
	bool Alt;
	bool Shift;
	bool Ctrl;
};
