#pragma once

#include <vector>

#include <C2/gl/GlslShader.h>
#include <C2/gl/GlewFramebuffer.h>
#include <C2/gl/GlTextureObject.h>


class PostProcBuffer
{
public:
	PostProcBuffer(void)
	{
		m_IsInitialized = false;

		m_BufWidth  = 0;
		m_BufHeight = 0;
	}

	void RebuildIfResized(int w, int h);

	void ReleaseBuf(void);

	void InitializeOnce(int w, int h);

	void Initialize(int w, int h);

	int GetWidth(void) const { return m_BufWidth; }
	int GetHeight(void) const { return m_BufHeight; }

private:
	void InitializeDethBuffer(void);
	void InitializeColorBuffer(void);
	void AssignFBOToFrameBufObjects(void);

public:
	lib_gl::GlFramebuffer m_Fbo;
	lib_gl::GlTextureObject m_ColorBuf;
	lib_gl::GlTextureObject m_DepthBuf;

private:
	void operator=(const PostProcBuffer& buf) {}

private:
	int m_BufWidth;
	int m_BufHeight;

	bool m_IsInitialized;
};


class MultPathRenderBuf
{
public:
	size_t GetNumPath(void) const { return m_PPAry.size(); }
	PostProcBuffer& GetBuf(size_t idx) { return m_PPAry[idx]; }
	const PostProcBuffer& GetBuf(size_t idx) const { return m_PPAry[idx]; }

	void ResizePathCount(size_t num_path);

private:
	boost::ptr_vector<PostProcBuffer> m_PPAry;
};
