varying vec3 v_position;
varying vec3 v_normal;


vec3 GetFlatNormal(void)
{
	vec3 dx = dFdx(v_position);
	vec3 dy = dFdy(v_position);
	return normalize(cross(dx, dy));
}

void main (void)
{
	vec3 N = v_normal;

	gl_FragColor.x = (N.x + 1.0) * 0.5;
	gl_FragColor.y = (N.y + 1.0) * 0.5;
	gl_FragColor.z = (N.z + 1.0) * 0.5;
	gl_FragColor.a = 1.0;
}
