/*
 *			GPAC - Multimedia Framework C SDK
 *
 *			Copyright (c) Jean Le Feuvre 2000-2005 
 *					All rights reserved
 *
 *  This file is part of GPAC 
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *   
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef _GF_ISO_639_H
#define _GF_ISO_639_H


/*ISO 639 code names 
	- first string is readable english name of the language
	- second string is 3-char code of language as per ISO/IEC 639-2
	- third string is 2-char code of language as per ISO/IEC 639-1, and may be empty 
*/
static const char *GF_ISO639_Lang[] = 
{
	"Abkhazian","abk", "ab",
	"Achinese","ace", "",
	"Acoli","ach", "",
	"Adangme","ada", "",
	"Adygei","ady", "",
	"Adyghe","ady", "",
	"Afar","aar", "aa",
	"Afrihili","afh", "",
	"Afrikaans","afr", "af",
	"Afro-Asiatic (Other)","afa", "",
	"Akan","aka", "",
	"Akkadian","akk", "",
	"Albanian","alb/sqi", "sq",
	"Aleut","ale", "",
	"Algonquian languages","alg", "",
	"Altaic (Other)","tut", "",
	"Amharic","amh", "am",
	"Apache languages","apa", "",
	"Arabic","ara", "ar",
	"Aragonese","arg", "",
	"Aramaic","arc", "",
	"Arapaho","arp", "",
	"Araucanian","arn", "",
	"Arawak","arw", "",
	"Armenian","arm/hye", "hy",
	"Artificial (Other)","art", "",
	"Assamese","ast", "as",
	"Athapascan languages","ath", "",
	"Australian languages","aus", "",
	"Austronesian (Other)","map", "",
	"Avaric","ava", "",
	"Avestan","ave", "",
	"Awadhi","awa", "",
	"Aymara","aym", "ay",
	"Azerbaijani","aze", "az",
	"Bable","ast", "",
	"Balinese","ban", "",
	"Baltic (Other)","bat", "",
	"Baluchi","bal", "",
	"Bambara","bam", "",
	"Bamileke languages","bai", "",
	"Banda","bad", "",
	"Bantu (Other)","bnt", "",
	"Basa","bas", "",
	"Bashkir","bak", "ba",
	"Basque","baq/eus", "eu",
	"Batak (Indonesia)","btk", "",
	"Beja","bej", "",
	"Belarusian","bel", "be",
	"Bemba","bem", "",
	"Bengali","ben", "bn",
	"Berber (Other)","ber", "",
	"Bhojpuri","bho", "",
	"Bihari","bih", "bh",
	"Bikol","bik", "",
	"Bini","bin", "",
	"Bislama","bis", "bi",
	"Bokml, Norwegian","nob", "",
	"Bosnian","bos", "",
	"Braj","bra", "",
	"Breton","bre", "br",
	"Buginese","bug", "",
	"Bulgarian","bul", "bg",
	"Buriat","bua", "",
	"Burmese","bur/mya", "my",
	"Caddo","cad", "",
	"Carib","car", "",
	"Castilian","spa", "",
	"Catalan","cat", "ca",
	"Caucasian (Other)","cau", "",
	"Cebuano","ceb", "",
	"Celtic (Other)","cel", "",
	"Central American Indian (Other)","cai", "",
	"Chagatai","chg", "",
	"Chamic languages","cmc", "",
	"Chamorro","cha", "",
	"Chechen","che", "",
	"Cherokee","chr" , "",
	"Chewa","nya", "",
	"Cheyenne","chy", "",
	"Chibcha","chb", "",
	"Chichewa","nya", "",
	"Chinese","chi/zho", "zh",
	"Chinook jargon","chn", "",
	"Chipewyan","chp", "",
	"Choctaw","cho", "",
	"Chuang","zha", "",
	"Church Slavic (Slavonic)","chu", "",
	"Chuukese","chk", "",
	"Chuvash","chv", "",
	"Coptic","cop", "",
	"Cornish","cor", "",
	"Corsican","cos", "co",
	"Cree","cre" , "",
	"Creek","mus" , "",
	"Creoles and pidgins(Other)","crp", "",
	"Creoles and pidgins, English-based (Other)","cpe", "",
	"Creoles and pidgins, French-based (Other)","cpf", "",
	"Creoles and pidgins, Portuguese-based (Other)","cpp", "",
	"Crimean Tatar","crh", "",
	"Crimean Turkish","crh", "",
	"Croatian","scr/hrv", "hr",
	"Cushitic (Other)","cus", "",
	"Czech","cze/ces", "cs",
	"Dakota","dak", "",
	"Danish","dan", "da",
	"Dargwa","dar", "",
	"Dayak","day", "",
	"Delaware","del", "",
	"Dinka","din", "",
	"Divehi","div" , "",
	"Dogri","doi", "",
	"Dogrib","dgr" , "",
	"Dravidian (Other)","dra", "",
	"Duala","dua", "",
	"Dutch","dut/nld", "nl",
	"Dutch, Middle (ca. 1050-1350)","dum", "",
	"Dyula","dyu", "",
	"Dzongkha","dzo", "dz",
	"Efik","efi", "",
	"Egyptian (Ancient)","egy", "",
	"Ekajuk","eka", "",
	"Elamite","elx", "",
	"English","eng", "en",
	"English, Middle (1100-1500)","enm", "",
	"English, Old (ca.450-1100)","ang", "",
	"Erzya","myv", "",
	"Esperanto","epo", "eo",
	"Estonian","est", "et",
	"Ewe","ewe", "",
	"Ewondo","ewo", "",
	"Fang","fan", "",
	"Fanti","fat" , "",
	"Faroese","fao", "fo",
	"Fijian","fij", "fj",
	"Finnish","fin", "fi",
	"Finno-Ugrian (Other)","fiu", "",
	"Fon","fon", "",
	"French","fre/fra", "fr",
	"French, Middle (ca.1400-1600)","frm", "",
	"French, Old (842-ca.1400)","fro", "",
	"Frisian","fry", "fy",
	"Friulian","fur" , "",
	"Fulah","ful", "",
	"Ga","gaa", "",
	"Gaelic","gla", "",
	"Gallegan","glg", "gl",
	"Ganda","lug", "",
	"Gayo","gay", "",
	"Gbaya","gba" , "",
	"Geez","gez", "",
	"Georgian","geo/kat", "ka",
	"German","ger/deu", "de",
	"German, Low","nds" , "",
	"German, Middle High (ca.1050-1500)","gmh", "",
	"German, Old High (ca.750-1050)","goh", "",
	"Germanic (Other)","gem", "",
	"Gikuyu","kik", "",
	"Gilbertese","gil", "",
	"Gondi","gon", "",
	"Gorontalo","gor", "",
	"Gothic","got", "",
	"Grebo","grb", "",
	"Greek, Ancient (to 1453)","grc", "",
	"Greek, Modern (1453-)","gre/ell", "el",
	"Guarani","grn", "gn",
	"Gujarati","guj", "gu",
	"Gwichin","gwi", "",
	"Haida","hai", "",
	"Haitian","hat", "",
	"Haitian Creole","hat", "",
	"Hausa","hau", "ha",
	"Hawaiian","haw", "",
	"Hebrew","heb", "he",
	"Herero","her", "",
	"Hiligaynon","hil", "",
	"Himachali","him", "",
	"Hindi","hin", "hi",
	"Hiri Motu","hmo", "",
	"Hittite","hit", "",
	"Hmong","hmn", "",
	"Hungarian","hun", "hu",
	"Hupa","hup", "",
	"Iban","iba", "",
	"Icelandic","ice/isl", "is",
	"Ido","ido", "",
	"Igbo","ibo" , "",
	"Ijo","ijo", "",
	"Iloko","ilo", "",
	"Inari Sami","smn", "",
	"Indic (Other)","inc", "",
	"Indo-European (Other)","ine", "",
	"Indonesian","ind", "id",
	"Ingush","inh", "",
	"Interlingua (International Auxiliary Language Association)","ina", "ia",
	"Interlingue","ile", "",
	"Inuktitut","iku", "iu",
	"Inupiaq","ipk", "ik",
	"Iranian (Other)","ira", "",
	"Irish","gle", "ga",
	"Irish, Middle (900-1200)","mga", "",
	"Irish, Old (to 900)","sga", "",
	"Iroquoian languages","iro", "",
	"Italian","ita", "it",
	"Japanese","jpn", "ja",
	"Javanese","jav", "jv",
	"Judeo-Arabic","jrb", "",
	"Judeo-Persian","jpr", "",
	"Kabardian","kbd", "",
	"Kabyle","kab", "",
	"Kachin","kac", "",
	"Kalaallisut","kal", "kl",
	"Kalmyk","xal", "",
	"Kamba","kam", "",
	"Kannada","kan", "kn",
	"Kanuri","kau", "",
	"Karachay-Balkar","krc", "",
	"Kara-Kalpak","kaa", "",
	"Karen","kar", "",
	"Kashmiri","kas", "ks",
	"Kashubian","csb", "",
	"Kawi","kaw", "",
	"Kazakh","kaz", "kk",
	"Khasi","kha", "",
	"Khmer","khm", "km",
	"Khoisan (Other)","khi", "",
	"Khotanese","kho", "",
	"Kikuyu","kik", "",
	"Kimbundu","kmb", "",
	"Kinyarwanda","kin", "rw",
	"Kirghiz","kir", "ky",
	"Komi","kom", "",
	"Kongo","kon" , "",
	"Konkani","kok" , "",
	"Korean","kor", "ko",
	"Kosraean","kos" , "",
	"Kpelle","kpe" , "",
	"Kru","kro" , "",
	"Kuanyama","kua", "",
	"Kumyk","kum" , "",
	"Kurdish","kur", "ku",
	"Kurukh","kru" , "",
	"Kutenai","kut", "",
	"Kwanyama","kua", "",
	"Ladino","lad" , "",
	"Lahnda","lah" , "",
	"Lamba","lam" , "",
	"Lao","lao", "lo",
	"Latin","lat", "la",
	"Latvian","lav", "lv",
	"Letzeburgesch","ltz", "",
	"Lezghian (lezLimburgan - limLimburger - limlimburgish)","lim", "",
	"Lingala","lin", "ln",
	"Lithuanian","lit", "lt",
	"Low German","nds", "",
	"Low Saxon","nds", "",
	"Lozi","loz" , "",
	"Luba-Katanga","lub" , "",
	"Luba-Lulua","lua" , "",
	"Luiseno","lui", "",
	"Lule Sami","smj", "",
	"Lunda","lun" , "",
	"Luo (Kenya and Tanzania)","luo", "",
	"Luxembourgish","ltz", "",
	"Lushai","lus" , "",
	"Macedonian","mac/mkd", "mk",
	"Madurese","mad" , "",
	"Magahi","mag" , "",
	"Maithili","mai", "",
	"Makasar","mak", "",
	"Malagasy","mlg", "mg",
	"Malay","may/msa", "ms",
	"Malayalam","mal", "",
	"Maltese","mlt", "ml",
	"Manchu","mnc", "",
	"Mandar","mdr", "",
	"Mandingo","man", "",
	"Manipuri","mni" , "",
	"Manobo languages","mno" , "",
	"Manx","glv", "",
	"Maori","mao/mri", "mi",
	"Marathi","mar", "mr",
	"Mari","chm" , "",
	"Marshallese","mah", "",
	"Marwari","mwr" , "",
	"Masai","mas" , "",
	"Mayan languages","myn" , "",
	"Mende","men" , "",
	"Micmac","mic" , "",
	"Minangkabau","min" , "",
	"Miscellaneous languages","mis" , "",
	"Mohawk","moh" , "",
	"Moksha","mdf", "",
	"Moldavian","mol", "mo",
	"Mon-Khmer (Other)","mkh" , "",
	"Mongo","lol" , "",
	"Mongolian","mon", "mn",
	"Mossi","mos" , "",
	"Multiple languages","mul" , "",
	"Munda languages","mun" , "",
	"Nahuatl","nah" , "",
	"Nauru","nau", "na",
	"Navaho","nav", "",
	"Navajo","nav", "",
	"Ndebele, North","nde", "",
	"Ndebele, South","nbl", "",
	"Ndonga, ndoNeapolitan","nap", "",
	"Nepali","nep", "ne",
	"Newari","new" , "",
	"Nias","nia" , "",
	"Niger-Kordofanian (Other)","nic", "",
	"Nilo-Saharan (Other)","ssa" , "",
	"Niuean","niu" , "",
	"Nogai","nog", "",
	"Norse, Old","non", "",
	"North American Indian (Other)","nai" , "",
	"Northern Sami","sme", "",
	"North Ndebele","nde", "",
	"Norwegian","nor", "no",
	"Norwegian Bokml","nob", "",
	"Norwegian Nynorsk","nno", "",
	"Nubian languages","nub" , "",
	"Nyamwezi","nym" , "",
	"Nyanja","nya", "",
	"Nyankole","nyn", "",
	"Nynorsk, Norwegian","nno" , "",
	"Nyoro","nyo" , "",
	"Nzima","nzi" , "",
	"Occitan (post 1500)","oci", "oc",
	"Ojibwa","oji" , "",
	"Old Bulgarian","chu", "",
	"Old Church Slavonic","chu", "",
	"Old Slavonic","chu", "",
	"Oriya","ori", "or",
	"Oromo","orm", "om",
	"Osage","osa", "",
	"Ossetian - Ossetic","oss", "",
	"Otomian languages","oto", "",
	"Pahlavi","pal" , "",
	"Palauan","pau", "",
	"Pali","pli", "",
	"Pampanga","pam", "",
	"Pangasinan","pag", "",
	"Panjabi","pan", "pa",
	"Papiamento","pap" , "",
	"Papuan (Other)","paa" , "",
	"Persian","per/fas", "fa",
	"Persian, Old (ca.600-400)","peo" , "",
	"Philippine (Other)","phi" , "",
	"Phoenician","phn" , "",
	"Pohnpeian","pon" , "",
	"Polish","pol", "pl",
	"Portuguese","por", "pt",
	"Prakrit languages","pra", "",
	"Provenal","oci", "",
	"Provenal, Old (to 1500)","pro" , "",
	"Pushto","pus", "ps",
	"Quechua","que", "qu",
	"Raeto-Romance","roh", "rm",
	"Rajasthani","raj", "",
	"Rapanui","rap", "",
	"Rarotongan","rar", "",
	"Romance (Other)","roa", "",
	"Romanian","rum/ron", "ro",
	"Romany","rom" , "",
	"Rundi","run", "rn",
	"Russian","rus", "ru",
	"Salishan languages","sal" , "",
	"Samaritan Aramaic","sam" , "",
	"Sami languages (Other)","smi" , "",
	"Samoan","smo", "sm",
	"Sandawe","sad" , "",
	"Sango","sag", "sg",
	"Sanskrit","san", "sa",
	"Santali","sat", "",
	"Sardinian","srd", "",
	"Sasak","sas" , "",
	"Saxon, Low","nds", "",
	"Scots","sco", "",
	"Scottish Gaelic","gla"  , "",
	"Selkup","sel" , "",
	"Semitic (Other)","sem" , "",
	"Serbian","srp", "sr",
	"Serbo-Croatian", "scr", "sh",
	"Serer","srr" , "",
	"Shan","shn" , "",
	"Shona","sna", "sn",
	"Sichuan Yi","iii", "",
	"Sidamo","sid" , "",
	"Sign languages","sgn" , "",
	"Siksika","bla" , "",
	"Sindhi","snd", "sd",
	"Sinhalese","sin", "si",
	"Sino-Tibetan (Other)","sit", "",
	"Siouan languages","sio", "",
	"Skolt Sami","sms" , "",
	"Slave (Athapascan)","den" , "",
	"Slavic (Other)","sla" , "",
	"Slovak","slo", "sk",
	"Slovenian","slv", "sl",
	"Sogdian","sog" , "",
	"Somali","som", "so",
	"Songhai","son" , "",
	"Soninke","snk" , "",
	"Sorbian languages","wen" , "",
	"Sotho, Northern","nso" , "",
	"Sotho, Southern","sot", "st",
	"South American Indian (Other)","sai" , "",
	"Southern Sami","sma", "",
	"South Ndebele","nbl", "",
	"Spanish","spa", "es",
	"Sukuma","suk", "",
	"Sumerian","sux" , "",
	"Sundanese","sun", "su",
	"Susu","sus" , "",
	"Swahili","swa", "sw",
	"Swati","ssw", "ss",
	"Swedish","swe", "sv",
	"Syriac","syr", "",
	"Tagalog","tgl", "tl",
	"Tahitian","tah", "",
	"Tai (Other)","tai" , "",
	"Tajik","tgk", "tg",
	"Tamashek","tmh" , "",
	"Tamil","tam", "ta",
	"Tatar","tat", "tt",
	"Telugu","tel", "te",
	"Tereno","ter" , "",
	"Tetum","tet" , "",
	"Thai","tha", "th",
	"Tibetan","tib", "bo",
	"Tigre","tig" , "",
	"Tigrinya","tir", "ti",
	"Timne","tem" , "",
	"Tiv","tiv" , "",
	"Tlingit","tli" , "",
	"Tok Pisin","tpi" , "",
	"Tokelau","tkl" , "",
	"Tonga (Nyasa)","tog" , "to",
	"Tonga (Tonga Islands)","ton", "",
	"Tsimshian","tsi" , "",
	"Tsonga","tso", "ts",
	"Tswana","tsn", "tn",
	"Tumbuka","tum" , "",
	"Tupi languages","tup", "",
	"Turkish","tur", "tr",
	"Turkish, Ottoman (1500-1928)","ota" , "",
	"Turkmen","tuk", "tk",
	"Tuvalu","tvl", "",
	"Tuvinian","tyv" , "",
	"Twi","twi", "tw",
	"Udmurt (udmUgaritic)","uga" , "",
	"Uighur","uig", "ug",
	"Ukrainian","ukr", "uk",
	"Umbundu","umb" , "",
	"Undetermined","und", "",
	"Urdu","urd", "ur",
	"Uzbek","uzb", "uz",
	"Vai","vai", "",
	"Venda","ven" , "",
	"Vietnamese","vie", "vi",
	"Volapk","vol", "vo",
	"Votic","vot", "",
	"Wakashan languages","wak" , "",
	"Walamo","wal" , "",
	"Walloon","wln", "",
	"Waray","war", "",
	"Washo","was" , "",
	"Welsh","wel", "cy",
	"Wolof","wol", "wo",
	"Xhosa","xho", "xh",
	"Yakut","sah" , "",
	"Yao","yao" , "",
	"Yapese","yap", "",
	"Yiddish","yid", "yi",
	"Yoruba","yor", "yo",
	"Yupik languages","ypk" , "",
	"Zande","znd" , "",
	"Zapotec","zap" , "",
	"Zenaga","zen" , "",
	"Zhuang","zha", "za",
	"Zulu","zul", "zu",
	"Zuni","zun", "",
	NULL
};


#endif
