#!/usr/bin/perl
# Synced to rectool.pl revision 804

print "UID:$<\n";
if ( $< ) {
	print "Please run this script with root.\n";
	exit;
}

$distribution = `ls /etc -F | grep \"release\$\\|version\$\"`;

if ( $distribution =~ /redhat|fedora/m ) {
	print "Your distribution seems to be RedHat/Fedora.\n";
	$redhat = 1;
}
elsif ( $distribution =~ /debian/m ) {
	print "Your distribution seems to be Debian.\n";
	$debian = 1;
}
else {
	print "Your distribution is unknown, doint CPAN installation.\n";
}

my @packages = (
#	[ 'CPAN'                 , 'YUM', 'APT' ], 
	[ 'Algorithm::Diff'      , 'yes', 'yes' ], 
#	[ 'CGI::Carp'            , 'no' , 'no'  ], # in perl-CGI
	[ 'CGI'                  , 'yes', 'yes' ], 
	[ 'Config::Simple'       , 'yes', 'yes' ], 
	[ 'Data::Dumper::Concise', 'yes', 'yes' ], 
	[ 'Date::Simple'         , 'yes', 'yes' ], 
	[ 'DateTime'             , 'yes', 'yes' ], 
	[ 'DBI'                  , 'yes', 'yes' ], 
#	[ 'MIME::Base64'         , 'no' , 'yes' ], # in standard module
	[ 'File::Slurp'          , 'yes', 'yes' ], 
	[ 'Sort::Naturally'      , 'yes', 'yes' ], 
	[ 'Time::Piece'          , 'yes', 'yes' ], 
#	[ 'Time::Seconds'        , 'no' , 'no'  ], # in perl-Time-Piece
#	[ 'Time::HiRes'          , 'no' , 'yes' ], # in standard module 
	[ 'Tie::IxHash'          , 'yes', 'yes' ], 
#	[ 'required'             , 'by' , 'cgi' ], 
	[ 'Text::Ngram'          , 'no' , 'no'  ], 
	[ 'List::Compare'        , 'yes', 'yes' ], 
#	[ 'List::Util'           , 'no' , 'no'  ], # in standard module
	[ 'XML::Atom'            , 'yes', 'yes' ], 
);

if ( $redhat ) {
	foreach ( @packages ) {
		if ( $_->[1] eq 'yes' ) {
			my $YUM = $_->[0];
			$YUM =~ s/\A/perl-/;
			$YUM =~ s/::/-/;
			push @YUM, $YUM;
		}
		elsif ( $_->[1] eq 'no' ) {
			push @CPAN, $_->[0];
		}
	}
	my $YUM  = join ' ', @YUM;
	my $CPAN = join ' ', @CPAN;

	print "Going to install ( YUM )\n";
	print "$YUM\n";
	system( "yum install $YUM" );
	print "Going to install ( CPAN )\n";
	print "$CPAN\n";
	system( "cpan $CPAN" );
}
elsif ( $debian ) {
	foreach ( @packages ) {
		if ( $_->[2] eq 'yes' ) {
			my $APT = $_->[0];
			$APT = lc $APT;
			$APT =~ s/\A/lib/;
			$APT =~ s/\Z/-perl/;
			$APT =~ s/::/-/;
			push @APT, $APT;
		}
		elsif ( $_->[2] eq 'no' ) {
			push @CPAN, $_->[0];
		}
	}
	my $APT  = join ' ', @APT;
	my $CPAN = join ' ', @CPAN;

	print "Going to install ( APT )\n";
	print "$APT\n";
	system( "aptitude install $APT" );
	print "Going to install ( CPAN )\n";
	print "$CPAN\n";
	system( "cpan $CPAN" );
}
else {
	my $CPAN = join ' ', map { $_->[0] } @packages;

	print "Going to install ( CPAN )\n";
	print "$CPAN\n";
	system( "cpan $CPAN" );
}

