#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import sys
import commands
import tv2avi
import os
import os.path
import time
import configreader
def ts2mp4(pin, pout, opt):
    dir=os.path.split(pout)[0]
    title=os.path.split(pout)[1]
    title=os.path.splitext(title)[0]
    tpavi=os.path.join(dir, title+".avi")
    tv2avi.ts2avi(pin, tpavi, opt)
    time.sleep(10)
    if not os.path.exists(tpavi):
        if os.path.exists(pin):
            tpavi=pin
    avi2mp4(tpavi,pout)
def avi2mp4(pin,pout):
    exe = configreader.getpath("MP4Box")
    dir=os.path.split(pin)[0]
    title=os.path.split(pin)[1]
    title=os.path.splitext(title)[0]
    audiopath=os.path.join(dir,title+"_audio.mp3")
    videopath=os.path.join(dir,title+"_video.h264")
    #doexe = exe.encode('utf-8') + u' \"' + pin.encode('utf-8') + u'\" \"' + pout.encode('utf-8') + u'\"'
    exe1=exe+" -aviraw audio \'"+pin+"\'"
    exe2=exe+" -aviraw video \'"+pin+"\'"
    exefin=exe+" -new -fps 29.97 -add \'"+videopath+"\'#video -add \'"+audiopath+"\'#audio \'"+pout+"\'"
    logo=pin.replace(".avi",".log")
    os.environ['LANG']="ja_JP.UTF-8"
    txt= exe1+"\n"+exe2+"\n"+exefin+"\n"
    txt = txt+commands.getoutput(exe1)
    txt = txt+commands.getoutput(exe2)
    txt = txt+commands.getoutput(exefin)
    os.remove(audiopath)
    os.remove(videopath)
    txt = "\n####MP4Box-log####\n"+txt
    f=open(logo,'a')
    f.write(txt)
    f.close()
    sys.stdout.flush()
    time.sleep(10)
    if os.path.exists(pout):
        if os.path.exists(audiopath):
            os.remove(audiopath)
        if os.path.exists(videopath):
            os.remove(videopath)
def mkv2mp4(pin,pout):
    exeb = configreader.getpath("mkvextract")
    exe = configreader.getpath("MP4Box")
    dir=os.path.split(pin)[0]
    title=os.path.split(pin)[1]
    title=os.path.splitext(title)[0]
    audiopath=os.path.join(dir,title+"_audio.mp3")
    if not os.path.exists(audiopath):
        if os.path.exists(os.path.join(dir,title+"_audio.raw")):
            audiopath=os.path.join(dir,title+"_audio.raw")
        if os.path.exists(os.path.join(dir,title+"_audio.aac")):
            audiopath=os.path.join(dir,title+"_audio.aac")
    videopath=os.path.join(dir,title+"_video.h264")
    #doexe = exe.encode('utf-8') + u' \"' + pin.encode('utf-8') + u'\" \"' + pout.encode('utf-8') + u'\"'
    exe0=exeb+" tracks \'"+pin+"\' 1:\'"+videopath+"\' 2:\'"+audiopath+"\'"
    exe1=exe+" -aviraw audio \'"+pin+"\'"
    exe2=exe+" -aviraw video \'"+pin+"\'"
    exefin=exe+" -new -fps 29.97 -add \'"+videopath+"\'#video -add \'"+audiopath+"\'#audio \'"+pout+"\'"
    logo=pin.replace(".avi",".log")
    os.environ['LANG']="ja_JP.UTF-8"
    txt= exe0+"\n"+exe1+"\n"+exe2+"\n"+exefin+"\n"
    txt = txt+commands.getoutput(exe0)
    txt = txt+commands.getoutput(exe1)
    txt = txt+commands.getoutput(exe2)
    txt = txt+commands.getoutput(exefin)
    os.remove(audiopath)
    os.remove(videopath)
    txt = "\n####MKV2MP4-log####\n"+txt
    f=open(logo,'a')
    f.write(txt)
    f.close()
    sys.stdout.flush()
    time.sleep(10)
    if os.path.exists(pout):
        if os.path.exists(audiopath):
            os.remove(audiopath)
        if os.path.exists(videopath):
            os.remove(videopath)
