// Caption2SRT.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <shlwapi.h>
#include <strsafe.h>
#include <stdio.h>
#include <vector>
#include <list>
#include "CaptionDllUtil.h"

#define ASS_HEADER "[Script Info]\r\n\
; Script generated by Aegisub v2.1.2 RELEASE PREVIEW (SVN r1987, amz)\r\n\
; http://www.aegisub.net\r\n\
Title: Default Aegisub file\r\n\
ScriptType: v4.00+\r\n\
WrapStyle: 0\r\n\
PlayResX: 640\r\n\
PlayResY: 480\r\n\
ScaledBorderAndShadow: yes\r\n\
Video Aspect Ratio: 0\r\n\
Video Zoom: 6\r\n\
Video Position: 0\r\n\
\r\n\
[V4+ Styles]\r\n\
Format: Name, Fontname, Fontsize, PrimaryColour, SecondaryColour, OutlineColour, BackColour, Bold, Italic, Underline, StrikeOut, ScaleX, ScaleY, Spacing, Angle, BorderStyle, Outline, Shadow, Alignment, MarginL, MarginR, MarginV, Encoding\r\n\
Style: Default,MS UI Gothic,30,&H00FFFFFF,&H000000FF,&H00000000,&H00000000,0,0,0,0,100,100,0,0,1,2,2,2,10,10,10,0\r\n\
\r\n\
[Events]\r\n\
Format: Layer, Start, End, Style, Name, MarginL, MarginR, MarginV, Effect, Text\r\n"

enum {
	FORMAT_SRT = 1,
	FORMAT_ASS = 2
};

typedef struct _SRT_LINE {
	UINT				index;
	DWORD				startTime;
	DWORD				endTime;
	std::string			str;
} SRT_LINE, *PSRT_LINE;

typedef std::list<PSRT_LINE> SRT_LIST;

VOID _tMyPrintf(
	IN	LPCTSTR tracemsg,
	...
	)
{
	TCHAR buf[1024] = {0};
	HRESULT ret;

	__try {
		va_list ptr;
		va_start(ptr,tracemsg);

		ret = StringCchVPrintf(
			buf,
			2048,
			tracemsg,
			ptr
			);

		if(ret == S_OK) {
			DWORD ws;
			WriteConsole(GetStdHandle(STD_OUTPUT_HANDLE), buf, _tcsclen(buf), &ws, NULL);

		}
	}
	__finally {
	}

	return;
}

BOOL FindStartOffset(FILE *fp)
{
	BYTE buf[188 * 2] = {0};

	while(fread(buf, 188 * 2, 1, fp) == 1) {

		for(int i = 0; i < 188; i++) {
			if(buf[i] == 0x47 && buf[i+188] == 0x47) {
				fseek(fp, i, SEEK_SET);
				return TRUE;
			}
		}

		return FALSE;
	}

	return FALSE;
}

long long GetPTS(PBYTE pbPacket)
{
	long long PTS = 0;
	// Get PTS in PES Header(00 00 01 BD)
	for(int i = 4; i < 188 - 10; i++) {
		if( pbPacket[i] == 0x00 &&
			pbPacket[i+1] == 0x00 &&
			pbPacket[i+2] == 0x01 &&
			pbPacket[i+3] == 0xBD) {
				PBYTE pData = &pbPacket[i+9];

				PTS = (((*pData) & 0xE) >> 1) << 30;
				pData++;

				PTS += (*pData) << 22;
				pData++;

				PTS += ((*pData) >> 1) << 15;
				pData++;

				PTS += ((*pData)) << 7;
				pData++;

				PTS += ((*pData) >> 1);

				PTS = PTS/90;

				return PTS;
		}
	}

	return 0;
}

void DumpAssLine(FILE *fp, SRT_LIST * list, long long PTS)
{
	SRT_LIST::iterator it = list->begin();
	for(int i = 0; it != list->end(); it++, i++) {

		if(i == 0) {
			(*it)->endTime = PTS;

			unsigned short sH, sM, sS, sMs, eH, eM, eS, eMs;

			sMs = (int)(*it)->startTime % 100;
			sS = (int)((*it)->startTime / 1000) % 60;
			sM = (int)((*it)->startTime / (1000 * 60)) % 60;
			sH = (int)((*it)->startTime / (1000 * 60 *60));

			eMs = (int)(*it)->endTime % 100;
			eS = (int)((*it)->endTime / 1000) % 60;
			eM = (int)((*it)->endTime / (1000 * 60)) % 60;
			eH = (int)((*it)->endTime / (1000 * 60 *60));

			fprintf(fp,"Dialogue: 0,%01d:%02d:%02d.%02d,%01d:%02d:%02d.%02d,Default,,0000,0000,0000,,", sH, sM, sS, sMs, eH, eM, eS, eMs);
		}

		fwrite((*it)->str.c_str(), (*it)->str.size(),1, fp);
		fprintf(fp, "\\N");

		delete (*it);
	}

	if(list->size() > 0)
		fprintf(fp, "\r\n");

	list->clear();
}

DWORD srtIndex = 1; // index for SRT
void DumpSrtLine(FILE *fp, SRT_LIST * list, long long PTS)
{
	SRT_LIST::iterator it = list->begin();
	for(int i = 0; it != list->end(); it++, i++) {

		if(i == 0) {
			(*it)->endTime = PTS;

			unsigned short sH, sM, sS, sMs, eH, eM, eS, eMs;

			sMs = (int)(*it)->startTime % 1000;
			sS = (int)((*it)->startTime / 1000) % 60;
			sM = (int)((*it)->startTime / (1000 * 60)) % 60;
			sH = (int)((*it)->startTime / (1000 * 60 *60));

			eMs = (int)(*it)->endTime % 1000;
			eS = (int)((*it)->endTime / 1000) % 60;
			eM = (int)((*it)->endTime / (1000 * 60)) % 60;
			eH = (int)((*it)->endTime / (1000 * 60 *60));

			fprintf(fp,"%d\r\n%02d:%02d:%02d,%03d --> %02d:%02d:%02d,%03d\r\n", srtIndex, sH, sM, sS, sMs, eH, eM, eS, eMs);
		}

		fwrite((*it)->str.c_str(), (*it)->str.size(),1, fp);
		fprintf(fp, "\r\n");

		delete (*it);
	}

	if(list->size() > 0) {
		fprintf(fp, "\r\n");
		srtIndex++;
	}

	list->clear();
}

int _tmain(int argc, _TCHAR* argv[])
{
	USHORT PMTPid = 0;
	USHORT CaptionPid = 0;
	USHORT PCRPid = 0;

	long long startPCR = 0;
	long long lastPCR = 0;
	long long lastPTS = 0;

	SRT_LIST srtList;
	TCHAR *pFileName = NULL;
	TCHAR *pTargetFileName = NULL;
	DWORD format = FORMAT_ASS;
	BOOL bPrintPMT = TRUE;

	// [-PMT_PID id] .ts [filename]
	// [-format srt|ass]

#ifdef _DEBUG
	_tMyPrintf(_T("Attach Now...\r\n"));
	getchar();
#endif

	system("cls");

	/*
	 * Parse arguments
	 */
	if(argc < 2) {
ERROR_PARAM:
		_tMyPrintf(_T("Caption2Ass.exe [OPTIONS] source.ts [target filename]\r\n\r\n"));
		_tMyPrintf(_T("-PMT_PID PID  PID is HEX value. Ex: -PMT_PID 1f2\r\n"));
		_tMyPrintf(_T("-format {srt|ass}. Ex: -format srt\r\n"));

		return 1;
	}

	for(int i = 1; i< argc; i++) {
		if(_tcsicmp(argv[i], _T("-PMT_PID")) == 0) {
			i++;
			if(i > argc)
				goto ERROR_PARAM;

			if(_stscanf_s(argv[i], _T("%x"), &PMTPid) <= 0)
				goto ERROR_PARAM;

			continue;
		}
		else if(_tcsicmp(argv[i], _T("-format")) == 0) {
			i++;
			if(i > argc)
				goto ERROR_PARAM;

			if(_tcsicmp(argv[i], _T("srt")) == 0) {
				format = FORMAT_SRT;
			}
			else if(_tcsicmp(argv[i], _T("ass")) == 0) {
				format = FORMAT_ASS;
			}
			else
				goto ERROR_PARAM;

			continue;
		}

		if(!pFileName) {
			pFileName = argv[i];
			continue;
		}

		if(!pTargetFileName) {
			pTargetFileName = argv[i];
			continue;
		}
	}

	// Initialize Caption Utility.
	CCaptionDllUtil capUtil;

	if(capUtil.Initialize() != NO_ERR) {
		_tMyPrintf(_T("Load Caption.dll failed\r\n"));
		return 1;
	}
	
	// Initialize ASS filename.
	if(!pTargetFileName) {
		pTargetFileName = new TCHAR[MAX_PATH];
		memset(pTargetFileName, 0, sizeof(TCHAR) * MAX_PATH);

		_tcscat(pTargetFileName, pFileName);

		TCHAR *pExt = PathFindExtension(pTargetFileName);

		if(format == FORMAT_ASS)
			_tcscpy(pExt, _T(".ass"));
		else if(format == FORMAT_SRT)
			_tcscpy(pExt, _T(".srt"));
	}

	_tMyPrintf(_T("[Source] %s\r\n\r\n"), pFileName);
	_tMyPrintf(_T("[Target] %s\r\n\r\n"), pTargetFileName);
	if(format == FORMAT_SRT) {
		_tMyPrintf(_T("[Format] %s\r\n\r\n"), _T("srt"));
	}
	else if(format == FORMAT_ASS) {
		_tMyPrintf(_T("[Format] %s\r\n\r\n"), _T("ass"));
	}

	// Open TS File
	FILE *fp = _tfopen(pFileName, _T("rb"));
	if(!fp) {
		_tMyPrintf(_T("Open TS File: %s failed\r\n"), pFileName);
		goto EXIT;
	}

	// Open ASS File
	FILE *fp2 = _tfopen(pTargetFileName, _T("wb"));
	if(!fp2) {
		_tMyPrintf(_T("Open .ASS File: %s failed\r\n"), pTargetFileName);
		goto EXIT;
	}

#ifdef _DEBUG
	_tcscat(pTargetFileName, _T(".log"));
	FILE *fp3 = _tfopen(pTargetFileName, _T("wb"));

#endif

	// Writes UTF-8 Tag
	unsigned char tag[] = {0xEF, 0xBB, 0xBF};
	fwrite(tag, 3, 1, fp2);

	// Writes .ass header & template style
	if(format == FORMAT_ASS)
		fprintf(fp2, "%s", ASS_HEADER);

	if(!FindStartOffset(fp)) {
		_tMyPrintf(_T("Invalid TS File.\r\n"));
		goto EXIT;
	}

	BYTE pbPacket[188] = {0};

	while(fread(pbPacket, 188, 1, fp) == 1) {

		unsigned char ucSync = pbPacket[0];
		unsigned char ucTsErr = (pbPacket[1]&0x80)>>7;
		unsigned char ucPayloadStartFlag = (pbPacket[1]&0x40)>>6;
		unsigned char ucPriority = (pbPacket[1]&0x20)>>5;
		unsigned short usPID = ((unsigned short)(pbPacket[1]&0x1F))<<8 | pbPacket[2];
		unsigned char ucScramble = (pbPacket[3]&0xC0)>>6;
		unsigned char ucAdaptFlag = (pbPacket[3]&0x20)>>5;
		unsigned char ucPayloadFlag = (pbPacket[3]&0x10)>>4;
		unsigned char ucCounter = (pbPacket[3]&0x0F);

		if(ucTsErr)
			continue;

		// PAT
		if(usPID == 0 && (PMTPid == 0 || bPrintPMT)) {
			PBYTE pData = pbPacket + 13;

			do {
				// Copy From BonDriver
				WORD wProgramID	= ((WORD)pData[0] << 8) | (WORD)pData[1];				// +1,2
				WORD wPID		= ((WORD)(pData[2] & 0x1FU) << 8) | (WORD)pData[3];		// +3,4

				if(wProgramID == 0xFFFF)
					break;

				_tMyPrintf(_T("Program %d, PID: %x\r\n"), wProgramID, wPID);

				if(wProgramID != 0 && PMTPid == 0) {
					PMTPid = wPID;
				}

				pData += 4;

			}while(pData < pbPacket + 188);

			bPrintPMT = FALSE;

			_tMyPrintf(_T("Set PMT_PID to %x\r\n"), PMTPid);
			_tMyPrintf(_T("Press any key to start\r\n"));
			getchar();

			continue; // next packet
		}

		// PMT
		if(PMTPid != 0 && usPID == PMTPid) {

			if(PCRPid == 0) {
				PCRPid = pbPacket[13] & 0x07;
				PCRPid = PCRPid << 8;
				PCRPid += pbPacket[14];
			}

			PBYTE pData = pbPacket + 15;
			BYTE high = pData[0] % 0x10;
			pData++;
			BYTE low = pData[0];
			INT length = high * 0x100 + low;
			pData += length + 1;

			while(pData < pbPacket + 184) {

				// Copy From BonDriver
				BYTE byStreamTypeID = pData[0];													// +0
				WORD wEsPID = ((WORD)(pData[1] & 0x1FU) << 8) | (WORD)pData[2];					// +1,2	
				WORD wDescLen = ((WORD)(pData[3] & 0x0FU) << 8) | (WORD)pData[4];				// +3,4

				if(byStreamTypeID == 0x6) {
					CaptionPid = wEsPID;
					break;
				}

				pData += (wDescLen + 5);
			}

			continue; // next packet
		}

		long long PCR = 0;
		//BOOL bPCR = FALSE;

		if(usPID == PCRPid) {
			/*     90kHz           27kHz
			 *  +--------+-------+-------+
			 *  | 33 bits| 6 bits| 9 bits|
			 *  +--------+-------+-------+
			 */

			PCR = (pbPacket[6] << 25) | (pbPacket[7] << 17) | (pbPacket[8] << 9) | (pbPacket[9] << 1) | (pbPacket[10] / 128) ;

			DWORD ext = (pbPacket[10] % 2) * 256 + pbPacket[11];

			PCR = PCR / 90;
			//bPCR = TRUE;

			if(startPCR == 0) {
				startPCR = PCR;
				lastPCR = PCR;
			}
			else if(startPCR > 0) {
				if(startPCR > PCR)
					PCR += startPCR;

				else if(PCR > startPCR && (PCR - startPCR) < 500)
					lastPCR = PCR;
			}

			continue; // next packet
		}

		if(CaptionPid != 0 && usPID == CaptionPid) {
			long long PTS = 0;

			// Get Caption PTS.
			if(ucPayloadStartFlag) {
				PTS = GetPTS(pbPacket);
				if(!PTS) {
					PTS = lastPCR;
				}

				unsigned short sH, sM, sS, sMs;

				sMs = (int)(PTS - startPCR) % 100;
				sS = (int)((PTS - startPCR) / 1000) % 60;
				sM = (int)((PTS - startPCR) / (1000 * 60)) % 60;
				sH = (int)((PTS - startPCR) / (1000 * 60 *60));

				if(sS == 0)
					int a = 0;

				_tMyPrintf(_T("Caption Time: %01d:%02d:%02d.%02d\r\n"), sH, sM, sS, sMs);
			}
			else {
				PTS = lastPTS;
			}

			lastPTS = PTS;

			// parse caption;

			int ret = capUtil.AddTSPacket(pbPacket);

			if(ret == CHANGE_VERSION) {
				std::vector<LANG_TAG_INFO> tagInfoList;
				ret = capUtil.GetTagInfo(&tagInfoList);
			}
			else if(ret == NO_ERR_CAPTION) {

				std::vector<CAPTION_DATA> Captions;
				ret = capUtil.GetCaptionData(0, &Captions);

				std::vector<CAPTION_DATA>::iterator it = Captions.begin();
				for(;it != Captions.end(); it++) {
					CHAR strUTF8[1024] = {0};

					if(it->bClear) {
						if(format == FORMAT_ASS)
							DumpAssLine(fp2, &srtList, (PTS + it->dwWaitTime) - startPCR);
						else if(format == FORMAT_SRT)
							DumpSrtLine(fp2, &srtList, (PTS + it->dwWaitTime) - startPCR);

						continue;
					}
					else {

						std::vector<CAPTION_CHAR_DATA>::iterator it2 = it->CharList.begin();
						for(;it2 != it->CharList.end(); it2++) {
							// ӂ肪 Skip
							if(it2->emCharSizeMode == STR_SMALL)
								continue;
#ifdef _DEBUG
							if(fp3)
								fprintf(fp3, "%s\r\n", it2->strDecode.c_str());
#endif

							WCHAR str[1024] = {0};
							CHAR strUTF8_2[1024] = {0};
							
							// CP 932 to UTF-8
							MultiByteToWideChar(932, 0, it2->strDecode.c_str(), -1, str, 1024);
							WideCharToMultiByte(CP_UTF8, 0, str, -1, strUTF8_2, 1024, NULL, NULL);

							strcat(strUTF8, strUTF8_2);
						}

						PSRT_LINE pSrtLine = new SRT_LINE();
						pSrtLine->index = 0;	//useless
						pSrtLine->startTime = PTS - startPCR;
						pSrtLine->endTime = 0;
						pSrtLine->str = strUTF8;
						if(pSrtLine->str == ""){
							delete pSrtLine;
							continue;
						}

						srtList.push_back(pSrtLine);
					} //if(it->bClear)

				} // for(;it != Captions.end(); it++)

			} //else if(ret == NO_ERR_CAPTION)

		} //if(CaptionPid != 0 && usPID == CaptionPid)

	} //while(fread(pbPacket, 188, 1, fp) == 1)

EXIT:
	if(fp)
		fclose(fp);

	if(fp2)
		fclose(fp2);

#ifdef _DEBUG
	if(fp3)
		fclose(fp3);
#endif
	return 0;
}

