class HookConfig
  def initialize(project)
    @project = project
  end

  def filename
    @filename = @project.repository_path + "/hooks/hook_config.yml"
  end

  def config
    @config ||= (exists? ? YAML.load_file(filename) : {
      "pre_commit" => nil,
      "post_commit" => {
        "fetch_changesets" => nil,
        "perform_build" => {"jobs" => []}
      }
    })
  end

  def save
    File.open(filename, "w") {|f|
      f.print(config.to_yaml)
    }
  end

  def exists?
    File.file?(filename)
  end

  def [](key)
    config[key]
  end
end
