/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.color;

import java.awt.Color;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;

public class ColorBlindColorScheme
extends BaseColorScheme {
    public double[][] _rgbToLms = new double[][]{{0.05059983, 0.08585369, 0.0095242}, {0.01893033, 0.08925308, 0.01370054}, {0.00292202, 0.00975732, 0.07145979}};
    public double[][] _lmsToRgb = new double[][]{{30.830854, -29.832659, 1.610474}, {-6.481468, 17.715578, -2.532642}, {-0.37569, -1.199062, 14.273846}};
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private ColorScheme origScheme;

    public ColorBlindColorScheme(ColorScheme origScheme, BlindnessKind kind) {
        this.origScheme = origScheme;
        this.foregroundColor = SubstanceColorUtilities.getColorBlindColor(origScheme.getForegroundColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainUltraDarkColor = SubstanceColorUtilities.getColorBlindColor(origScheme.getUltraDarkColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainDarkColor = SubstanceColorUtilities.getColorBlindColor(origScheme.getDarkColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainMidColor = SubstanceColorUtilities.getColorBlindColor(origScheme.getMidColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainLightColor = SubstanceColorUtilities.getColorBlindColor(origScheme.getLightColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainExtraLightColor = SubstanceColorUtilities.getColorBlindColor(origScheme.getExtraLightColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainUltraLightColor = SubstanceColorUtilities.getColorBlindColor(origScheme.getUltraLightColor(), this._rgbToLms, kind, this._lmsToRgb);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    public Color getLightColor() {
        return this.mainLightColor;
    }

    public Color getMidColor() {
        return this.mainMidColor;
    }

    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public ColorScheme getOrigScheme() {
        return this.origScheme;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlindnessKind {
        PROTANOPIA,
        DEUTERANOPIA,
        TRITANOPIA;

    }
}

