/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.DatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordNumberBinding
implements EntryBinding<Long> {
    @Override
    public Long entryToObject(DatabaseEntry entry) {
        return RecordNumberBinding.entryToRecordNumber(entry);
    }

    @Override
    public void objectToEntry(Long object, DatabaseEntry entry) {
        RecordNumberBinding.recordNumberToEntry(object, entry);
    }

    public static long entryToRecordNumber(DatabaseEntry entry) {
        return (long)DbCompat.getRecordNumber(entry) & 0xFFFFFFFFL;
    }

    public static void recordNumberToEntry(long recordNumber, DatabaseEntry entry) {
        entry.setData(new byte[4], 0, 4);
        DbCompat.setRecordNumber(entry, (int)recordNumber);
    }
}

