/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.opends.admin.ads.util.OpendsCertificateException;
import org.opends.server.util.Platform;

public class ApplicationTrustManager
implements X509TrustManager {
    private static final Logger LOG = Logger.getLogger(ApplicationTrustManager.class.getName());
    private X509TrustManager trustManager;
    private String lastRefusedAuthType;
    private X509Certificate[] lastRefusedChain;
    private Cause lastRefusedCause = null;
    private KeyStore keystore = null;
    private ArrayList<X509Certificate[]> acceptedChains = new ArrayList();
    private ArrayList<String> acceptedAuthTypes = new ArrayList();
    private ArrayList<String> acceptedHosts = new ArrayList();
    private String host;

    public ApplicationTrustManager(KeyStore keyStore) {
        TrustManagerFactory trustManagerFactory = null;
        this.keystore = keyStore;
        String string = System.getProperty("org.opends.admin.trustmanageralgo");
        String string2 = System.getProperty("org.opends.admin.trustmanagerprovider");
        if (string == null && Platform.isVendor("IBM")) {
            string = "IbmX509";
        }
        if (string2 == null && Platform.isVendor("IBM")) {
            string2 = "IBMJSSE2";
        }
        String[] stringArray = new String[]{string2, "SunJSSE", null, null};
        String[] stringArray2 = new String[]{string, "SunX509", "SunX509", TrustManagerFactory.getDefaultAlgorithm()};
        block4: for (int i = 0; i < stringArray.length && this.trustManager == null; ++i) {
            String string3 = stringArray[i];
            String string4 = stringArray2[i];
            if (string4 == null) continue;
            try {
                trustManagerFactory = string3 != null ? TrustManagerFactory.getInstance(string4, string3) : TrustManagerFactory.getInstance(string4);
                trustManagerFactory.init(keyStore);
                TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                for (int j = 0; j < trustManagerArray.length; ++j) {
                    if (!(trustManagerArray[j] instanceof X509TrustManager)) continue;
                    this.trustManager = (X509TrustManager)trustManagerArray[j];
                    continue block4;
                }
                continue;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                LOG.log(Level.WARNING, "Error with the provider: " + string3, noSuchProviderException);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOG.log(Level.WARNING, "Error with the algorithm: " + string4, noSuchAlgorithmException);
                continue;
            }
            catch (KeyStoreException keyStoreException) {
                LOG.log(Level.WARNING, "Error with the keystore", keyStoreException);
            }
        }
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        try {
            if (this.trustManager != null) {
                try {
                    this.trustManager.checkClientTrusted(x509CertificateArray, string);
                }
                catch (CertificateException certificateException) {
                    this.verifyAcceptedCertificates(x509CertificateArray, string);
                    bl = true;
                }
            } else {
                this.verifyAcceptedCertificates(x509CertificateArray, string);
                bl = true;
            }
        }
        catch (CertificateException certificateException) {
            this.lastRefusedChain = x509CertificateArray;
            this.lastRefusedAuthType = string;
            this.lastRefusedCause = Cause.NOT_TRUSTED;
            OpendsCertificateException opendsCertificateException = new OpendsCertificateException(x509CertificateArray);
            opendsCertificateException.initCause(certificateException);
            throw opendsCertificateException;
        }
        if (!bl) {
            try {
                this.verifyHostName(x509CertificateArray, string);
            }
            catch (CertificateException certificateException) {
                this.lastRefusedChain = x509CertificateArray;
                this.lastRefusedAuthType = string;
                this.lastRefusedCause = Cause.HOST_NAME_MISMATCH;
                OpendsCertificateException opendsCertificateException = new OpendsCertificateException(x509CertificateArray);
                opendsCertificateException.initCause(certificateException);
                throw opendsCertificateException;
            }
        }
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        try {
            if (this.trustManager != null) {
                try {
                    this.trustManager.checkServerTrusted(x509CertificateArray, string);
                }
                catch (CertificateException certificateException) {
                    this.verifyAcceptedCertificates(x509CertificateArray, string);
                    bl = true;
                }
            } else {
                this.verifyAcceptedCertificates(x509CertificateArray, string);
                bl = true;
            }
        }
        catch (CertificateException certificateException) {
            this.lastRefusedChain = x509CertificateArray;
            this.lastRefusedAuthType = string;
            this.lastRefusedCause = Cause.NOT_TRUSTED;
            OpendsCertificateException opendsCertificateException = new OpendsCertificateException(x509CertificateArray);
            opendsCertificateException.initCause(certificateException);
            throw opendsCertificateException;
        }
        if (!bl) {
            try {
                this.verifyHostName(x509CertificateArray, string);
            }
            catch (CertificateException certificateException) {
                this.lastRefusedChain = x509CertificateArray;
                this.lastRefusedAuthType = string;
                this.lastRefusedCause = Cause.HOST_NAME_MISMATCH;
                OpendsCertificateException opendsCertificateException = new OpendsCertificateException(x509CertificateArray);
                opendsCertificateException.initCause(certificateException);
                throw opendsCertificateException;
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        if (this.trustManager != null) {
            return this.trustManager.getAcceptedIssuers();
        }
        return new X509Certificate[0];
    }

    public void acceptCertificate(X509Certificate[] x509CertificateArray, String string, String string2) {
        this.acceptedChains.add(x509CertificateArray);
        this.acceptedAuthTypes.add(string);
        this.acceptedHosts.add(string2);
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void resetLastRefusedItems() {
        this.lastRefusedAuthType = null;
        this.lastRefusedChain = null;
        this.lastRefusedCause = null;
    }

    public ApplicationTrustManager createCopy() {
        ApplicationTrustManager applicationTrustManager = new ApplicationTrustManager(this.keystore);
        applicationTrustManager.lastRefusedAuthType = this.lastRefusedAuthType;
        applicationTrustManager.lastRefusedChain = this.lastRefusedChain;
        applicationTrustManager.lastRefusedCause = this.lastRefusedCause;
        applicationTrustManager.acceptedChains.addAll(this.acceptedChains);
        applicationTrustManager.acceptedAuthTypes.addAll(this.acceptedAuthTypes);
        applicationTrustManager.acceptedHosts.addAll(this.acceptedHosts);
        applicationTrustManager.host = this.host;
        return applicationTrustManager;
    }

    private void verifyAcceptedCertificates(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        for (int i = 0; i < this.acceptedChains.size() && !bl; ++i) {
            if (!string.equals(this.acceptedAuthTypes.get(i))) continue;
            X509Certificate[] x509CertificateArray2 = this.acceptedChains.get(i);
            bl = x509CertificateArray2.length == x509CertificateArray.length;
            for (int j = 0; j < x509CertificateArray.length && bl; ++j) {
                bl = x509CertificateArray[j].equals(x509CertificateArray2[j]);
            }
        }
        if (!bl) {
            throw new OpendsCertificateException("Certificate not in list of accepted certificates", x509CertificateArray);
        }
    }

    private void verifyHostName(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (this.host != null) {
            boolean bl = false;
            try {
                LdapName ldapName = new LdapName(x509CertificateArray[0].getSubjectX500Principal().getName());
                Rdn rdn = ldapName.getRdn(ldapName.getRdns().size() - 1);
                String string2 = rdn.getValue().toString();
                bl = this.hostMatch(string2, this.host);
                if (!bl) {
                    LOG.log(Level.WARNING, "Subject DN RDN value is: " + string2 + " and does not match host value: " + this.host);
                    for (int i = 0; i < this.acceptedHosts.size() && !bl; ++i) {
                        if (!this.hostMatch(this.acceptedHosts.get(i), this.host)) continue;
                        X509Certificate[] x509CertificateArray2 = this.acceptedChains.get(i);
                        bl = x509CertificateArray2.length == x509CertificateArray.length;
                        for (int j = 0; j < x509CertificateArray.length && bl; ++j) {
                            bl = x509CertificateArray[j].equals(x509CertificateArray2[j]);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                LOG.log(Level.WARNING, "Error parsing subject dn: " + x509CertificateArray[0].getSubjectX500Principal(), throwable);
            }
            if (!bl) {
                throw new OpendsCertificateException("Hostname mismatch between host name " + this.host + " and subject DN: " + x509CertificateArray[0].getSubjectX500Principal(), x509CertificateArray);
            }
        }
    }

    public String getLastRefusedAuthType() {
        return this.lastRefusedAuthType;
    }

    public Cause getLastRefusedCause() {
        return this.lastRefusedCause;
    }

    public X509Certificate[] getLastRefusedChain() {
        return this.lastRefusedChain;
    }

    private boolean hostMatch(String string, String string2) {
        String[] stringArray;
        if (string == null) {
            throw new IllegalArgumentException("The host1 parameter cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The host2 parameter cannot be null");
        }
        String[] stringArray2 = string.split("\\.");
        boolean bl = stringArray2.length == (stringArray = string2.split("\\.")).length;
        for (int i = 0; i < stringArray2.length && bl; ++i) {
            if (stringArray2[i].equals("*") || stringArray.equals("*")) continue;
            bl = stringArray2[i].equalsIgnoreCase(stringArray[i]);
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cause {
        NOT_TRUSTED,
        HOST_NAME_MISMATCH;

    }
}

