/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.admin.ads.ADSContext;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.Configuration;
import org.opends.quicksetup.Status;
import org.opends.quicksetup.util.Utils;

public class Installation {
    public static final String[] OPEN_DS_JAR_RELATIVE_PATHS = new String[]{"lib/quicksetup.jar", "lib/OpenDS.jar", "lib/je.jar"};
    public static final String WINDOWS_BINARIES_PATH_RELATIVE = "bat";
    public static final String UNIX_BINARIES_PATH_RELATIVE = "bin";
    public static final String MAC_APPLICATIONS_PATH_RELATIVE = "bin";
    public static final String LIBRARIES_PATH_RELATIVE = "lib";
    public static final String RESOURCES_PATH_RELATIVE = "resources";
    public static final String CLASSES_PATH_RELATIVE = "classes";
    public static final String DATABASES_PATH_RELATIVE = "db";
    public static final String LOGS_PATH_RELATIVE = "logs";
    public static final String LDIFS_PATH_RELATIVE = "ldif";
    public static final String BACKUPS_PATH_RELATIVE = "bak";
    public static final String CONFIG_PATH_RELATIVE = "config";
    public static final String HISTORY_PATH_RELATIVE = "history";
    public static final String UPGRADE_PATH = "upgrade";
    public static final String CHANGELOG_PATH_RELATIVE = "changelogDb";
    public static final String LOCKS_PATH_RELATIVE = "locks";
    public static final String TMP_PATH_RELATIVE = "tmp";
    public static final String CURRENT_CONFIG_FILE_NAME = "config.ldif";
    public static final String BASE_CONFIG_FILE_PREFIX = "config.ldif.";
    public static final String TOOLS_PROPERTIES = "config" + File.separator + "tools.properties";
    public static final String DEFAULT_INSTANCE_PATH = "/var/opends";
    public static final String INSTANCE_LOCATION_PATH_RELATIVE = "instance.loc";
    public static final String INSTANCE_LOCATION_PATH = "/etc/opends/instance.loc";
    public static final String TMPL_INSTANCE_RELATIVE_PATH = "tmpl_instance";
    public static final String BUILDINFO_RELATIVE_PATH = "buildinfo";
    public static final String UNIX_SETUP_FILE_NAME = "setup";
    public static final String WINDOWS_SETUP_FILE_NAME = "setup.bat";
    public static final String UNIX_UNINSTALL_FILE_NAME = "uninstall";
    public static final String WINDOWS_UNINSTALL_FILE_NAME = "uninstall.bat";
    public static final String UNIX_UPGRADE_FILE_NAME = "upgrade";
    public static final String WINDOWS_UPGRADE_FILE_NAME = "upgrade.bat";
    public static final String UNIX_CONFIGURE_FILE_NAME = "configure";
    public static final String WINDOWS_UPGRADE_FILE_NAME_NEW = "upgrade.bat.NEW";
    public static final String UNIX_START_FILE_NAME = "start-ds";
    public static final String WINDOWS_START_FILE_NAME = "start-ds.bat";
    public static final String UNIX_STOP_FILE_NAME = "stop-ds";
    public static final String WINDOWS_STOP_FILE_NAME = "stop-ds.bat";
    public static final String UNIX_CONTROLPANEL_FILE_NAME = "control-panel";
    public static final String WINDOWS_CONTROLPANEL_FILE_NAME = "control-panel.bat";
    public static final String UNIX_DSJAVAPROPERTIES_FILE_NAME = "dsjavaproperties";
    public static final String WINDOWS_DSJAVAPROPERTIES_FILE_NAME = "dsjavaproperties.bat";
    public static final String MAC_JAVA_APP_STUB_NAME = "JavaApplicationStub";
    public static final String MAC_CONTROLPANEL_FILE_NAME = "ControlPanel.app";
    public static final String UNIX_STATUSCLI_FILE_NAME = "status";
    public static final String WINDOWS_STATUSCLI_FILE_NAME = "status.bat";
    public static final String HISTORY_LOG_FILE_NAME = "log";
    public static final String HISTORY_BACKUP_FILES_DIR_INSTALL = "install";
    public static final String HISTORY_BACKUP_FILES_DIR_INSTANCE = "instance";
    public static final String HISTORY_BACKUP_FILES_DIR_NAME = "files";
    public static final String BACKUP = "backup";
    public static final String LDIF_DIFF = "ldif-diff";
    public static final String DEFAULT_JAVA_PROPERTIES_FILE = "java.properties";
    public static final String RELATIVE_JAVA_PROPERTIES_FILE = "config" + File.separator + "java.properties";
    public static final String SET_JAVA_PROPERTIES_FILE_WINDOWS = "set-java-home.bat";
    public static final String SCRIPT_UTIL_FILE_UNIX = "_script-util.sh";
    public static final String SCRIPT_UTIL_FILE_WINDOWS = "_script-util.bat";
    public static final String SET_JAVA_PROPERTIES_FILE_UNIX = "set-java-home";
    public static final String[] REQUIRED_DIRECTORIES = new String[]{"config", "db", "lib"};
    private static Installation local;
    private static final Logger LOG;
    private File rootDirectory;
    private File instanceDirectory;
    private Status status;
    private Configuration configuration;
    private Configuration baseConfiguration;
    private BuildInformation buildInformation;
    private BuildInformation instanceInformation;
    private boolean instanceAndInstallInSameDir;

    public static void validateRootDirectory(File rootDirectory) throws IllegalArgumentException {
        Message failureReason = null;
        if (rootDirectory == null) {
            failureReason = QuickSetupMessages.INFO_ERROR_INSTALL_ROOT_DIR_NULL.get();
        } else if (!rootDirectory.exists()) {
            failureReason = QuickSetupMessages.INFO_ERROR_INSTALL_ROOT_DIR_NO_EXIST.get(Utils.getPath(rootDirectory));
        } else if (!rootDirectory.isDirectory()) {
            failureReason = QuickSetupMessages.INFO_ERROR_INSTALL_ROOT_DIR_NOT_DIR.get(Utils.getPath(rootDirectory));
        } else {
            String[] children = rootDirectory.list();
            if (children != null) {
                HashSet<String> childrenSet = new HashSet<String>(Arrays.asList(children));
                for (String dir : REQUIRED_DIRECTORIES) {
                    if (childrenSet.contains(dir)) continue;
                    failureReason = QuickSetupMessages.INFO_ERROR_INSTALL_ROOT_DIR_NO_DIR.get(Utils.getPath(rootDirectory), dir);
                }
            } else {
                failureReason = QuickSetupMessages.INFO_ERROR_INSTALL_ROOT_DIR_EMPTY.get(Utils.getPath(rootDirectory));
            }
        }
        if (failureReason != null) {
            throw new IllegalArgumentException(failureReason.toString());
        }
    }

    public static Installation getLocal() {
        if (local == null) {
            String installRoot = System.getProperty("org.opends.quicksetup.Root");
            String instanceRoot = System.getProperty("org.opends.quicksetup.instance");
            if (installRoot == null) {
                installRoot = Utils.getInstallPathFromClasspath();
            }
            if (instanceRoot == null) {
                instanceRoot = Utils.getInstancePathFromClasspath(installRoot);
            }
            local = new Installation(installRoot, instanceRoot);
        }
        return local;
    }

    public Installation(String rootDirectory, String instanceRootDirectory) {
        this(new File(rootDirectory), new File(instanceRootDirectory));
    }

    public Installation(File rootDirectory, File instanceDirectory) {
        this.setRootDirectory(rootDirectory);
        this.setInstanceDirectory(instanceDirectory);
        try {
            this.instanceAndInstallInSameDir = rootDirectory.getCanonicalFile().equals(instanceDirectory.getCanonicalFile());
        }
        catch (Throwable t) {
            this.instanceAndInstallInSameDir = rootDirectory.getAbsolutePath().equals(instanceDirectory.getAbsolutePath());
        }
    }

    public boolean instanceAndInstallInSameDir() {
        return this.instanceAndInstallInSameDir;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public File getInstanceDirectory() {
        return this.instanceDirectory;
    }

    public File getTmplInstanceDirectory() {
        File f = new File(this.getRootDirectory().getAbsolutePath() + File.separator + TMPL_INSTANCE_RELATIVE_PATH);
        if (f.exists()) {
            return f;
        }
        return this.getInstanceDirectory();
    }

    public void setRootDirectory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
        if (this.isValid(rootDirectory)) {
            try {
                BuildInformation bi = this.getBuildInformation();
                LOG.log(Level.INFO, "build info for " + rootDirectory.getName() + ": " + bi);
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "error determining build information", e);
            }
        }
    }

    public void setInstanceDirectory(File instanceDirectory) {
        this.instanceDirectory = instanceDirectory;
        if (this.isValid(instanceDirectory)) {
            try {
                BuildInformation bi = this.getBuildInformation();
                LOG.log(Level.INFO, "build info for " + instanceDirectory.getName() + ": " + bi);
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "error determining build information", e);
            }
        }
    }

    public boolean isValid(File file) {
        boolean valid = true;
        try {
            Installation.validateRootDirectory(file);
        }
        catch (IllegalArgumentException e) {
            valid = false;
        }
        return valid;
    }

    public String getInvalidityReason() {
        String reason = null;
        try {
            Installation.validateRootDirectory(this.rootDirectory);
        }
        catch (IllegalArgumentException e) {
            reason = e.getLocalizedMessage();
        }
        return reason;
    }

    public Configuration getCurrentConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration(this, this.getCurrentConfigurationFile());
        }
        return this.configuration;
    }

    public Configuration getBaseConfiguration() throws ApplicationException {
        if (this.baseConfiguration == null) {
            this.baseConfiguration = new Configuration(this, this.getBaseConfigurationFile());
        }
        return this.baseConfiguration;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status(this);
        }
        return this.status;
    }

    public File getLibrariesDirectory() {
        return new File(this.getRootDirectory(), LIBRARIES_PATH_RELATIVE);
    }

    public File getResourcesDirectory() {
        return new File(this.getRootDirectory(), RESOURCES_PATH_RELATIVE);
    }

    public File getClassesDirectory() {
        return new File(this.getRootDirectory(), CLASSES_PATH_RELATIVE);
    }

    public File getToolsPropertiesFile() {
        return new File(this.getTmplInstanceDirectory(), TOOLS_PROPERTIES);
    }

    public File getSetJavaHomeFile() {
        return new File(this.getInstanceDirectory().getAbsolutePath() + File.separator + LIBRARIES_PATH_RELATIVE, Utils.isWindows() ? SET_JAVA_PROPERTIES_FILE_WINDOWS : SET_JAVA_PROPERTIES_FILE_UNIX);
    }

    public File getSchemaConcatFile() {
        return new File(this.getConfigurationUpgradeDirectory(), "schema.ldif.current");
    }

    public File getBaseSchemaFile() throws ApplicationException {
        return new File(this.getConfigurationUpgradeDirectory(), "schema.ldif." + this.getInstanceSvnRev().toString());
    }

    public File getTemplSchemaFile() throws ApplicationException {
        return new File(this.getTmplInstanceDirectory().getAbsolutePath() + File.separator + CONFIG_PATH_RELATIVE + File.separator + "upgrade", "schema.ldif." + this.getSvnRev().toString());
    }

    public File getTemplConfigFile() throws ApplicationException {
        return new File(this.getTmplInstanceDirectory().getAbsolutePath() + File.separator + CONFIG_PATH_RELATIVE + File.separator + "upgrade", BASE_CONFIG_FILE_PREFIX + this.getSvnRev().toString());
    }

    public File getBaseConfigurationFile() throws ApplicationException {
        return new File(this.getConfigurationUpgradeDirectory(), BASE_CONFIG_FILE_PREFIX + this.getInstanceSvnRev().toString());
    }

    public Integer getSvnRev() throws ApplicationException {
        BuildInformation bi = this.getBuildInformation();
        return bi.getRevisionNumber();
    }

    public Integer getInstanceSvnRev() throws ApplicationException {
        BuildInformation bi = this.getInstanceBuildInformation();
        return bi.getRevisionNumber();
    }

    public File getCurrentConfigurationFile() {
        return new File(this.getConfigurationDirectory(), CURRENT_CONFIG_FILE_NAME);
    }

    public File getADSBackendFile() {
        return new File(this.getTmplInstanceDirectory(), ADSContext.getAdminLDIFFile());
    }

    public File getBinariesDirectory() {
        File binPath = Utils.isWindows() ? new File(this.getRootDirectory(), WINDOWS_BINARIES_PATH_RELATIVE) : new File(this.getRootDirectory(), "bin");
        return binPath;
    }

    public File getDatabasesDirectory() {
        return new File(this.getInstanceDirectory(), DATABASES_PATH_RELATIVE);
    }

    public File getBackupDirectory() {
        return new File(this.getInstanceDirectory(), BACKUPS_PATH_RELATIVE);
    }

    public File getConfigurationDirectory() {
        return new File(this.getInstanceDirectory(), CONFIG_PATH_RELATIVE);
    }

    public File getInstallConfigurationDirectory() {
        return new File(this.getRootDirectory(), CONFIG_PATH_RELATIVE);
    }

    public File getLogsDirectory() {
        return new File(this.getInstanceDirectory(), LOGS_PATH_RELATIVE);
    }

    public File getLocksDirectory() {
        return new File(this.getInstanceDirectory(), LOCKS_PATH_RELATIVE);
    }

    public File getTemporaryDirectory() {
        return new File(this.getInstanceDirectory(), TMP_PATH_RELATIVE);
    }

    public File getHistoryDirectory() {
        return new File(this.getInstanceDirectory(), HISTORY_PATH_RELATIVE);
    }

    public File createHistoryBackupDirectory() throws IOException {
        File backupDirectory = new File(this.getHistoryDirectory(), Long.toString(System.currentTimeMillis()));
        if (backupDirectory.exists()) {
            backupDirectory.delete();
        }
        if (!backupDirectory.mkdirs()) {
            throw new IOException("failed to create history backup directory");
        }
        return backupDirectory;
    }

    public File getHistoryLogFile() {
        return new File(this.getHistoryDirectory(), HISTORY_LOG_FILE_NAME);
    }

    public File getConfigurationUpgradeDirectory() {
        return new File(this.getConfigurationDirectory(), "upgrade");
    }

    public File getTemporaryUpgradeDirectory() {
        return new File(this.getTemporaryDirectory(), "upgrade");
    }

    public File getCommandFile(String command) {
        File commandFile = Utils.isWindows() ? new File(this.getBinariesDirectory(), command + ".bat") : new File(this.getBinariesDirectory(), command);
        return commandFile;
    }

    public File getServerStartCommandFile() {
        File startCommandFile = Utils.isWindows() ? new File(this.getBinariesDirectory(), WINDOWS_START_FILE_NAME) : new File(this.getBinariesDirectory(), UNIX_START_FILE_NAME);
        return startCommandFile;
    }

    public File getServerStopCommandFile() {
        File stopCommandFile = Utils.isWindows() ? new File(this.getBinariesDirectory(), WINDOWS_STOP_FILE_NAME) : new File(this.getBinariesDirectory(), UNIX_STOP_FILE_NAME);
        return stopCommandFile;
    }

    public File getLdifDirectory() {
        return new File(this.getRootDirectory(), LDIFS_PATH_RELATIVE);
    }

    public File getQuicksetupJarFile() {
        return new File(this.getLibrariesDirectory(), "quicksetup.jar");
    }

    public File getOpenDSJarFile() {
        return new File(this.getLibrariesDirectory(), "OpenDS.jar");
    }

    public File getUninstallBatFile() {
        return new File(this.getRootDirectory(), WINDOWS_UNINSTALL_FILE_NAME);
    }

    public File getControlPanelCommandFile() {
        File controlPanelCommandFile = Utils.isWindows() ? new File(this.getBinariesDirectory(), WINDOWS_CONTROLPANEL_FILE_NAME) : (Utils.isMacOS() ? new File(this.getRootDirectory() + File.separator + "bin", MAC_CONTROLPANEL_FILE_NAME) : new File(this.getBinariesDirectory(), UNIX_CONTROLPANEL_FILE_NAME));
        return controlPanelCommandFile;
    }

    public File getStatusCommandFile() {
        File statusPanelCommandFile = Utils.isWindows() ? new File(this.getBinariesDirectory(), WINDOWS_STATUSCLI_FILE_NAME) : new File(this.getBinariesDirectory(), UNIX_STATUSCLI_FILE_NAME);
        return statusPanelCommandFile;
    }

    public File getJavaPropertiesCommandFile() {
        File javaPropertiesCommandFile = Utils.isWindows() ? new File(this.getBinariesDirectory(), WINDOWS_DSJAVAPROPERTIES_FILE_NAME) : new File(this.getBinariesDirectory(), UNIX_DSJAVAPROPERTIES_FILE_NAME);
        return javaPropertiesCommandFile;
    }

    public BuildInformation getBuildInformation() throws ApplicationException {
        return this.getBuildInformation(true);
    }

    public BuildInformation getBuildInformation(boolean useCachedVersion) throws ApplicationException {
        if (this.buildInformation == null || !useCachedVersion) {
            FutureTask<BuildInformation> ft = new FutureTask<BuildInformation>(new Callable<BuildInformation>(){

                @Override
                public BuildInformation call() throws ApplicationException {
                    return BuildInformation.create(Installation.this);
                }
            });
            new Thread(ft).start();
            try {
                this.buildInformation = ft.get();
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, "interrupted trying to get build information", e);
            }
            catch (ExecutionException e) {
                throw (ApplicationException)e.getCause();
            }
        }
        return this.buildInformation;
    }

    public BuildInformation getInstanceBuildInformation() {
        return this.getInstanceBuildInformation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildInformation getInstanceBuildInformation(boolean useCachedVersion) {
        block11: {
            if (this.instanceInformation == null || !useCachedVersion) {
                try {
                    File bif = new File(this.getConfigurationDirectory(), BUILDINFO_RELATIVE_PATH);
                    if (bif.exists()) {
                        BufferedReader reader = new BufferedReader(new FileReader(bif));
                        try {
                            String line = reader.readLine();
                            this.instanceInformation = BuildInformation.fromBuildString(line);
                            break block11;
                        }
                        finally {
                            try {
                                reader.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                    return this.getBuildInformation();
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "error getting build information for current instance", e);
                }
            }
        }
        return this.instanceInformation;
    }

    static {
        LOG = Logger.getLogger(Installation.class.getName());
    }
}

