/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer;

import java.io.File;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.installer.offline.OfflineInstaller;
import org.opends.quicksetup.util.IncompatibleVersionException;
import org.opends.quicksetup.util.Utils;
import org.opends.server.tools.InstallDS;
import org.opends.server.tools.InstallDSArgumentParser;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;

public class SetupLauncher
extends Launcher {
    private static final Logger LOG = Logger.getLogger(SetupLauncher.class.getName());
    private InstallDSArgumentParser argParser;

    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile("opends-setup-", ".log"), "org.opends.quicksetup.installer");
            QuickSetupLog.disableConsoleLogging();
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize log");
            t.printStackTrace();
        }
        new SetupLauncher(args).launch();
    }

    public SetupLauncher(String[] args) {
        super(args);
        String scriptName = Utils.isWindows() ? "setup.bat" : "setup";
        if (System.getProperty("org.opends.server.scriptName") == null) {
            System.setProperty("org.opends.server.scriptName", scriptName);
        }
        this.initializeParser();
    }

    protected void initializeParser() {
        this.argParser = new InstallDSArgumentParser(InstallDS.class.getName());
        try {
            this.argParser.initializeArguments();
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            System.out.println(message);
        }
    }

    public void launch() {
        try {
            this.argParser.parseArguments(this.args);
            if (this.argParser.isVersionArgumentPresent()) {
                System.exit(ReturnCode.PRINT_VERSION.getReturnCode());
            } else if (this.argParser.isUsageArgumentPresent() || this.argParser.usageOrVersionDisplayed()) {
                System.exit(ReturnCode.SUCCESSFUL.getReturnCode());
            } else if (this.isCli()) {
                Utils.checkJavaVersion();
                System.exit(InstallDS.mainCLI((String[])this.args));
            } else {
                this.willLaunchGui();
                int exitCode = this.launchGui(this.args);
                if (exitCode != 0) {
                    File logFile = QuickSetupLog.getLogFile();
                    if (logFile != null) {
                        this.guiLaunchFailed(logFile.toString());
                    } else {
                        this.guiLaunchFailed(null);
                    }
                    Utils.checkJavaVersion();
                    System.exit(InstallDS.mainCLI((String[])this.args));
                }
            }
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            System.err.println(message);
            System.err.println();
            System.err.println(this.argParser.getUsage());
            System.exit(ReturnCode.USER_DATA_ERROR.getReturnCode());
        }
        catch (IncompatibleVersionException ive) {
            System.err.println(ive.getMessageObject());
            System.exit(ReturnCode.JAVA_VERSION_INCOMPATIBLE.getReturnCode());
        }
    }

    public ArgumentParser getArgumentParser() {
        return this.argParser;
    }

    protected void guiLaunchFailed(String logFileName) {
        if (logFileName != null) {
            System.err.println(QuickSetupMessages.INFO_SETUP_LAUNCHER_GUI_LAUNCHED_FAILED_DETAILS.get(logFileName));
        } else {
            System.err.println(QuickSetupMessages.INFO_SETUP_LAUNCHER_GUI_LAUNCHED_FAILED.get());
        }
    }

    protected void willLaunchGui() {
        System.out.println(QuickSetupMessages.INFO_SETUP_LAUNCHER_LAUNCHING_GUI.get());
        System.setProperty("org.opends.quicksetup.Application.class", OfflineInstaller.class.getName());
    }

    protected Message getFrameTitle() {
        return Utils.getCustomizedObject("INFO_FRAME_INSTALL_TITLE", QuickSetupMessages.INFO_FRAME_INSTALL_TITLE.get(), Message.class);
    }

    protected CliApplication createCliApplication() {
        return null;
    }

    protected boolean isCli() {
        return this.argParser.isCli();
    }
}

