/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.offline;

import java.io.File;
import java.io.PrintStream;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.LicenseFile;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.SecurityOptions;
import org.opends.quicksetup.installer.InstallProgressStep;
import org.opends.quicksetup.installer.Installer;
import org.opends.quicksetup.util.FileManager;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.CertificateManager;

public class OfflineInstaller
extends Installer {
    private HashMap<InstallProgressStep, Integer> hmRatio = new HashMap();
    private HashMap<InstallProgressStep, Message> hmSummary = new HashMap();
    private ApplicationException runError;
    private static final Logger LOG = Logger.getLogger(OfflineInstaller.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.runError = null;
        PrintStream origErr = System.err;
        PrintStream origOut = System.out;
        try {
            this.initMaps();
            System.setErr(this.getApplicationErrorStream());
            System.setOut(this.getApplicationOutputStream());
            this.checkAbort();
            this.setCurrentProgressStep(InstallProgressStep.CONFIGURING_SERVER);
            this.configureServer();
            this.checkAbort();
            LicenseFile.createFileLicenseApproved();
            this.checkAbort();
            this.createData();
            this.checkAbort();
            if (Utils.isWindows() && this.getUserData().getEnableWindowsService()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.ENABLING_WINDOWS_SERVICE);
                this.enableWindowsService();
                this.checkAbort();
            }
            if (this.mustStart()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.STARTING_SERVER);
                Application.PointAdder pointAdder = new Application.PointAdder();
                if (!this.isVerbose()) {
                    this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_STARTING_NON_VERBOSE.get()));
                    pointAdder.start();
                }
                try {
                    new ServerController(this).startServer(!this.isVerbose());
                }
                catch (ApplicationException ae) {
                    throw ae;
                }
                finally {
                    if (!this.isVerbose()) {
                        pointAdder.stop();
                    }
                }
                if (!this.isVerbose()) {
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                } else {
                    this.notifyListeners(this.getLineBreak());
                }
                this.checkAbort();
            }
            if (this.mustCreateAds()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.CONFIGURING_ADS);
                this.updateADS();
                this.checkAbort();
            }
            if (this.mustConfigureReplication()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.CONFIGURING_REPLICATION);
                this.createReplicatedBackends();
                this.configureReplication();
                this.checkAbort();
            }
            if (this.mustInitializeSuffixes()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.INITIALIZE_REPLICATED_SUFFIXES);
                this.initializeSuffixes();
                this.checkAbort();
            }
            if (this.mustStop()) {
                if (this.isVerbose()) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.setCurrentProgressStep(InstallProgressStep.STOPPING_SERVER);
                if (!this.isVerbose()) {
                    this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_STOPPING_NON_VERBOSE.get()));
                }
                new ServerController(this).stopServer(!this.isVerbose());
                if (!this.isVerbose()) {
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                }
            }
            this.checkAbort();
            this.updateSummaryWithServerState(this.hmSummary);
            this.notifyListeners(this.getLineBreak());
            this.notifyListenersOfLog();
            this.setCurrentProgressStep(InstallProgressStep.FINISHED_SUCCESSFULLY);
            this.notifyListeners(null);
        }
        catch (ApplicationException ex) {
            LOG.log(Level.SEVERE, "Caught exception: " + ex, ex);
            if (ReturnCode.CANCELLED.equals(ex.getType())) {
                this.uninstall();
                this.setCurrentProgressStep(InstallProgressStep.FINISHED_CANCELED);
                this.notifyListeners(null);
            } else {
                Installation installation = this.getInstallation();
                if (installation.getStatus().isServerRunning()) {
                    try {
                        if (!this.isVerbose()) {
                            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_STOPPING_NON_VERBOSE.get()));
                        }
                        new ServerController(installation).stopServer(!this.isVerbose());
                        if (!this.isVerbose()) {
                            this.notifyListeners(this.getFormattedDoneWithLineBreak());
                        }
                    }
                    catch (Throwable t) {
                        LOG.log(Level.INFO, "error stopping server", t);
                    }
                }
                this.notifyListeners(this.getLineBreak());
                this.updateSummaryWithServerState(this.hmSummary);
                this.setCurrentProgressStep(InstallProgressStep.FINISHED_WITH_ERROR);
                Message html = this.getFormattedError(ex, true);
                this.notifyListeners(html);
                LOG.log(Level.SEVERE, "Error installing.", ex);
                this.notifyListeners(this.getLineBreak());
                this.notifyListenersOfLog();
            }
            this.runError = ex;
        }
        catch (Throwable t) {
            Installation installation = this.getInstallation();
            if (installation.getStatus().isServerRunning()) {
                try {
                    if (!this.isVerbose()) {
                        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_STOPPING_NON_VERBOSE.get()));
                    }
                    new ServerController(installation).stopServer(!this.isVerbose());
                    if (!this.isVerbose()) {
                        this.notifyListeners(this.getFormattedDoneWithLineBreak());
                    }
                }
                catch (Throwable t2) {
                    LOG.log(Level.INFO, "error stopping server", t2);
                }
            }
            this.notifyListeners(this.getLineBreak());
            this.updateSummaryWithServerState(this.hmSummary);
            this.setCurrentProgressStep(InstallProgressStep.FINISHED_WITH_ERROR);
            ApplicationException ex = new ApplicationException(ReturnCode.BUG, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t), t);
            Message msg = this.getFormattedError(ex, true);
            this.notifyListeners(msg);
            LOG.log(Level.SEVERE, "Error installing.", t);
            this.notifyListeners(this.getLineBreak());
            this.notifyListenersOfLog();
            this.runError = ex;
        }
        finally {
            System.setErr(origErr);
            System.setOut(origOut);
        }
    }

    public Integer getRatio(ProgressStep status) {
        return this.hmRatio.get(status);
    }

    public Message getSummary(ProgressStep status) {
        return this.hmSummary.get(status);
    }

    public ApplicationException getRunError() {
        return this.runError;
    }

    protected void uninstall() {
        this.notifyListeners(this.getTaskSeparator());
        if (!this.isVerbose()) {
            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_CANCELING.get()));
        } else {
            this.notifyListeners(this.getFormattedProgressWithLineBreak(QuickSetupMessages.INFO_SUMMARY_CANCELING.get()));
        }
        Installation installation = this.getInstallation();
        FileManager fm = new FileManager(this);
        if (installation.getStatus().isServerRunning()) {
            try {
                if (!this.isVerbose()) {
                    this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_STOPPING_NON_VERBOSE.get()));
                }
                new ServerController(installation).stopServer(!this.isVerbose());
                if (!this.isVerbose()) {
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                }
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "error stopping server", e);
            }
        }
        this.uninstallServices();
        try {
            File newConfig = fm.copy(installation.getBaseConfigurationFile(), installation.getConfigurationDirectory(), true);
            fm.rename(newConfig, installation.getCurrentConfigurationFile());
        }
        catch (ApplicationException ae) {
            LOG.log(Level.INFO, "failed to restore base configuration", ae);
        }
        SecurityOptions sec = this.getUserData().getSecurityOptions();
        if (sec.getEnableSSL() || sec.getEnableStartTLS()) {
            File truststore;
            File keystorePin;
            File keystore;
            if (SecurityOptions.CertificateType.SELF_SIGNED_CERTIFICATE.equals((Object)sec.getCertificateType())) {
                CertificateManager cm = new CertificateManager(this.getSelfSignedKeystorePath(), "JKS", this.getSelfSignedCertificatePwd());
                try {
                    cm.removeCertificate("server-cert");
                }
                catch (KeyStoreException e) {
                    LOG.log(Level.INFO, "Error deleting self signed certification", e);
                }
            }
            if ((keystore = new File(installation.getConfigurationDirectory(), "keystore")).exists()) {
                try {
                    fm.delete(keystore);
                }
                catch (ApplicationException e) {
                    LOG.log(Level.INFO, "Failed to delete keystore", e);
                }
            }
            if ((keystorePin = new File(installation.getConfigurationDirectory(), "keystore.pin")).exists()) {
                try {
                    fm.delete(keystorePin);
                }
                catch (ApplicationException e) {
                    LOG.log(Level.INFO, "Failed to delete keystore.pin", e);
                }
            }
            if ((truststore = new File(installation.getConfigurationDirectory(), "truststore")).exists()) {
                try {
                    fm.delete(truststore);
                }
                catch (ApplicationException e) {
                    LOG.log(Level.INFO, "Failed to delete truststore", e);
                }
            }
        }
        try {
            fm.deleteChildren(installation.getDatabasesDirectory());
        }
        catch (ApplicationException e) {
            LOG.log(Level.INFO, "Error deleting databases", e);
        }
        if (!this.isVerbose()) {
            this.notifyListeners(this.getFormattedDoneWithLineBreak());
        }
    }

    protected void initMaps() {
        this.initSummaryMap(this.hmSummary);
        HashMap<InstallProgressStep, Integer> hmTime = new HashMap<InstallProgressStep, Integer>();
        hmTime.put(InstallProgressStep.CONFIGURING_SERVER, 5);
        hmTime.put(InstallProgressStep.CREATING_BASE_ENTRY, 10);
        hmTime.put(InstallProgressStep.IMPORTING_LDIF, 20);
        hmTime.put(InstallProgressStep.IMPORTING_AUTOMATICALLY_GENERATED, 20);
        hmTime.put(InstallProgressStep.CONFIGURING_REPLICATION, 10);
        hmTime.put(InstallProgressStep.ENABLING_WINDOWS_SERVICE, 5);
        hmTime.put(InstallProgressStep.STARTING_SERVER, 10);
        hmTime.put(InstallProgressStep.STOPPING_SERVER, 5);
        hmTime.put(InstallProgressStep.CONFIGURING_ADS, 5);
        hmTime.put(InstallProgressStep.INITIALIZE_REPLICATED_SUFFIXES, 25);
        int totalTime = 0;
        ArrayList<InstallProgressStep> steps = new ArrayList<InstallProgressStep>();
        totalTime += ((Integer)hmTime.get(InstallProgressStep.CONFIGURING_SERVER)).intValue();
        steps.add(InstallProgressStep.CONFIGURING_SERVER);
        if (this.createNotReplicatedSuffix()) {
            switch (this.getUserData().getNewSuffixOptions().getType()) {
                case CREATE_BASE_ENTRY: {
                    steps.add(InstallProgressStep.CREATING_BASE_ENTRY);
                    totalTime += ((Integer)hmTime.get(InstallProgressStep.CREATING_BASE_ENTRY)).intValue();
                    break;
                }
                case IMPORT_FROM_LDIF_FILE: {
                    steps.add(InstallProgressStep.IMPORTING_LDIF);
                    totalTime += ((Integer)hmTime.get(InstallProgressStep.IMPORTING_LDIF)).intValue();
                    break;
                }
                case IMPORT_AUTOMATICALLY_GENERATED_DATA: {
                    steps.add(InstallProgressStep.IMPORTING_AUTOMATICALLY_GENERATED);
                    totalTime += ((Integer)hmTime.get(InstallProgressStep.IMPORTING_AUTOMATICALLY_GENERATED)).intValue();
                }
            }
        }
        if (Utils.isWindows()) {
            totalTime += ((Integer)hmTime.get(InstallProgressStep.ENABLING_WINDOWS_SERVICE)).intValue();
            steps.add(InstallProgressStep.ENABLING_WINDOWS_SERVICE);
        }
        if (this.mustStart()) {
            totalTime += ((Integer)hmTime.get(InstallProgressStep.STARTING_SERVER)).intValue();
            steps.add(InstallProgressStep.STARTING_SERVER);
        }
        if (this.mustCreateAds()) {
            totalTime += ((Integer)hmTime.get(InstallProgressStep.CONFIGURING_ADS)).intValue();
            steps.add(InstallProgressStep.CONFIGURING_ADS);
        }
        if (this.mustConfigureReplication()) {
            steps.add(InstallProgressStep.CONFIGURING_REPLICATION);
            totalTime += ((Integer)hmTime.get(InstallProgressStep.CONFIGURING_REPLICATION)).intValue();
        }
        if (this.mustInitializeSuffixes()) {
            totalTime += ((Integer)hmTime.get(InstallProgressStep.INITIALIZE_REPLICATED_SUFFIXES)).intValue();
            steps.add(InstallProgressStep.INITIALIZE_REPLICATED_SUFFIXES);
        }
        if (this.mustStop()) {
            totalTime += ((Integer)hmTime.get(InstallProgressStep.STOPPING_SERVER)).intValue();
            steps.add(InstallProgressStep.STOPPING_SERVER);
        }
        int cumulatedTime = 0;
        for (InstallProgressStep s : steps) {
            Integer statusTime = (Integer)hmTime.get(s);
            this.hmRatio.put(s, 100 * cumulatedTime / totalTime);
            if (statusTime == null) continue;
            cumulatedTime += statusTime.intValue();
        }
        this.hmRatio.put(InstallProgressStep.FINISHED_SUCCESSFULLY, 100);
        this.hmRatio.put(InstallProgressStep.FINISHED_WITH_ERROR, 100);
        this.hmRatio.put(InstallProgressStep.FINISHED_CANCELED, 100);
    }

    public String getInstallationPath() {
        return Utils.getInstallPathFromClasspath();
    }

    public String getInstancePath() {
        String installPath = Utils.getInstallPathFromClasspath();
        return Utils.getInstancePathFromClasspath(installPath);
    }

    protected String getOpenDSClassPath() {
        return System.getProperty("java.class.path");
    }
}

