/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.util.logging.Logger;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.upgrader.UpgradeLauncher;
import org.opends.quicksetup.upgrader.UpgraderSvr4;
import org.opends.quicksetup.util.Utils;
import org.opends.server.tools.ToolConstants;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class UpgradeSvr4Launcher
extends UpgradeLauncher {
    private static final Logger LOG = Logger.getLogger(UpgradeSvr4Launcher.class.getName());
    private ArgumentParser argParser;
    private BooleanArgument showUsage;
    private BooleanArgument quiet;
    private BooleanArgument noPrompt;
    private BooleanArgument verbose;
    private BooleanArgument revertMostRecent;
    private StringArgument reversionArchive;

    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile("opends-upgrade-", ".log"));
        }
        catch (Throwable t) {
            System.err.println(QuickSetupMessages.INFO_ERROR_INITIALIZING_LOG.get());
            t.printStackTrace();
        }
        new UpgradeSvr4Launcher(args).launch();
    }

    protected CliApplication createCliApplication() {
        return new UpgraderSvr4();
    }

    protected void willLaunchGui() {
        System.out.println(QuickSetupMessages.INFO_UPGRADE_LAUNCHER_LAUNCHING_GUI.get());
        System.setProperty("org.opends.quicksetup.Application.class", "org.opends.quicksetup.upgrader.UpgraderSvr4");
    }

    protected UpgradeSvr4Launcher(String[] args) {
        super(args);
        String scriptName = Utils.isWindows() ? "upgrade.bat" : "upgrade";
        if (System.getProperty("org.opends.server.scriptName") == null) {
            System.setProperty("org.opends.server.scriptName", scriptName);
        }
        this.argParser = new ArgumentParser(this.getClass().getName(), QuickSetupMessages.INFO_UPGRADE_LAUNCHER_USAGE_DESCRIPTION.get(), false);
        try {
            this.revertMostRecent = new BooleanArgument("revertMostRecent", REVERT_MOST_RECENT_OPTION_SHORT, "revertMostRecent", ToolMessages.INFO_REVERT_DESCRIPTION_RECENT.get());
            this.argParser.addArgument((Argument)this.revertMostRecent);
            this.reversionArchive = new StringArgument("reversionArchive", REVERT_ARCHIVE_OPTION_SHORT, "reversionArchive", false, false, true, ToolMessages.INFO_DIRECTORY_PLACEHOLDER.get(), null, null, ToolMessages.INFO_REVERT_DESCRIPTION_DIRECTORY.get());
            this.argParser.addArgument((Argument)this.reversionArchive);
            this.noPrompt = new BooleanArgument("no-prompt", ToolConstants.OPTION_SHORT_NO_PROMPT, "no-prompt", ToolMessages.INFO_UPGRADE_DESCRIPTION_NO_PROMPT.get());
            this.argParser.addArgument((Argument)this.noPrompt);
            this.quiet = new BooleanArgument("quiet", ToolConstants.OPTION_SHORT_QUIET, "quiet", ToolMessages.INFO_UPGRADE_DESCRIPTION_SILENT.get());
            this.argParser.addArgument((Argument)this.quiet);
            this.verbose = new BooleanArgument("verbose", ToolConstants.OPTION_SHORT_VERBOSE, "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get());
            this.argParser.addArgument((Argument)this.verbose);
            this.showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            this.argParser.addArgument((Argument)this.showUsage);
            this.argParser.setUsageArgument((Argument)this.showUsage);
            try {
                this.argParser.parseArguments(args);
                this.isReversion = this.reversionArchive.isPresent() || this.revertMostRecent.isPresent();
                boolean bl = this.isUpgrade = !this.isReversion;
                if (this.argParser.usageOrVersionDisplayed()) {
                    System.exit(ReturnCode.PRINT_USAGE.getReturnCode());
                }
            }
            catch (ArgumentException ae) {
                System.err.println(ae.getMessageObject());
                this.printUsage(false);
                System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
            }
        }
        catch (Throwable t) {
            System.out.println("ERROR: " + t);
            t.printStackTrace();
        }
    }
}

