/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.quicksetup.util.Utils;

public class UIKeyStore
extends KeyStore {
    private static KeyStore keyStore = null;
    private static final Logger LOG = Logger.getLogger(UIKeyStore.class.getName());

    private UIKeyStore() {
        super(null, null, null);
    }

    public static KeyStore getInstance() throws FileNotFoundException, IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        if (keyStore == null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String keyStorePath = UIKeyStore.getKeyStorePath();
            File f = new File(keyStorePath);
            if (!f.exists()) {
                LOG.log(Level.INFO, "Path " + keyStorePath + " does not exist");
                keyStorePath = null;
            } else if (f.isDirectory()) {
                LOG.log(Level.SEVERE, "Path " + keyStorePath + " is a directory");
                keyStorePath = null;
            } else if (!f.canRead()) {
                LOG.log(Level.SEVERE, "Path " + keyStorePath + " is not readable");
                keyStorePath = null;
            } else if (!f.canWrite()) {
                LOG.log(Level.SEVERE, "Path " + keyStorePath + " is not writable");
                keyStorePath = null;
            }
            if (keyStorePath != null) {
                FileInputStream fos = new FileInputStream(keyStorePath);
                try {
                    keyStore.load(fos, null);
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Error reading key store on " + keyStorePath, t);
                    keyStore.load(null, null);
                }
                fos.close();
            } else {
                keyStore.load(null, null);
            }
        }
        return keyStore;
    }

    public static void acceptCertificate(X509Certificate[] chain) throws FileNotFoundException, IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        LOG.log(Level.INFO, "Accepting certificate chain.");
        KeyStore k = UIKeyStore.getInstance();
        for (int i = 0; i < chain.length; ++i) {
            String alias = chain[i].getSubjectDN().getName();
            k.setCertificateEntry(alias, chain[i]);
        }
        String keyStorePath = UIKeyStore.getKeyStorePath();
        File f = new File(keyStorePath);
        if (!f.exists()) {
            Utils.createFile(f);
        }
        FileOutputStream fos = new FileOutputStream(UIKeyStore.getKeyStorePath());
        k.store(fos, new char[0]);
        if (fos != null) {
            fos.close();
        }
    }

    private static String getKeyStorePath() {
        return System.getProperty("user.home") + File.separator + ".opends" + File.separator + "gui-keystore";
    }
}

