/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.nimbus.painters;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import javax.swing.JProgressBar;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import org.jdesktop.swingx.plaf.nimbus.NimbusGraphicsUtils;

public class ProgressPainter
extends SynthPainter {
    private static final float[] NORMAL_BG_PTS = new float[]{0.0f, 0.06f, 0.216f, 0.44f, 0.46f, 0.694f, 0.85f, 0.95f, 1.0f};
    private static final Color[] NORMAL_BG = new Color[]{NimbusGraphicsUtils.getWebColor("FFFFFF"), NimbusGraphicsUtils.getWebColor("EFF0F2"), NimbusGraphicsUtils.getMidWebColor("EFF0F2", "DADBDE"), NimbusGraphicsUtils.getWebColor("DADBDE"), NimbusGraphicsUtils.getWebColor("CED0D4"), NimbusGraphicsUtils.getMidWebColor("CED0D4", "E3E5E9"), NimbusGraphicsUtils.getWebColor("E3E5E9"), NimbusGraphicsUtils.getWebColor("F9FBFF"), NimbusGraphicsUtils.getWebColor("F9FBFF")};
    private static final float[] NORMAL_FG_PTS = new float[]{0.0f, 0.05f, 0.95f, 1.0f};
    private static final Color[] NORMAL_FG = new Color[]{NimbusGraphicsUtils.getWebColor("888B91"), NimbusGraphicsUtils.getWebColor("888B91"), NimbusGraphicsUtils.getWebColor("AEB1B7"), NimbusGraphicsUtils.getWebColor("AEB1B7")};
    private static final float[] BAR_BG_PTS = new float[]{0.0f, 0.06f, 0.216f, 0.44f, 0.46f, 0.694f, 0.85f, 0.95f, 1.0f};
    private static final Color[] BAR_BG = new Color[]{NimbusGraphicsUtils.getWebColor("ECD1B3"), NimbusGraphicsUtils.getWebColor("DBA76B"), NimbusGraphicsUtils.getMidWebColor("DBA76B", "CB7F2A"), NimbusGraphicsUtils.getWebColor("CB7F2A"), NimbusGraphicsUtils.getWebColor("C06600"), NimbusGraphicsUtils.getMidWebColor("C06600", "E88E2B"), NimbusGraphicsUtils.getWebColor("E88E2B"), NimbusGraphicsUtils.getWebColor("FFB146"), NimbusGraphicsUtils.getWebColor("FFB146")};
    private static final float[] BAR_FG_PTS = new float[]{0.0f, 0.1f, 0.6f, 0.78f, 0.9f, 0.95f, 1.0f};
    private static final Color[] BAR_FG = new Color[]{NimbusGraphicsUtils.getWebColor("983E00"), NimbusGraphicsUtils.getWebColor("A34900"), NimbusGraphicsUtils.getWebColor("A34900"), NimbusGraphicsUtils.getMidWebColor("A34900", "E88E28"), NimbusGraphicsUtils.getWebColor("E88E28"), NimbusGraphicsUtils.getWebColor("721800"), NimbusGraphicsUtils.getWebColor("721800")};

    @Override
    public void paintProgressBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(new LinearGradientPaint(x, y + 3, x, y + h - 4, NORMAL_BG_PTS, NORMAL_BG));
        g2.fillRect(x + 2, y + 2, w - 5, h - 5);
        g2.setPaint(new LinearGradientPaint(x, y + 2, x, y + h - 5, NORMAL_FG_PTS, NORMAL_FG));
        g2.drawRect(x + 2, y + 2, w - 5, h - 5);
    }

    @Override
    public void paintProgressBarForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        boolean isComplete;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(new LinearGradientPaint(x, y + 3, x, y + h - 4, BAR_BG_PTS, BAR_BG));
        g2.fillRect(x + 2, y + 2, w - 5, h - 5);
        g2.setPaint(new LinearGradientPaint(x, y + 2, x, y + h - 2, BAR_FG_PTS, BAR_FG));
        g2.drawRect(x + 2, y + 2, w - 5, h - 5);
        JProgressBar progressBar = (JProgressBar)context.getComponent();
        boolean bl = isComplete = progressBar.getValue() == progressBar.getMaximum();
        if (isComplete) {
            g2.setPaint(new Color(232, 142, 40, 130));
            g2.drawLine(x + 2, y + 1, x + w - 2, y + 1);
            g2.drawLine(x + 2, y + h - 2, x + w - 2, y + h - 2);
            g2.drawLine(x + 1, y + 1, x + 1, y + h - 2);
            g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
            g2.setPaint(new Color(232, 142, 40, 80));
            g2.drawLine(x, y, x + w - 1, y);
            g2.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            g2.drawLine(x, y + 1, x, y + h - 2);
            g2.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
        } else {
            g2.setPaint(new Color(232, 142, 40, 130));
            g2.drawLine(x + 2, y + 1, x + w - 3, y + 1);
            g2.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
            g2.drawLine(x + 1, y + 1, x + 1, y + h - 2);
            g2.setPaint(new Color(232, 142, 40, 80));
            g2.drawLine(x, y, x + w - 3, y);
            g2.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
            g2.drawLine(x, y + 1, x, y + h - 2);
        }
    }

    @Override
    public void paintProgressBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
    }
}

