/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.util.ConnectionUtils;

public class PreferredConnection {
    private String ldapUrl;
    private Type type;

    public PreferredConnection(String ldapUrl, Type type) {
        this.ldapUrl = ldapUrl;
        this.type = type;
    }

    public String getLDAPURL() {
        return this.ldapUrl;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return ((Object)((Object)this.type) + this.ldapUrl.toLowerCase()).hashCode();
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (this != o) {
            if (o != null && o instanceof PreferredConnection) {
                PreferredConnection p = (PreferredConnection)o;
                equals = this.type == p.getType() && this.ldapUrl.equalsIgnoreCase(p.getLDAPURL());
            }
        } else {
            equals = true;
        }
        return equals;
    }

    public static PreferredConnection getPreferredConnection(InitialLdapContext ctx) {
        String ldapUrl = ConnectionUtils.getLdapUrl(ctx);
        Type type = ConnectionUtils.isStartTLS(ctx) ? Type.START_TLS : (ConnectionUtils.isSSL(ctx) ? Type.LDAPS : Type.LDAP);
        PreferredConnection cnx = new PreferredConnection(ldapUrl, type);
        return cnx;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        LDAP,
        LDAPS,
        START_TLS;

    }
}

