/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.server.types.DN;

public class BaseDNDescriptor
implements Comparable {
    private int nEntries;
    private int missingChanges;
    private BackendDescriptor backend;
    private long ageOfOldestMissingChange;
    private Type type;
    private DN baseDn;
    private int replicaID = -1;
    private int hashCode;

    public BaseDNDescriptor(Type type, DN baseDn, BackendDescriptor backend, int nEntries, long ageOfOldestMissingChange, int missingChanges) {
        this.baseDn = baseDn;
        this.backend = backend;
        this.type = type;
        this.nEntries = nEntries;
        this.ageOfOldestMissingChange = ageOfOldestMissingChange;
        this.missingChanges = missingChanges;
        if (backend != null) {
            this.recalculateHashCode();
        }
    }

    public DN getDn() {
        return this.baseDn;
    }

    public boolean equals(Object v) {
        boolean equals = false;
        if (this != v) {
            if (v instanceof BaseDNDescriptor) {
                BaseDNDescriptor desc = (BaseDNDescriptor)v;
                equals = this.getType() == desc.getType() && this.getDn().equals(desc.getDn()) && this.getAgeOfOldestMissingChange() == desc.getAgeOfOldestMissingChange() && this.getMissingChanges() == desc.getMissingChanges() && this.getBackend().getBackendID().equals(desc.getBackend().getBackendID()) && this.getEntries() == desc.getEntries();
            }
        } else {
            equals = true;
        }
        return equals;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int compareTo(Object o) {
        int returnValue = -1;
        if (o instanceof BaseDNDescriptor) {
            BaseDNDescriptor desc = (BaseDNDescriptor)o;
            returnValue = desc.getDn().compareTo(this.getDn());
        }
        return returnValue;
    }

    public int getEntries() {
        return this.nEntries;
    }

    public int getMissingChanges() {
        return this.missingChanges;
    }

    public void setMissingChanges(int missingChanges) {
        this.missingChanges = missingChanges;
        this.recalculateHashCode();
    }

    public long getAgeOfOldestMissingChange() {
        return this.ageOfOldestMissingChange;
    }

    public void setAgeOfOldestMissingChange(long ageOfOldestMissingChange) {
        this.ageOfOldestMissingChange = ageOfOldestMissingChange;
        this.recalculateHashCode();
    }

    public Type getType() {
        return this.type;
    }

    public BackendDescriptor getBackend() {
        return this.backend;
    }

    public void setBackend(BackendDescriptor backend) {
        this.backend = backend;
        this.recalculateHashCode();
    }

    public void setType(Type type) {
        this.type = type;
        this.recalculateHashCode();
    }

    public void setEntries(int nEntries) {
        this.nEntries = nEntries;
        this.recalculateHashCode();
    }

    public int getReplicaID() {
        return this.replicaID;
    }

    public void setReplicaID(int replicaID) {
        this.replicaID = replicaID;
        this.recalculateHashCode();
    }

    private void recalculateHashCode() {
        this.hashCode = (this.getType().toString() + this.getAgeOfOldestMissingChange() + this.getDn() + this.getBackend().getBackendID() + this.getMissingChanges()).hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NOT_REPLICATED,
        REPLICATED;

    }
}

