/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opends.guitools.controlpanel.datamodel.AddressConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.MonitoringTableModel;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHandlersMonitoringTableModel
extends MonitoringTableModel<ConnectionHandlerDescriptor, AddressConnectionHandlerDescriptor> {
    private static final long serialVersionUID = -8891998773191495L;

    @Override
    protected Set<AddressConnectionHandlerDescriptor> convertToInternalData(Set<ConnectionHandlerDescriptor> newData) {
        HashSet<AddressConnectionHandlerDescriptor> newAddresses = new HashSet<AddressConnectionHandlerDescriptor>();
        for (ConnectionHandlerDescriptor ch : newData) {
            if (ch.getAddresses().isEmpty()) {
                newAddresses.add(new AddressConnectionHandlerDescriptor(ch, null, this.getMonitoringEntry(null, ch)));
                continue;
            }
            for (InetAddress address : ch.getAddresses()) {
                newAddresses.add(new AddressConnectionHandlerDescriptor(ch, address, this.getMonitoringEntry(address, ch)));
            }
        }
        return newAddresses;
    }

    @Override
    public int compare(AddressConnectionHandlerDescriptor desc1, AddressConnectionHandlerDescriptor desc2) {
        ArrayList<Integer> possibleResults = new ArrayList<Integer>();
        possibleResults.add(this.compareNames(desc1, desc2));
        possibleResults.addAll(this.getMonitoringPossibleResults(desc1.getMonitoringEntry(), desc2.getMonitoringEntry()));
        int result = (Integer)possibleResults.get(this.getSortColumn());
        if (result == 0) {
            Iterator i$ = possibleResults.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (i == 0) continue;
                result = i;
                break;
            }
        }
        if (!this.isSortAscending()) {
            result = -result;
        }
        return result;
    }

    private int compareNames(AddressConnectionHandlerDescriptor ach1, AddressConnectionHandlerDescriptor ach2) {
        int compare = 0;
        boolean addressEqual = false;
        if (ach1.getAddress() == null) {
            if (ach2.getAddress() == null) {
                addressEqual = true;
            }
        } else if (ach2.getAddress() != null) {
            addressEqual = ach1.getAddress().equals(ach2.getAddress());
        }
        if (addressEqual) {
            Integer port1 = new Integer(ach1.getConnectionHandler().getPort());
            Integer port2 = new Integer(ach2.getConnectionHandler().getPort());
            compare = port1.compareTo(port2);
        } else {
            compare = this.getName(ach1).compareTo(this.getName(ach2));
        }
        return compare;
    }

    @Override
    protected CustomSearchResult getMonitoringEntry(AddressConnectionHandlerDescriptor ach) {
        return ach.getMonitoringEntry();
    }

    @Override
    protected String getName(AddressConnectionHandlerDescriptor ach) {
        StringBuilder sb = new StringBuilder();
        ConnectionHandlerDescriptor ch = ach.getConnectionHandler();
        if (ch.getProtocol() == ConnectionHandlerDescriptor.Protocol.ADMINISTRATION_CONNECTOR) {
            sb.append(AdminToolMessages.INFO_CTRL_PANEL_ADMINISTRATION_CONNECTOR_NAME.get(ch.getPort()));
        } else {
            if (ach.getAddress() != null) {
                sb.append(ach.getAddress().getHostName() + ":" + ch.getPort());
            } else {
                sb.append(ch.getPort());
            }
            sb.append(" - ");
            switch (ch.getProtocol()) {
                case OTHER: {
                    sb.append(ch.getName());
                    break;
                }
                default: {
                    sb.append(ch.getProtocol().getDisplayMessage().toString());
                }
            }
        }
        return sb.toString();
    }

    private CustomSearchResult getMonitoringEntry(InetAddress address, ConnectionHandlerDescriptor cch) {
        CustomSearchResult monitoringEntry = null;
        for (CustomSearchResult sr : cch.getMonitoringEntries()) {
            String cn = (String)this.getFirstMonitoringValue(sr, "cn");
            if (cn == null) continue;
            if (address == null) {
                monitoringEntry = sr;
                break;
            }
            if (!cn.endsWith(" " + address.getHostAddress() + " port " + cch.getPort() + " Statistics") && !cn.endsWith(" " + address.getHostName() + " port " + cch.getPort() + " Statistics")) continue;
            monitoringEntry = sr;
            break;
        }
        return monitoringEntry;
    }

    @Override
    protected Message getNameHeader() {
        return AdminToolMessages.INFO_CTRL_PANEL_CONNECTION_HANDLER_HEADER.get();
    }
}

