/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.event;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.text.JTextComponent;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.util.ExtensionFileFilter;

public class BrowseActionListener
implements ActionListener {
    private JFileChooser fc;
    private JTextComponent field;
    private Component parent;
    private BrowseType type;

    public BrowseActionListener(JTextComponent field, BrowseType type, Component parent) {
        this.field = field;
        this.type = type;
        this.parent = parent;
        this.fc = new JFileChooser();
        switch (type) {
            case LOCATION_DIRECTORY: {
                this.fc.setFileSelectionMode(1);
                this.fc.setDialogType(0);
                this.fc.setDialogTitle("Choose Directory");
                break;
            }
            case CREATE_DIRECTORY: {
                this.fc.setFileSelectionMode(1);
                this.fc.setDialogType(1);
                this.fc.setDialogTitle("Choose Directory");
                break;
            }
            case OPEN_LDIF_FILE: {
                this.fc.setFileSelectionMode(0);
                this.fc.setDialogType(0);
                this.fc.setDialogTitle(QuickSetupMessages.INFO_OPEN_LDIF_FILE_DIALOG_TITLE.get().toString());
                ExtensionFileFilter ldifFiles = new ExtensionFileFilter("ldif", QuickSetupMessages.INFO_LDIF_FILES_DESCRIPTION.get().toString());
                this.fc.addChoosableFileFilter(ldifFiles);
                this.fc.setFileFilter(ldifFiles);
                break;
            }
            case CREATE_LDIF_FILE: {
                this.fc.setFileSelectionMode(0);
                this.fc.setDialogType(1);
                this.fc.setDialogTitle(QuickSetupMessages.INFO_OPEN_LDIF_FILE_DIALOG_TITLE.get().toString());
                ExtensionFileFilter ldifFiles = new ExtensionFileFilter("ldif", QuickSetupMessages.INFO_LDIF_FILES_DESCRIPTION.get().toString());
                this.fc.addChoosableFileFilter(ldifFiles);
                this.fc.setFileFilter(ldifFiles);
                break;
            }
            case OPEN_ZIP_FILE: {
                this.fc.setFileSelectionMode(0);
                this.fc.setDialogType(0);
                this.fc.setDialogTitle(QuickSetupMessages.INFO_OPEN_ZIP_FILE_DIALOG_TITLE.get().toString());
                ExtensionFileFilter zipFiles = new ExtensionFileFilter("zip", QuickSetupMessages.INFO_ZIP_FILES_DESCRIPTION.get().toString());
                this.fc.addChoosableFileFilter(zipFiles);
                this.fc.setFileFilter(zipFiles);
                break;
            }
            case OPEN_GENERIC_FILE: {
                this.fc.setFileSelectionMode(0);
                this.fc.setDialogType(0);
                this.fc.setDialogTitle(QuickSetupMessages.INFO_OPEN_GENERIC_FILE_DIALOG_TITLE.get().toString());
                break;
            }
            case CREATE_GENERIC_FILE: {
                this.fc.setFileSelectionMode(0);
                this.fc.setDialogType(1);
                this.fc.setDialogTitle(QuickSetupMessages.INFO_OPEN_GENERIC_FILE_DIALOG_TITLE.get().toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown BrowseType: " + (Object)((Object)type));
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal;
        String path = this.field.getText();
        if (path != null && path.trim().length() > 0) {
            File f;
            for (f = new File(path); f != null && !f.isDirectory(); f = f.getParentFile()) {
            }
            if (f != null) {
                this.fc.setCurrentDirectory(f);
            }
        }
        switch (this.type) {
            case LOCATION_DIRECTORY: {
                returnVal = this.fc.showOpenDialog(this.parent);
                break;
            }
            case OPEN_LDIF_FILE: {
                returnVal = this.fc.showOpenDialog(this.parent);
                break;
            }
            case OPEN_ZIP_FILE: {
                returnVal = this.fc.showOpenDialog(this.parent);
                break;
            }
            case OPEN_GENERIC_FILE: {
                returnVal = this.fc.showOpenDialog(this.parent);
                break;
            }
            case CREATE_GENERIC_FILE: {
                returnVal = this.fc.showSaveDialog(this.parent);
                break;
            }
            case CREATE_LDIF_FILE: {
                returnVal = this.fc.showSaveDialog(this.parent);
                break;
            }
            case CREATE_DIRECTORY: {
                returnVal = this.fc.showSaveDialog(this.parent);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + (Object)((Object)this.type));
            }
        }
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            this.field.setText(file.getAbsolutePath());
            this.field.requestFocusInWindow();
            this.field.selectAll();
            this.fieldUpdated();
        }
    }

    protected void fieldUpdated() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BrowseType {
        LOCATION_DIRECTORY,
        OPEN_LDIF_FILE,
        OPEN_ZIP_FILE,
        OPEN_GENERIC_FILE,
        CREATE_GENERIC_FILE,
        CREATE_LDIF_FILE,
        CREATE_DIRECTORY;

    }
}

