/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.OnlineUpdateException;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Attributes;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.SchemaFileElement;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.cli.CommandBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteSchemaElementsTask
extends Task {
    ArrayList<ObjectClass> ocsToDelete = new ArrayList();
    ArrayList<AttributeType> attrsToDelete = new ArrayList();
    private Set<String> backendSet;

    public DeleteSchemaElementsTask(ControlPanelInfo info, ProgressDialog dlg, List<ObjectClass> ocsToDelete, List<AttributeType> attrsToDelete) {
        super(info, dlg);
        this.ocsToDelete.addAll(ocsToDelete);
        this.attrsToDelete.addAll(attrsToDelete);
        this.backendSet = new HashSet<String>();
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        return true;
    }

    @Override
    public Task.Type getType() {
        if (this.attrsToDelete.isEmpty()) {
            return Task.Type.DELETE_OBJECTCLASS;
        }
        if (this.ocsToDelete.isEmpty()) {
            return Task.Type.DELETE_ATTRIBUTE;
        }
        return Task.Type.DELETE_OBJECTCLASS;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            this.updateSchema();
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_DELETE_SCHEMA_ELEMENT_TASK_DESCRIPTION.get();
    }

    private void updateSchema() throws OpenDsException {
        int fNumberDeleted;
        ModificationItem mod;
        final boolean[] isFirst = new boolean[]{true};
        final int totalNumber = this.ocsToDelete.size() + this.attrsToDelete.size();
        int numberDeleted = 0;
        for (final ObjectClass objectClass : this.ocsToDelete) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!isFirst[0]) {
                        DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml("<br><br>");
                    }
                    isFirst[0] = false;
                    DeleteSchemaElementsTask.this.printEquivalentCommandToDelete(objectClass);
                    DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_DELETING_OBJECTCLASS.get(objectClass.getNameOrOID()), ColorAndFontConstants.progressFont));
                }
            });
            if (this.isServerRunning()) {
                try {
                    BasicAttribute attr = new BasicAttribute(this.getSchemaFileAttributeName(objectClass));
                    attr.add(this.getSchemaFileAttributeValue(objectClass));
                    mod = new ModificationItem(3, attr);
                    this.getInfo().getDirContext().modifyAttributes("cn=schema", new ModificationItem[]{mod});
                }
                catch (NamingException ne) {
                    throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_SCHEMA.get(ne.toString()), (Throwable)ne);
                }
            } else {
                this.updateSchemaFile(objectClass);
            }
            fNumberDeleted = ++numberDeleted;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DeleteSchemaElementsTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                    DeleteSchemaElementsTask.this.getProgressDialog().getProgressBar().setValue(fNumberDeleted * 100 / totalNumber);
                    DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                }
            });
        }
        for (final AttributeType attribute : this.attrsToDelete) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!isFirst[0]) {
                        DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml("<br><br>");
                    }
                    isFirst[0] = false;
                    DeleteSchemaElementsTask.this.printEquivalentCommandToDelete(attribute);
                    DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_DELETING_ATTRIBUTE.get(attribute.getNameOrOID()), ColorAndFontConstants.progressFont));
                }
            });
            if (this.isServerRunning()) {
                try {
                    BasicAttribute attr = new BasicAttribute(this.getSchemaFileAttributeName(attribute));
                    attr.add(this.getSchemaFileAttributeValue(attribute));
                    mod = new ModificationItem(3, attr);
                    this.getInfo().getDirContext().modifyAttributes("cn=schema", new ModificationItem[]{mod});
                }
                catch (NamingException ne) {
                    throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_SCHEMA.get(ne.toString()), (Throwable)ne);
                }
            } else {
                this.updateSchemaFile(attribute);
            }
            fNumberDeleted = ++numberDeleted;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DeleteSchemaElementsTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                    DeleteSchemaElementsTask.this.getProgressDialog().getProgressBar().setValue(fNumberDeleted * 100 / totalNumber);
                    DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchemaFile(CommonSchemaElements schemaElement) throws OpenDsException {
        String schemaFile = this.getSchemaFile((SchemaFileElement)((Object)schemaElement));
        LDIFExportConfig exportConfig = new LDIFExportConfig(schemaFile, ExistingFileBehavior.OVERWRITE);
        LDIFReader reader = null;
        Entry schemaEntry = null;
        try {
            reader = new LDIFReader(new LDIFImportConfig(schemaFile));
            schemaEntry = reader.readEntry();
            Modification mod = new Modification(ModificationType.DELETE, Attributes.create(this.getSchemaFileAttributeName(schemaElement).toLowerCase(), this.getSchemaFileAttributeValue(schemaElement)));
            schemaEntry.applyModification(mod);
            LDIFWriter writer = new LDIFWriter(exportConfig);
            writer.writeEntry(schemaEntry);
            exportConfig.getWriter().newLine();
        }
        catch (Throwable t) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable t) {}
            }
            if (exportConfig != null) {
                try {
                    exportConfig.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private String getSchemaFile(SchemaFileElement element) {
        File f;
        String schemaFile = element.getSchemaFile();
        if (schemaFile == null) {
            schemaFile = "99-user.ldif";
        }
        if (!((f = new File(schemaFile)).isAbsolute() || (f = new File(DirectoryServer.getEnvironmentConfig().getSchemaDirectory(false), schemaFile)) != null && f.exists() && !f.isDirectory())) {
            f = new File(DirectoryServer.getEnvironmentConfig().getSchemaDirectory(true), schemaFile);
        }
        schemaFile = f.getAbsolutePath();
        return schemaFile;
    }

    private String getSchemaFileAttributeName(CommonSchemaElements element) {
        if (element instanceof AttributeType) {
            return "attributeTypes";
        }
        return "objectClasses";
    }

    private String getSchemaFileAttributeValue(CommonSchemaElements element) {
        if (element instanceof AttributeType) {
            return ((AttributeType)element).getDefinition();
        }
        return ((ObjectClass)element).getDefinition();
    }

    private void printEquivalentCommandToDelete(CommonSchemaElements element) {
        String schemaFile = this.getSchemaFile((SchemaFileElement)((Object)element));
        String attrName = this.getSchemaFileAttributeName(element);
        String attrValue = this.getSchemaFileAttributeValue(element);
        if (!this.isServerRunning()) {
            this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DELETE_SCHEMA_ELEMENT_OFFLINE.get(schemaFile) + "<br><b>" + attrName + ": " + attrValue + "</b><br><br>", ColorAndFontConstants.progressFont));
        } else {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.getCommandLinePath("ldapmodify"));
            args.add("-a");
            args.addAll(this.getObfuscatedCommandLineArguments(this.getConnectionCommandLineArguments(true, true)));
            args.add(this.getNoPropertiesFileArgument());
            StringBuilder sb = new StringBuilder();
            for (String arg : args) {
                sb.append(" " + CommandBuilder.escapeValue(arg));
            }
            sb.append("<br>");
            sb.append("dn: cn=schema<br>");
            sb.append("changetype: modify<br>");
            sb.append("delete: " + attrName + "<br>");
            sb.append(attrName + ": " + attrValue);
            this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DELETE_SCHEMA_ELEMENT_ONLINE.get() + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
        }
    }
}

