/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.tools.LDAPPasswordModify;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetUserPasswordTask
extends Task {
    private Set<String> backendSet = new HashSet<String>();
    private BasicNode node;
    private char[] currentPassword;
    private char[] newPassword;
    private DN dn;
    private boolean useAdminCtx;

    public ResetUserPasswordTask(ControlPanelInfo info, ProgressDialog dlg, BasicNode node, BrowserController controller, char[] pwd) {
        super(info, dlg);
        this.node = node;
        this.newPassword = pwd;
        try {
            this.dn = DN.decode(node.getDN());
            for (BackendDescriptor backend : info.getServerDescriptor().getBackends()) {
                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                    if (!this.dn.isDescendantOf(baseDN.getDn())) continue;
                    this.backendSet.add(backend.getBackendID());
                }
            }
        }
        catch (OpenDsException ode) {
            throw new IllegalStateException("Could not parse DN: " + node.getDN(), ode);
        }
        try {
            InitialLdapContext ctx = controller.findConnectionForDisplayedEntry(node);
            if (ctx != null && this.isBoundAs(this.dn, ctx)) {
                this.currentPassword = ConnectionUtils.getBindPassword(ctx).toCharArray();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.useAdminCtx = controller.isConfigurationNode(node);
    }

    @Override
    public Task.Type getType() {
        return Task.Type.MODIFY_ENTRY;
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_RESET_USER_PASSWORD_TASK_DESCRIPTION.get(this.node.getDN());
    }

    @Override
    public boolean regenerateDescriptor() {
        return false;
    }

    @Override
    protected String getCommandLinePath() {
        return this.getCommandLinePath("ldappasswordmodify");
    }

    protected ArrayList<String> getCommandLineArguments() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.currentPassword == null) {
            args.add("--authzID");
            args.add("dn:" + this.dn);
        } else {
            args.add("--currentPassword");
            args.add(String.valueOf(this.currentPassword));
        }
        args.add("--newPassword");
        args.add(String.valueOf(this.newPassword));
        args.addAll(this.getConnectionCommandLineArguments(this.useAdminCtx, true));
        args.add(this.getNoPropertiesFileArgument());
        return args;
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (!this.isServerRunning() && this.state == Task.State.RUNNING) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            List arguments = this.getCommandLineArguments();
            String[] args = new String[((ArrayList)arguments).size()];
            ((ArrayList)arguments).toArray(args);
            this.returnCode = LDAPPasswordModify.mainPasswordModify(args, false, this.outPrintStream, this.errorPrintStream);
            if (this.returnCode != 0) {
                this.state = Task.State.FINISHED_WITH_ERROR;
            } else {
                if (this.lastException == null && this.currentPassword != null) {
                    this.getInfo().getDirContext().addToEnvironment("java.naming.security.credentials", String.valueOf(this.newPassword));
                    if (this.getInfo().getUserDataDirContext() != null) {
                        this.getInfo().getUserDataDirContext().addToEnvironment("java.naming.security.credentials", String.valueOf(this.newPassword));
                    }
                }
                this.state = Task.State.FINISHED_SUCCESSFULLY;
            }
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    private boolean isBoundAs(DN dn, InitialLdapContext ctx) {
        boolean isBoundAs = false;
        DN bindDN = DN.nullDN();
        try {
            String b = ConnectionUtils.getBindDN(ctx);
            bindDN = DN.decode(b);
            isBoundAs = dn.equals(bindDN);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!isBoundAs) {
            try {
                SearchControls ctls = new SearchControls();
                ctls.setSearchScope(0);
                String filter = "(|(objectClass=*)(objectclass=ldapsubentry))";
                String attrName = "ds-cfg-alternate-bind-dn";
                ctls.setReturningAttributes(new String[]{attrName});
                NamingEnumeration<SearchResult> entries = ctx.search(Utilities.getJNDIName(dn.toString()), filter, ctls);
                block4: while (entries.hasMore()) {
                    SearchResult sr = entries.next();
                    Set<String> dns = ConnectionUtils.getValues(sr, attrName);
                    for (String sDn : dns) {
                        if (!bindDN.equals(DN.decode(sDn))) continue;
                        isBoundAs = true;
                        continue block4;
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return isBoundAs;
    }
}

