/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.cli.CommandBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaTask
extends Task {
    private Set<String> backendSet = new HashSet<String>();
    protected String schemaFile;
    protected boolean isSchemaFileDefined;

    protected SchemaTask(ControlPanelInfo info, ProgressDialog dlg) {
        super(info, dlg);
        File f;
        CommonSchemaElements element = this.getSchemaElement();
        this.schemaFile = element.getSchemaFile();
        boolean userSchema = false;
        if (this.schemaFile == null) {
            this.schemaFile = "99-user.ldif";
            userSchema = true;
        }
        if (!(f = new File(this.schemaFile)).isAbsolute()) {
            f = new File(DirectoryServer.getEnvironmentConfig().getSchemaDirectory(userSchema), this.schemaFile);
        }
        this.schemaFile = f.getAbsolutePath();
        this.isSchemaFileDefined = this.isSchemaFileDefined();
    }

    protected abstract CommonSchemaElements getSchemaElement();

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        return canLaunch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSchemaFileDefined() {
        boolean schemaDefined = false;
        LDIFReader reader = null;
        try {
            reader = new LDIFReader(new LDIFImportConfig(this.schemaFile));
            if (reader.readEntry() != null) {
                schemaDefined = true;
            }
        }
        catch (Throwable t) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable t) {}
            }
        }
        return schemaDefined;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            this.updateSchema();
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    protected abstract void updateSchema() throws OpenDsException;

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    protected ArrayList<String> getSchemaEntryLines() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("dn: cn=schema");
        lines.add("objectClass: top");
        lines.add("objectClass: ldapSubentry");
        lines.add("objectClass: subschema");
        lines.add(this.getSchemaFileAttributeName() + ": " + this.getSchemaFileAttributeValue());
        return lines;
    }

    protected abstract String getSchemaFileAttributeName();

    protected abstract String getSchemaFileAttributeValue();

    protected void printEquivalentCommandToAdd() {
        if (!this.isServerRunning()) {
            if (this.isSchemaFileDefined) {
                this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_ADD_SCHEMA_ELEMENT_OFFLINE.get(this.schemaFile) + "<br><b>" + this.getSchemaFileAttributeName() + ": " + this.getSchemaFileAttributeValue() + "</b><br><br>", ColorAndFontConstants.progressFont));
            } else {
                StringBuilder sb = new StringBuilder();
                for (String line : this.getSchemaEntryLines()) {
                    if (sb.length() > 0) {
                        sb.append("<br>");
                    }
                    sb.append(line);
                }
                this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_ADD_SCHEMA_ENTRY_OFFLINE.get(this.schemaFile) + "<br><b>" + sb + "</b><br><br>", ColorAndFontConstants.progressFont));
            }
        } else {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.getCommandLinePath("ldapmodify"));
            args.add("-a");
            args.addAll(this.getObfuscatedCommandLineArguments(this.getConnectionCommandLineArguments(true, true)));
            args.add(this.getNoPropertiesFileArgument());
            StringBuilder sb = new StringBuilder();
            for (String arg : args) {
                sb.append(" " + CommandBuilder.escapeValue(arg));
            }
            sb.append("<br>");
            sb.append("dn: cn=schema<br>");
            sb.append("changetype: modify<br>");
            sb.append("add: " + this.getSchemaFileAttributeName() + "<br>");
            sb.append(this.getSchemaFileAttributeName() + ": " + this.getSchemaFileAttributeValue());
            this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_ADD_SCHEMA_ELEMENT_ONLINE.get() + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
        }
    }
}

