/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.PrintStreamListener;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.ApplicationPrintStream;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.guitools.controlpanel.util.ProcessReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.Schema;
import org.opends.server.util.Base64;
import org.opends.server.util.cli.CommandBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task {
    private static String localHostName = null;
    protected State state = State.NOT_STARTED;
    protected Integer returnCode;
    protected Throwable lastException;
    protected StringBuffer logs = new StringBuffer();
    protected StringBuilder errorLogs = new StringBuilder();
    protected StringBuilder outputLogs = new StringBuilder();
    protected ApplicationPrintStream errorPrintStream = new ApplicationPrintStream();
    protected ApplicationPrintStream outPrintStream = new ApplicationPrintStream();
    protected Process process;
    private ControlPanelInfo info;
    private ProgressDialog progressDialog;
    private static int MAX_BINARY_LENGTH_TO_DISPLAY;

    public abstract Set<String> getBackends();

    protected Task(ControlPanelInfo info, ProgressDialog progressDialog) {
        this.info = info;
        this.progressDialog = progressDialog;
        this.outPrintStream.addListener(new PrintStreamListener(){

            public void newLine(String msg) {
                Task.this.outputLogs.append(msg + "\n");
                Task.this.logs.append(msg + "\n");
            }
        });
        this.errorPrintStream.addListener(new PrintStreamListener(){

            public void newLine(String msg) {
                Task.this.errorLogs.append(msg + "\n");
                Task.this.logs.append(msg + "\n");
            }
        });
    }

    public ControlPanelInfo getInfo() {
        return this.info;
    }

    public String getLogs() {
        return this.logs.toString();
    }

    public String getErrorLogs() {
        return this.errorLogs.toString();
    }

    public String getOutputLogs() {
        return this.outputLogs.toString();
    }

    public State getState() {
        return this.state;
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public Integer getReturnCode() {
        return this.returnCode;
    }

    public Process getProcess() {
        return this.process;
    }

    protected ProgressDialog getProgressDialog() {
        return this.progressDialog;
    }

    public boolean regenerateDescriptor() {
        return true;
    }

    public void postOperation() {
    }

    public abstract Message getTaskDescription();

    protected String obfuscateAttributeStringValue(String attrName, Object o) {
        if (Utilities.mustObfuscate(attrName, this.getInfo().getServerDescriptor().getSchema())) {
            return "********";
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            if (this.displayBase64(attrName)) {
                if (bytes.length > MAX_BINARY_LENGTH_TO_DISPLAY) {
                    return AdminToolMessages.INFO_CTRL_PANEL_VALUE_IN_BASE64.get().toString();
                }
                return Base64.encode(bytes);
            }
            if (bytes.length > MAX_BINARY_LENGTH_TO_DISPLAY) {
                return AdminToolMessages.INFO_CTRL_PANEL_BINARY_VALUE.get().toString();
            }
            ByteString v = ByteString.wrap(bytes);
            return v.toString();
        }
        return String.valueOf(o);
    }

    protected String obfuscateLDIFLine(String line) {
        String attrName;
        int index = line.indexOf(":");
        String returnValue = index != -1 ? (Utilities.mustObfuscate(attrName = line.substring(0, index).trim(), this.getInfo().getServerDescriptor().getSchema()) ? attrName + ": " + "********" : line) : line;
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeCommandLine(String commandLineName, String[] args) {
        this.returnCode = -1;
        String[] cmd = new String[args.length + 1];
        cmd[0] = commandLineName;
        for (int i = 0; i < args.length; ++i) {
            cmd[i + 1] = args[i];
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Map<String, String> env = pb.environment();
        env.remove("OPENDS_JAVA_ARGS");
        env.remove("CLASSPATH");
        ProcessReader outReader = null;
        ProcessReader errReader = null;
        try {
            this.process = pb.start();
            outReader = new ProcessReader(this.process, this.outPrintStream, false);
            errReader = new ProcessReader(this.process, this.errorPrintStream, true);
            outReader.startReading();
            errReader.startReading();
            this.returnCode = this.process.waitFor();
        }
        catch (Throwable t) {
            this.lastException = t;
        }
        finally {
            if (outReader != null) {
                outReader.interrupt();
            }
            if (errReader != null) {
                errReader.interrupt();
            }
        }
        return this.returnCode;
    }

    public abstract boolean canLaunch(Task var1, Collection<Message> var2);

    public abstract void runTask();

    public abstract Type getType();

    protected String getBinaryDir() {
        if (Utilities.isWindows()) {
            return this.getInfo().getServerDescriptor().getInstallPath() + File.separator + "bat" + File.separator;
        }
        return this.getInfo().getServerDescriptor().getInstallPath() + File.separator + "bin" + File.separator;
    }

    protected abstract String getCommandLinePath();

    protected String getCommandLinePath(String scriptBasicName) {
        String cmdLineName = Utilities.isWindows() ? this.getBinaryDir() + scriptBasicName + ".bat" : this.getBinaryDir() + scriptBasicName;
        return cmdLineName;
    }

    protected abstract List<String> getCommandLineArguments();

    protected List<String> getObfuscatedCommandLineArguments(List<String> clearArgs) {
        String[] toObfuscate = new String[]{"--bindPassword", "--currentPassword", "--newPassword"};
        ArrayList<String> args = new ArrayList<String>(clearArgs);
        block0: for (int i = 1; i < args.size(); ++i) {
            for (String argName : toObfuscate) {
                if (!args.get(i - 1).equalsIgnoreCase(argName)) continue;
                args.set(i, "********");
                continue block0;
            }
        }
        return args;
    }

    protected ArrayList<String> getConfigCommandLineArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--configClass");
        args.add(ConfigFileHandler.class.getName());
        args.add("--configFile");
        args.add(ConfigReader.configFile);
        return args;
    }

    protected List<String> getConnectionCommandLineArguments() {
        return this.getConnectionCommandLineArguments(true, false);
    }

    protected List<String> getConnectionCommandLineArguments(boolean useAdminConnector, boolean addConnectionTypeParameters) {
        ArrayList<String> args = new ArrayList<String>();
        InitialLdapContext ctx = useAdminConnector ? this.getInfo().getDirContext() : this.getInfo().getUserDataDirContext();
        if (this.isServerRunning() && ctx != null) {
            String hostName = localHostName;
            if (hostName == null) {
                hostName = ConnectionUtils.getHostName(ctx);
            }
            int port = ConnectionUtils.getPort(ctx);
            boolean isSSL = ConnectionUtils.isSSL(ctx);
            boolean isStartTLS = ConnectionUtils.isStartTLS(ctx);
            String bindDN = ConnectionUtils.getBindDN(ctx);
            String bindPwd = ConnectionUtils.getBindPassword(ctx);
            args.add("--hostname");
            args.add(hostName);
            args.add("--port");
            args.add(String.valueOf(port));
            args.add("--bindDN");
            args.add(bindDN);
            args.add("--bindPassword");
            args.add(bindPwd);
            if (isSSL || isStartTLS) {
                args.add("--trustAll");
            }
            if (isSSL && addConnectionTypeParameters) {
                args.add("--useSSL");
            } else if (isStartTLS && addConnectionTypeParameters) {
                args.add("--useStartTLS");
            }
        }
        return args;
    }

    protected String getNoPropertiesFileArgument() {
        return "--noPropertiesFile";
    }

    public String getCommandLineToDisplay() {
        String cmdLineName = this.getCommandLinePath();
        if (cmdLineName != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(cmdLineName);
            List<String> args = this.getObfuscatedCommandLineArguments(this.getCommandLineArguments());
            args.removeAll(this.getConfigCommandLineArguments());
            for (String arg : args) {
                sb.append(" " + CommandBuilder.escapeValue(arg));
            }
            return sb.toString();
        }
        return null;
    }

    protected boolean isServerRunning() {
        return this.getInfo().getServerDescriptor().getStatus() == ServerDescriptor.ServerStatus.STARTED;
    }

    public ApplicationPrintStream getErrorPrintStream() {
        return this.errorPrintStream;
    }

    public ApplicationPrintStream getOutPrintStream() {
        return this.outPrintStream;
    }

    protected void printEquivalentCommandToModify(DN dn, Collection<ModificationItem> mods, boolean useAdminCtx) {
        this.printEquivalentCommandToModify(dn.toString(), mods, useAdminCtx);
    }

    protected void printEquivalentCommandToModify(String dn, Collection<ModificationItem> mods, boolean useAdminCtx) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getCommandLinePath("ldapmodify"));
        args.addAll(this.getObfuscatedCommandLineArguments(this.getConnectionCommandLineArguments(useAdminCtx, true)));
        args.add(this.getNoPropertiesFileArgument());
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(" " + CommandBuilder.escapeValue(arg));
        }
        sb.append("<br>");
        sb.append("dn: " + dn);
        boolean firstChangeType = true;
        for (ModificationItem mod : mods) {
            if (firstChangeType) {
                sb.append("<br>");
            } else {
                sb.append("-<br>");
            }
            firstChangeType = false;
            sb.append("changetype: modify<br>");
            Attribute attr = mod.getAttribute();
            String attrName = attr.getID();
            if (mod.getModificationOp() == 1) {
                sb.append("add: " + attrName + "<br>");
            } else if (mod.getModificationOp() == 2) {
                sb.append("replace: " + attrName + "<br>");
            } else {
                sb.append("delete: " + attrName + "<br>");
            }
            for (int i = 0; i < attr.size(); ++i) {
                try {
                    Object o = attr.get(i);
                    if (this.displayBase64(attr.getID())) {
                        sb.append(attrName + ":: ");
                    } else {
                        sb.append(attrName + ": ");
                    }
                    sb.append(this.obfuscateAttributeStringValue(attrName, o));
                    sb.append("<br>");
                    continue;
                }
                catch (NamingException ne) {
                    throw new IllegalStateException("Unexpected error parsing modifications: " + ne, ne);
                }
            }
        }
        this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_MODIFY.get().toString() + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
    }

    protected boolean displayBase64(String attrName) {
        Schema schema = null;
        if (this.getInfo() != null) {
            schema = this.getInfo().getServerDescriptor().getSchema();
        }
        return Utilities.hasBinarySyntax(attrName, schema);
    }

    protected void printEquivalentRenameCommand(DN oldDN, DN newDN, boolean useAdminCtx) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getCommandLinePath("ldapmodify"));
        args.addAll(this.getObfuscatedCommandLineArguments(this.getConnectionCommandLineArguments(useAdminCtx, true)));
        args.add(this.getNoPropertiesFileArgument());
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(" " + CommandBuilder.escapeValue(arg));
        }
        sb.append("<br>");
        sb.append("dn: " + oldDN);
        sb.append("<br>");
        sb.append("changetype: moddn<br>");
        sb.append("newrdn: " + newDN.getRDN() + "<br>");
        sb.append("deleteoldrdn: 1");
        this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_RENAME.get().toString() + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
    }

    protected Message getIncompatibilityMessage(Task taskRunning, Task taskToBeLaunched) {
        return AdminToolMessages.INFO_CTRL_PANEL_INCOMPATIBLE_TASKS.get(taskRunning.getTaskDescription().toString(), taskToBeLaunched.getTaskDescription().toString());
    }

    static {
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MAX_BINARY_LENGTH_TO_DISPLAY = 1024;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_STARTED,
        RUNNING,
        FINISHED_SUCCESSFULLY,
        FINISHED_WITH_ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NEW_BASEDN,
        NEW_INDEX,
        MODIFY_INDEX,
        DELETE_INDEX,
        NEW_VLV_INDEX,
        MODIFY_VLV_INDEX,
        DELETE_VLV_INDEX,
        IMPORT_LDIF,
        EXPORT_LDIF,
        BACKUP,
        RESTORE,
        VERIFY_INDEXES,
        REBUILD_INDEXES,
        ENABLE_WINDOWS_SERVICE,
        DISABLE_WINDOWS_SERVICE,
        START_SERVER,
        STOP_SERVER,
        JAVA_SETTINGS_UPDATE,
        NEW_ATTRIBUTE,
        NEW_OBJECTCLASS,
        DELETE_ATTRIBUTE,
        DELETE_OBJECTCLASS,
        MODIFY_ENTRY,
        NEW_ENTRY,
        DELETE_ENTRY,
        DELETE_BASEDN,
        DELETE_BACKEND,
        OTHER;

    }
}

