/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackupDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.BackupListPanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.tools.BackUpDB;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;

public class BackupPanel
extends BackupListPanel {
    private static final long serialVersionUID = -1626301350756394814L;
    private JComboBox backends;
    private JCheckBox allBackends;
    private JTextField backupID;
    private JRadioButton fullBackup;
    private JRadioButton incrementalBackup;
    private JCheckBox compressData;
    private JCheckBox encryptData;
    private JCheckBox generateMessageDigest;
    private JCheckBox signMessageDigest;
    private JLabel lBackend;
    private JLabel lNoBackendsFound;
    private JLabel lBackupID;
    private JLabel lBackupType;
    private JLabel lBackupOptions;
    private ChangeListener changeListener;
    private boolean backupIDInitialized = false;
    private static final Logger LOG = Logger.getLogger(BackupPanel.class.getName());

    public BackupPanel() {
        this.createLayout();
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_BACKUP_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.backupID;
    }

    protected void verifyBackupClicked() {
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.addErrorPane(gbc);
        gbc.weightx = 0.0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.lBackend = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BACKEND_LABEL.get());
        this.add((Component)this.lBackend, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        JPanel auxPanel = new JPanel(new GridBagLayout());
        this.add((Component)auxPanel, gbc);
        auxPanel.setOpaque(false);
        GridBagConstraints gbc2 = new GridBagConstraints();
        this.backends = Utilities.createComboBox();
        this.backends.setModel(new DefaultComboBoxModel<String>(new String[0]));
        auxPanel.add((Component)this.backends, gbc2);
        this.lNoBackendsFound = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_BACKENDS_FOUND_LABEL.get());
        this.add((Component)this.lNoBackendsFound, gbc);
        this.lNoBackendsFound.setVisible(false);
        gbc2.insets.left = 10;
        this.allBackends = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_BACKUP_ALL_BACKENDS_LABEL.get());
        auxPanel.add((Component)this.allBackends, gbc2);
        gbc.insets.top = 10;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.gridwidth = 1;
        this.lBackupType = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BACKUP_TYPE_LABEL.get());
        this.add((Component)this.lBackupType, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.fullBackup = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_FULL_BACKUP_LABEL.get());
        this.add((Component)this.fullBackup, gbc);
        ++gbc.gridy;
        gbc.insets.top = 5;
        this.incrementalBackup = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_INCREMENTAL_BACKUP_LABEL.get());
        this.add((Component)this.incrementalBackup, gbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.fullBackup);
        group.add(this.incrementalBackup);
        this.fullBackup.setSelected(true);
        gbc.insets.top = 10;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.gridwidth = 1;
        this.lBackupID = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BACKUP_ID_LABEL.get());
        this.add((Component)this.lBackupID, gbc);
        this.backupID = Utilities.createMediumTextField();
        gbc.weightx = 0.0;
        ++gbc.gridx;
        gbc.insets.left = 10;
        gbc.fill = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.backupID, gbc);
        gbc.insets.top = 10;
        gbc.gridx = 0;
        ++gbc.gridy;
        super.createLayout(gbc);
        this.verifyBackup.setVisible(false);
        this.lAvailableBackups.setText(AdminToolMessages.INFO_CTRL_PANEL_AVAILABLE_PARENT_BACKUPS_LABEL.get().toString());
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.lBackupOptions = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BACKUP_OPTIONS_LABEL.get());
        this.add((Component)this.lBackupOptions, gbc);
        this.compressData = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_COMPRESS_DATA_LABEL.get());
        this.compressData.setSelected(false);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.add((Component)this.compressData, gbc);
        this.encryptData = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_ENCRYPT_DATA_LABEL.get());
        ++gbc.gridy;
        gbc.insets.top = 5;
        this.add((Component)this.encryptData, gbc);
        this.encryptData.setSelected(false);
        this.generateMessageDigest = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_GENERATE_MESSAGE_DIGEST_LABEL.get());
        ++gbc.gridy;
        this.add((Component)this.generateMessageDigest, gbc);
        this.signMessageDigest = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_SIGN_MESSAGE_DIGEST_HASH_LABEL.get());
        gbc.insets.left = 30;
        ++gbc.gridy;
        this.add((Component)this.signMessageDigest, gbc);
        this.generateMessageDigest.setSelected(false);
        this.changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                BackupPanel.this.backends.setEnabled(!BackupPanel.this.allBackends.isSelected());
                BackupPanel.this.signMessageDigest.setEnabled(BackupPanel.this.generateMessageDigest.isSelected());
                boolean enable = BackupPanel.this.incrementalBackup.isSelected();
                BackupPanel.this.refreshList.setEnabled(enable);
                BackupPanel.this.tableScroll.setEnabled(enable);
                BackupPanel.this.backupList.setEnabled(enable);
            }
        };
        this.incrementalBackup.addChangeListener(this.changeListener);
        this.generateMessageDigest.addChangeListener(this.changeListener);
        this.allBackends.addChangeListener(this.changeListener);
        this.changeListener.stateChanged(null);
        this.addBottomGlue(gbc);
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        this.updateSimpleBackendComboBoxModel(this.backends, this.lNoBackendsFound, desc);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BackupPanel.this.allBackends.setVisible(BackupPanel.this.backends.getModel().getSize() > 0);
            }
        });
        super.configurationChanged(ev);
        this.updateErrorPaneAndOKButtonIfAuthRequired(this.getInfo().getServerDescriptor(), AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_BACKUP.get());
    }

    public void okClicked() {
        File f;
        this.setPrimaryValid(this.lBackend);
        this.setPrimaryValid(this.lPath);
        this.setPrimaryValid(this.lAvailableBackups);
        this.backupIDInitialized = false;
        final LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        if (!this.allBackends.isSelected()) {
            String backendName = (String)this.backends.getSelectedItem();
            if (backendName == null) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_BACKENDS_SELECTED.get());
                this.setPrimaryInvalid(this.lBackend);
            }
        } else if (this.backends.getModel().getSize() == 0) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_BACKENDS_AVAILABLE.get());
            this.setPrimaryInvalid(this.lBackend);
        }
        String parentPath = this.parentDirectory.getText();
        if (parentPath == null || parentPath.trim().equals("")) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_BACKUP_PATH_PROVIDED.get());
            this.setPrimaryInvalid(this.lPath);
        } else {
            File f2 = new File(parentPath);
            if (f2.isFile()) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_BACKUP_PATH_IS_A_FILE.get(parentPath));
                this.setPrimaryInvalid(this.lPath);
            } else if (!f2.exists()) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_BACKUP_PATH_DOES_NOT_EXIST.get(parentPath));
                this.setPrimaryInvalid(this.lPath);
            }
        }
        String dir = this.backupID.getText();
        if (dir == null || dir.trim().equals("")) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_BACKUP_ID_PROVIDED.get());
            this.setPrimaryInvalid(this.lBackupID);
        }
        if (errors.isEmpty() && (f = new File(parentPath, dir)).isFile()) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_BACKUP_PATH_EXISTS.get(f.getAbsolutePath()));
            this.setPrimaryInvalid(this.lPath);
        }
        if (this.incrementalBackup.isSelected()) {
            boolean selected;
            boolean bl = selected = this.backupList.isVisible() && this.getSelectedBackup() != null;
            if (!selected) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_PARENT_BACKUP_SELECTED.get());
                this.setPrimaryInvalid(this.lAvailableBackups);
            }
        }
        final JComponent[] components = new JComponent[]{this.backends, this.allBackends, this.fullBackup, this.incrementalBackup, this.parentDirectory, this.browse, this.backupList, this.refreshList, this.compressData, this.encryptData, this.generateMessageDigest, this.signMessageDigest};
        this.setEnabledOK(false);
        this.setEnabledCancel(false);
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(false);
        }
        final String id = this.backupID.getText();
        final String path = this.parentDirectory.getText();
        BackgroundTask<Void> worker = new BackgroundTask<Void>(){

            @Override
            public Void processBackgroundTask() throws Throwable {
                LinkedHashSet<BackupInfo> backups;
                block6: {
                    backups = new LinkedHashSet<BackupInfo>();
                    try {
                        BackupDirectory backupDir = BackupDirectory.readBackupDirectoryDescriptor(path);
                        backups.addAll(backupDir.getBackups().values());
                    }
                    catch (Throwable t) {
                        File f = new File(path);
                        if (!f.isDirectory()) break block6;
                        File[] children = f.listFiles();
                        for (int i = 0; i < children.length; ++i) {
                            if (!children[i].isDirectory()) continue;
                            try {
                                BackupDirectory backupDir = BackupDirectory.readBackupDirectoryDescriptor(children[i].getAbsolutePath());
                                backups.addAll(backupDir.getBackups().values());
                                continue;
                            }
                            catch (Throwable t2) {
                                if (children[i].getName().equals("tasks")) continue;
                                LOG.log(Level.WARNING, "Error searching backup: " + t2, t2);
                            }
                        }
                    }
                }
                for (BackupInfo backup : backups) {
                    if (!backup.getBackupID().equalsIgnoreCase(id)) continue;
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_BACKUP_ID_ALREADY_EXIST.get(id, path));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BackupPanel.this.setPrimaryInvalid(BackupPanel.this.lBackupID);
                        }
                    });
                    break;
                }
                return null;
            }

            @Override
            public void backgroundTaskCompleted(Void returnValue, Throwable t) {
                for (int i = 0; i < components.length; ++i) {
                    components[i].setEnabled(true);
                }
                BackupPanel.this.setEnabledOK(true);
                BackupPanel.this.setEnabledCancel(true);
                BackupPanel.this.changeListener.stateChanged(null);
                if (errors.isEmpty()) {
                    ProgressDialog progressDialog = new ProgressDialog((Component)Utilities.getParentDialog(BackupPanel.this), BackupPanel.this.getTitle(), BackupPanel.this.getInfo());
                    BackupTask newTask = new BackupTask(BackupPanel.this.getInfo(), progressDialog);
                    for (Task task : BackupPanel.this.getInfo().getTasks()) {
                        task.canLaunch(newTask, errors);
                    }
                    if (errors.isEmpty()) {
                        Message initMsg = BackupPanel.this.allBackends.isSelected() ? AdminToolMessages.INFO_CTRL_PANEL_RUN_BACKUP_ALL_BACKENDS.get() : AdminToolMessages.INFO_CTRL_PANEL_RUN_BACKUP_SUMMARY.get(BackupPanel.this.backends.getSelectedItem().toString());
                        BackupPanel.this.launchOperation(newTask, initMsg, AdminToolMessages.INFO_CTRL_PANEL_RUN_BACKUP_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_RUN_BACKUP_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_RUN_BACKUP_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_RUN_BACKUP_ERROR_DETAILS, progressDialog);
                        progressDialog.setVisible(true);
                        Utilities.getParentDialog(BackupPanel.this).setVisible(false);
                    }
                }
                if (errors.size() > 0) {
                    BackupPanel.this.displayErrorDialog(errors);
                }
            }
        };
        if (errors.isEmpty()) {
            worker.startBackgroundTask();
        } else {
            worker.backgroundTaskCompleted(null, null);
        }
    }

    public void cancelClicked() {
        this.setPrimaryValid(this.lBackend);
        this.setPrimaryValid(this.lPath);
        this.setPrimaryValid(this.lAvailableBackups);
        super.cancelClicked();
    }

    public void toBeDisplayed(boolean visible) {
        super.toBeDisplayed(visible);
        if (visible && !this.backupIDInitialized) {
            this.initializeBackupID();
        }
        if (!visible) {
            this.backupIDInitialized = false;
        }
    }

    private void initializeBackupID() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String id = dateFormat.format(new Date());
        this.backupID.setText(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BackupTask
    extends Task {
        private Set<String> backendSet;
        private String dir;

        public BackupTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(info, dlg);
            this.backendSet = new HashSet<String>();
            if (!BackupPanel.this.allBackends.isSelected()) {
                this.backendSet.add((String)BackupPanel.this.backends.getSelectedItem());
            } else {
                for (BackendDescriptor backend : info.getServerDescriptor().getBackends()) {
                    if (backend.isConfigBackend()) continue;
                    this.backendSet.add(backend.getBackendID());
                }
            }
            if (BackupPanel.this.incrementalBackup.isSelected()) {
                BackupDescriptor backup = BackupPanel.this.getSelectedBackup();
                this.dir = backup.getPath().getAbsolutePath();
            } else {
                this.dir = BackupPanel.this.parentDirectory.getText();
            }
        }

        @Override
        public Task.Type getType() {
            return Task.Type.BACKUP;
        }

        @Override
        public Message getTaskDescription() {
            return AdminToolMessages.INFO_CTRL_PANEL_BACKUP_TASK_DESCRIPTION.get(Utilities.getStringFromCollection(this.backendSet, ", "), this.dir);
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (this.state == Task.State.RUNNING) {
                TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
                backends.retainAll(this.getBackends());
                if (backends.size() > 0) {
                    incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                    canLaunch = false;
                }
            }
            return canLaunch;
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                List arguments = this.getCommandLineArguments();
                String[] args = new String[((ArrayList)arguments).size()];
                ((ArrayList)arguments).toArray(args);
                this.returnCode = this.isServerRunning() ? Integer.valueOf(BackUpDB.mainBackUpDB(args, false, this.outPrintStream, this.errorPrintStream)) : Integer.valueOf(this.executeCommandLine(this.getCommandLinePath(), args));
                if (this.returnCode != 0) {
                    this.state = Task.State.FINISHED_WITH_ERROR;
                } else {
                    this.getInfo().backupCreated(new BackupDescriptor(new File(BackupPanel.this.parentDirectory.getText()), new Date(), BackupPanel.this.fullBackup.isSelected() ? BackupDescriptor.Type.FULL : BackupDescriptor.Type.INCREMENTAL, BackupPanel.this.backupID.getText()));
                    this.state = Task.State.FINISHED_SUCCESSFULLY;
                }
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
        }

        @Override
        public Set<String> getBackends() {
            return this.backendSet;
        }

        protected ArrayList<String> getCommandLineArguments() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--backupDirectory");
            args.add(this.dir);
            args.add("--backupID");
            args.add(BackupPanel.this.backupID.getText());
            if (BackupPanel.this.allBackends.isSelected()) {
                args.add("--backUpAll");
            } else {
                args.add("--backendID");
                args.add((String)BackupPanel.this.backends.getSelectedItem());
            }
            if (BackupPanel.this.incrementalBackup.isSelected()) {
                args.add("--incremental");
                BackupDescriptor backup = BackupPanel.this.getSelectedBackup();
                args.add("--incrementalBaseID");
                args.add(backup.getID());
            }
            if (BackupPanel.this.compressData.isSelected()) {
                args.add("--compress");
            }
            if (BackupPanel.this.encryptData.isSelected()) {
                args.add("--encrypt");
            }
            if (BackupPanel.this.generateMessageDigest.isSelected()) {
                args.add("--hash");
                if (BackupPanel.this.signMessageDigest.isSelected()) {
                    args.add("--signHash");
                }
            }
            args.addAll(this.getConnectionCommandLineArguments());
            if (this.isServerRunning()) {
                args.addAll(this.getConfigCommandLineArguments());
            }
            args.add(this.getNoPropertiesFileArgument());
            return args;
        }

        @Override
        protected String getCommandLinePath() {
            return this.getCommandLinePath("backup");
        }
    }
}

