/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ConfigurationElementCreatedEvent;
import org.opends.guitools.controlpanel.event.ConfigurationElementCreatedListener;
import org.opends.guitools.controlpanel.event.IndexModifiedEvent;
import org.opends.guitools.controlpanel.event.IndexModifiedListener;
import org.opends.guitools.controlpanel.event.IndexSelectionEvent;
import org.opends.guitools.controlpanel.event.IndexSelectionListener;
import org.opends.guitools.controlpanel.task.DeleteIndexTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.IndexBrowserRightPanel;
import org.opends.guitools.controlpanel.ui.NewIndexPanel;
import org.opends.guitools.controlpanel.ui.NewVLVIndexPanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.CustomTree;
import org.opends.guitools.controlpanel.ui.components.TreePanel;
import org.opends.guitools.controlpanel.ui.nodes.AbstractIndexTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.CategoryTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.IndexTreeNode;
import org.opends.guitools.controlpanel.ui.nodes.VLVIndexTreeNode;
import org.opends.guitools.controlpanel.ui.renderer.TreeCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.guitools.controlpanel.util.ViewPositions;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class BrowseIndexPanel
extends StatusGenericPanel
implements IndexModifiedListener {
    private static final long serialVersionUID = 4560020571983291585L;
    private JComboBox backends;
    private JLabel lNoBackendsFound;
    private IndexBrowserRightPanel entryPane;
    private TreePanel treePane;
    private JScrollPane treeScroll;
    private JButton newIndex;
    private JButton newVLVIndex;
    private CategoryTreeNode standardIndexes = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_INDEXES_CATEGORY_NODE.get());
    private CategoryTreeNode vlvIndexes = new CategoryTreeNode(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEXES_CATEGORY_NODE.get());
    private AbstractIndexDescriptor lastCreatedIndex;
    private TreePath lastIndexTreePath;
    private CategoryTreeNode[] categoryNodes = new CategoryTreeNode[]{this.standardIndexes, this.vlvIndexes};
    private JMenuItem deleteMenuItem;
    private GenericDialog newIndexDialog;
    private NewIndexPanel newIndexPanel;
    private GenericDialog newVLVIndexDialog;
    private NewVLVIndexPanel newVLVIndexPanel;
    private boolean ignoreSelectionEvents;
    private boolean firstTreeRepopulate = true;
    private HashMap<Object, ImageIcon> hmCategoryImages = new HashMap();
    private HashMap<Class, ImageIcon> hmImages = new HashMap();

    public BrowseIndexPanel() {
        Object[] nodes = new Object[]{this.standardIndexes, this.vlvIndexes};
        String[] paths = new String[]{"ds-idx-folder.png", "ds-vlv-idx-folder.png"};
        for (int i = 0; i < nodes.length; ++i) {
            this.hmCategoryImages.put(nodes[i], Utilities.createImageIcon("org/opends/guitools/controlpanel/images/" + paths[i]));
        }
        Class[] classes = new Class[]{IndexTreeNode.class, VLVIndexTreeNode.class};
        String[] ocPaths = new String[]{"ds-idx.png", "ds-vlv-idx.png"};
        for (int i = 0; i < classes.length; ++i) {
            this.hmImages.put(classes[i], Utilities.createImageIcon("org/opends/guitools/controlpanel/images/" + ocPaths[i]));
        }
        this.createLayout();
    }

    public boolean requiresBorder() {
        return false;
    }

    public boolean requiresScroll() {
        return false;
    }

    public void toBeDisplayed(boolean visible) {
        super.toBeDisplayed(visible);
        ((GenericDialog)Utilities.getParentDialog(this)).getRootPane().setDefaultButton(null);
    }

    private void createLayout() {
        this.setBackground(ColorAndFontConstants.greyBackground);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 0, 0);
        JLabel lBackend = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BACKEND_LABEL.get());
        this.add((Component)lBackend, gbc);
        this.backends = Utilities.createComboBox();
        this.backends.setModel(new DefaultComboBoxModel<String>(new String[0]));
        ItemListener comboListener = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (!BrowseIndexPanel.this.ignoreSelectionEvents && ev.getStateChange() == 1) {
                    BrowseIndexPanel.this.repopulateTree(BrowseIndexPanel.this.treePane.getTree());
                }
            }
        };
        this.backends.addItemListener(comboListener);
        gbc.insets.left = 5;
        ++gbc.gridx;
        this.add((Component)this.backends, gbc);
        this.lNoBackendsFound = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_BACKENDS_FOUND_LABEL.get());
        this.add((Component)this.lNoBackendsFound, gbc);
        this.lNoBackendsFound.setVisible(false);
        this.newIndex = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_NEW_INDEX_BUTTON_LABEL.get());
        this.newIndex.setOpaque(false);
        this.newIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseIndexPanel.this.newIndexClicked();
            }
        });
        ++gbc.gridx;
        gbc.insets.left = 10;
        this.add((Component)this.newIndex, gbc);
        this.newVLVIndex = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_NEW_VLV_INDEX_BUTTON_LABEL.get());
        this.newVLVIndex.setOpaque(false);
        this.newVLVIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseIndexPanel.this.newVLVIndexClicked();
            }
        });
        ++gbc.gridx;
        gbc.insets.right = 10;
        this.add((Component)this.newVLVIndex, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        this.add(Box.createHorizontalGlue(), gbc);
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 5;
        this.add(this.createSplitPane(), gbc);
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_MANAGE_INDEXES_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.backends;
    }

    public void closeClicked() {
        super.closeClicked();
    }

    public void okClicked() {
    }

    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.CLOSE;
    }

    private Component createSplitPane() {
        JSplitPane pane = new JSplitPane(1);
        pane.setOpaque(true);
        this.treePane = new TreePanel();
        Utilities.setBorder(this.treePane, new EmptyBorder(10, 0, 10, 0));
        this.entryPane = new IndexBrowserRightPanel();
        this.treeScroll = Utilities.createScrollPane(this.treePane);
        this.entryPane.addIndexSelectionListener(new IndexSelectionListener(){

            public void indexSelected(IndexSelectionEvent ev) {
                AbstractIndexDescriptor index = ev.getIndex();
                CategoryTreeNode parentNode = index instanceof IndexDescriptor ? BrowseIndexPanel.this.standardIndexes : BrowseIndexPanel.this.vlvIndexes;
                DefaultTreeModel model = (DefaultTreeModel)BrowseIndexPanel.this.treePane.getTree().getModel();
                int n = model.getChildCount(parentNode);
                for (int i = 0; i < n; ++i) {
                    AbstractIndexTreeNode node = (AbstractIndexTreeNode)model.getChild(parentNode, i);
                    if (!node.getName().equals(index.getName())) continue;
                    TreePath newSelectionPath = new TreePath(node.getPath());
                    BrowseIndexPanel.this.treePane.getTree().setSelectionPath(newSelectionPath);
                    BrowseIndexPanel.this.treePane.getTree().scrollPathToVisible(newSelectionPath);
                    break;
                }
            }
        });
        pane.setLeftComponent(this.treeScroll);
        pane.setRightComponent(this.entryPane);
        pane.setResizeWeight(0.0);
        this.treePane.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent ev) {
                if (!BrowseIndexPanel.this.ignoreSelectionEvents) {
                    TreePath[] paths = BrowseIndexPanel.this.treePane.getTree().getSelectionPaths();
                    if (BrowseIndexPanel.this.entryPane.mustCheckUnsavedChanges()) {
                        BrowseIndexPanel.this.ignoreSelectionEvents = true;
                        BrowseIndexPanel.this.treePane.getTree().setSelectionPath(BrowseIndexPanel.this.lastIndexTreePath);
                        switch (BrowseIndexPanel.this.entryPane.checkUnsavedChanges()) {
                            case DO_NOT_SAVE: {
                                break;
                            }
                            case SAVE: {
                                break;
                            }
                            case CANCEL: {
                                BrowseIndexPanel.this.ignoreSelectionEvents = false;
                                return;
                            }
                        }
                        if (paths != null) {
                            BrowseIndexPanel.this.treePane.getTree().setSelectionPaths(paths);
                        } else {
                            BrowseIndexPanel.this.treePane.getTree().clearSelection();
                        }
                        BrowseIndexPanel.this.ignoreSelectionEvents = false;
                    }
                    boolean deletableElementsSelected = false;
                    boolean nonDeletableElementsSelected = false;
                    if (paths != null) {
                        for (TreePath path : paths) {
                            Object node = path.getLastPathComponent();
                            if (node instanceof IndexTreeNode) {
                                IndexDescriptor index = ((IndexTreeNode)node).getIndex();
                                if (index.isDatabaseIndex()) {
                                    nonDeletableElementsSelected = true;
                                    continue;
                                }
                                deletableElementsSelected = true;
                                continue;
                            }
                            if (!(node instanceof VLVIndexTreeNode)) continue;
                            deletableElementsSelected = true;
                        }
                    }
                    BrowseIndexPanel.this.deleteMenuItem.setEnabled(deletableElementsSelected && !nonDeletableElementsSelected);
                    BrowseIndexPanel.this.updateEntryPane();
                }
            }
        });
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Tree root");
        for (CategoryTreeNode node : this.categoryNodes) {
            root.add(node);
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        JTree tree = this.treePane.getTree();
        tree.setModel(model);
        tree.setRootVisible(false);
        tree.setVisibleRowCount(20);
        tree.expandPath(new TreePath(root));
        tree.setCellRenderer(new IndexTreeCellRenderer());
        this.addPopupMenu();
        this.treeScroll.setPreferredSize(new Dimension(2 * this.treeScroll.getPreferredSize().width, 8 * this.treeScroll.getPreferredSize().height));
        this.entryPane.setBorder(this.getRightPanelBorder());
        this.entryPane.setPreferredSize(new Dimension(this.treeScroll.getPreferredSize().width * 5 / 2, this.treeScroll.getPreferredSize().height));
        pane.setDividerLocation(this.treeScroll.getPreferredSize().width);
        this.entryPane.displayVoid();
        return pane;
    }

    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        this.treePane.setInfo(info);
        this.entryPane.setInfo(info);
        info.addIndexModifiedListener(this);
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        this.ignoreSelectionEvents = true;
        ServerDescriptor desc = ev.getNewDescriptor();
        this.updateSimpleBackendComboBoxModel(this.backends, this.lNoBackendsFound, desc);
        this.refreshContents(desc);
    }

    private void addPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_INDEX_MENU.get());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseIndexPanel.this.newIndexClicked();
            }
        });
        popup.add(menuItem);
        menuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_NEW_VLV_INDEX_MENU.get());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseIndexPanel.this.newVLVIndexClicked();
            }
        });
        popup.add(menuItem);
        popup.add(new JSeparator());
        this.deleteMenuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_DELETE_INDEX_MENU.get());
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BrowseIndexPanel.this.deleteClicked();
            }
        });
        popup.add(this.deleteMenuItem);
        this.deleteMenuItem.setEnabled(false);
        ((CustomTree)this.treePane.getTree()).setPopupMenu(popup);
    }

    private void refreshContents(ServerDescriptor desc) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BrowseIndexPanel.this.repopulateTree(BrowseIndexPanel.this.treePane.getTree());
                BrowseIndexPanel.this.ignoreSelectionEvents = false;
                boolean userBackendsDefined = BrowseIndexPanel.this.backends.getModel().getSize() > 0;
                BrowseIndexPanel.this.newIndex.setEnabled(userBackendsDefined);
                BrowseIndexPanel.this.newVLVIndex.setEnabled(userBackendsDefined);
                if (!userBackendsDefined) {
                    BrowseIndexPanel.this.entryPane.displayVoid();
                    BrowseIndexPanel.this.updateErrorPane(BrowseIndexPanel.this.errorPane, AdminToolMessages.ERR_CTRL_PANEL_NO_BACKENDS_FOUND_TITLE.get(), ColorAndFontConstants.errorTitleFont, AdminToolMessages.ERR_CTRL_PANEL_NO_BACKENDS_FOUND_DETAILS.get(), ColorAndFontConstants.defaultFont);
                    BrowseIndexPanel.this.errorPane.setVisible(true);
                } else {
                    BrowseIndexPanel.this.errorPane.setVisible(false);
                }
            }
        });
    }

    public void indexModified(IndexModifiedEvent ev) {
        this.refreshContents(this.getInfo().getServerDescriptor());
    }

    public void backendIndexesModified(IndexModifiedEvent ev) {
        this.refreshContents(this.getInfo().getServerDescriptor());
    }

    /*
     * WARNING - void declaration
     */
    private void repopulateTree(JTree tree) {
        this.ignoreSelectionEvents = true;
        final Point currentPosition = this.treeScroll.getViewport().getViewPosition();
        DefaultMutableTreeNode root = this.getRoot(tree);
        TreePath path = tree.getSelectionPath();
        DefaultMutableTreeNode lastSelectedNode = null;
        if (path != null) {
            lastSelectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        TreePath newSelectionPath = null;
        BackendDescriptor backend = null;
        String backendName = (String)this.backends.getSelectedItem();
        if (backendName != null) {
            for (BackendDescriptor b : this.getInfo().getServerDescriptor().getBackends()) {
                if (!b.getBackendID().equalsIgnoreCase(backendName)) continue;
                backend = b;
                break;
            }
        }
        ArrayList nodes = new ArrayList();
        ArrayList<IndexTreeNode> standardIndexNodes = new ArrayList<IndexTreeNode>();
        ArrayList<VLVIndexTreeNode> vlvIndexNodes = new ArrayList<VLVIndexTreeNode>();
        nodes.add(standardIndexNodes);
        nodes.add(vlvIndexNodes);
        if (backend != null) {
            for (IndexDescriptor indexDescriptor : backend.getIndexes()) {
                standardIndexNodes.add(new IndexTreeNode(indexDescriptor.getName(), indexDescriptor));
            }
            for (VLVIndexDescriptor vLVIndexDescriptor : backend.getVLVIndexes()) {
                vlvIndexNodes.add(new VLVIndexTreeNode(vLVIndexDescriptor.getName(), vLVIndexDescriptor));
            }
        }
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        boolean bl = false;
        int positionUnderRoot = 0;
        for (CategoryTreeNode parent : this.categoryNodes) {
            void var13_17;
            if (((ArrayList)nodes.get((int)var13_17)).size() == 0) {
                if (root.getIndex(parent) != -1) {
                    model.removeNodeFromParent(parent);
                    parent.removeAllChildren();
                }
            } else {
                boolean expand = true;
                if (root.getIndex(parent) == -1) {
                    model.insertNodeInto(parent, root, positionUnderRoot);
                } else {
                    expand = tree.isExpanded(new TreePath(parent)) || parent.getChildCount() == 0;
                    parent.removeAllChildren();
                }
                for (AbstractIndexTreeNode node : (ArrayList)nodes.get((int)var13_17)) {
                    parent.add(node);
                    if (newSelectionPath != null || lastSelectedNode == null && this.lastCreatedIndex == null) continue;
                    if (this.lastCreatedIndex != null) {
                        if (node instanceof IndexTreeNode && this.lastCreatedIndex instanceof IndexDescriptor) {
                            if (!node.getName().equals(this.lastCreatedIndex.getName())) continue;
                            newSelectionPath = new TreePath(node.getPath());
                            this.lastCreatedIndex = null;
                            continue;
                        }
                        if (!(node instanceof VLVIndexTreeNode) || !(this.lastCreatedIndex instanceof VLVIndexDescriptor) || !node.getName().equals(this.lastCreatedIndex.getName())) continue;
                        newSelectionPath = new TreePath(node.getPath());
                        this.lastCreatedIndex = null;
                        continue;
                    }
                    if (!node.getName().equals(lastSelectedNode.getUserObject())) continue;
                    newSelectionPath = new TreePath(node.getPath());
                }
                model.nodeStructureChanged(parent);
                if (expand) {
                    tree.expandPath(new TreePath(parent.getPath()));
                }
                ++positionUnderRoot;
            }
            ++var13_17;
        }
        if (newSelectionPath == null && this.firstTreeRepopulate) {
            newSelectionPath = new TreePath(this.standardIndexes.getPath());
        }
        if (newSelectionPath != null) {
            tree.setSelectionPath(newSelectionPath);
            tree.scrollPathToVisible(newSelectionPath);
        }
        this.updateEntryPane();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BrowseIndexPanel.this.firstTreeRepopulate) {
                    BrowseIndexPanel.this.treeScroll.getViewport().setViewPosition(new Point(0, 0));
                } else {
                    BrowseIndexPanel.this.treeScroll.getViewport().setViewPosition(currentPosition);
                }
            }
        });
        this.firstTreeRepopulate = false;
        this.ignoreSelectionEvents = false;
    }

    private void updateEntryPane() {
        ViewPositions pos = Utilities.getViewPositions(this.entryPane);
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        TreePath path = null;
        if (paths != null && paths.length == 1) {
            path = paths[0];
        }
        this.lastIndexTreePath = path;
        if (path != null) {
            Object node = path.getLastPathComponent();
            if (node instanceof IndexTreeNode) {
                this.entryPane.updateStandardIndex(((IndexTreeNode)node).getIndex());
            } else if (node instanceof VLVIndexTreeNode) {
                this.entryPane.updateVLVIndex(((VLVIndexTreeNode)node).getIndex());
            } else if (node == this.standardIndexes) {
                String backendName = (String)this.backends.getSelectedItem();
                this.entryPane.updateBackendIndexes(backendName);
            } else if (node == this.vlvIndexes) {
                String backendName = (String)this.backends.getSelectedItem();
                this.entryPane.updateBackendVLVIndexes(backendName);
            } else {
                this.entryPane.displayVoid();
            }
        } else if (paths != null && paths.length > 1) {
            this.entryPane.displayMultiple();
        } else {
            this.entryPane.displayVoid();
        }
        Utilities.updateViewPositions(pos);
    }

    private DefaultMutableTreeNode getRoot(JTree tree) {
        return (DefaultMutableTreeNode)tree.getModel().getRoot();
    }

    private void newIndexClicked() {
        if (this.newIndexPanel == null) {
            this.newIndexPanel = new NewIndexPanel((String)this.backends.getSelectedItem(), Utilities.getParentDialog(this));
            this.newIndexPanel.setInfo(this.getInfo());
            this.newIndexDialog = new GenericDialog(null, this.newIndexPanel);
            Utilities.centerGoldenMean(this.newIndexDialog, Utilities.getParentDialog(this));
            this.newIndexPanel.addConfigurationElementCreatedListener(new ConfigurationElementCreatedListener(){

                public void elementCreated(ConfigurationElementCreatedEvent ev) {
                    Object o = ev.getConfigurationObject();
                    if (o instanceof AbstractIndexDescriptor) {
                        BrowseIndexPanel.this.lastCreatedIndex = (AbstractIndexDescriptor)o;
                    }
                }
            });
        } else if (!this.newIndexDialog.isVisible()) {
            String backendID = (String)this.backends.getSelectedItem();
            for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                if (!backend.getBackendID().equalsIgnoreCase(backendID)) continue;
                this.newIndexPanel.update(backend);
                break;
            }
        }
        this.newIndexDialog.setVisible(true);
    }

    private void newVLVIndexClicked() {
        if (this.newVLVIndexPanel == null) {
            this.newVLVIndexPanel = new NewVLVIndexPanel((String)this.backends.getSelectedItem(), Utilities.getParentDialog(this));
            this.newVLVIndexPanel.setInfo(this.getInfo());
            this.newVLVIndexDialog = new GenericDialog(null, this.newVLVIndexPanel);
            Utilities.centerGoldenMean(this.newVLVIndexDialog, Utilities.getParentDialog(this));
            this.newVLVIndexPanel.addConfigurationElementCreatedListener(new ConfigurationElementCreatedListener(){

                public void elementCreated(ConfigurationElementCreatedEvent ev) {
                    Object o = ev.getConfigurationObject();
                    if (o instanceof AbstractIndexDescriptor) {
                        BrowseIndexPanel.this.lastCreatedIndex = (AbstractIndexDescriptor)o;
                    }
                }
            });
        } else if (!this.newVLVIndexDialog.isVisible()) {
            String backendID = (String)this.backends.getSelectedItem();
            for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                if (!backend.getBackendID().equalsIgnoreCase(backendID)) continue;
                this.newVLVIndexPanel.update(backend);
                break;
            }
        }
        this.newVLVIndexDialog.setVisible(true);
    }

    private void deleteClicked() {
        ArrayList<Message> errors = new ArrayList<Message>();
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        ArrayList<AbstractIndexDescriptor> indexesToDelete = new ArrayList<AbstractIndexDescriptor>();
        ArrayList<String> indexesNames = new ArrayList<String>();
        if (paths != null) {
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                if (node instanceof IndexTreeNode) {
                    indexesToDelete.add(((IndexTreeNode)node).getIndex());
                    continue;
                }
                if (!(node instanceof VLVIndexTreeNode)) continue;
                indexesToDelete.add(((VLVIndexTreeNode)node).getIndex());
            }
        } else {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_INDEX_SELECTED.get());
        }
        for (AbstractIndexDescriptor index : indexesToDelete) {
            indexesNames.add(index.getName());
        }
        String nameLabel = Utilities.getStringFromCollection(indexesNames, ", ");
        String backendName = ((AbstractIndexDescriptor)indexesToDelete.get(0)).getBackend().getBackendID();
        if (errors.isEmpty()) {
            ProgressDialog dlg = new ProgressDialog((Component)Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_DELETE_INDEXES_TITLE.get(), this.getInfo());
            DeleteIndexTask newTask = new DeleteIndexTask(this.getInfo(), dlg, indexesToDelete);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            if (errors.isEmpty() && this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_INDEXES_DELETE_DETAILS.get(nameLabel, backendName))) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_INDEXES_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_INDEXES_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_INDEXES_SUCCESSFUL.get(nameLabel, backendName), AdminToolMessages.ERR_CTRL_PANEL_DELETING_INDEXES_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_INDEXES_ERROR_DETAILS.get(nameLabel), null, dlg);
                dlg.setVisible(true);
            }
        }
        if (!errors.isEmpty()) {
            this.displayErrorDialog(errors);
        }
    }

    protected class IndexTreeCellRenderer
    extends TreeCellRenderer {
        private ImageIcon readOnlyIndexIcon = Utilities.createImageIcon("org/opends/guitools/controlpanel/images/ds-idx-ro.png");
        private static final long serialVersionUID = -6953837045703643228L;

        protected IndexTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
            this.setIcon(this.getIcon(value));
            return this;
        }

        private ImageIcon getIcon(Object value) {
            ImageIcon icon = null;
            if (value instanceof IndexTreeNode && ((IndexTreeNode)value).getIndex().isDatabaseIndex()) {
                icon = this.readOnlyIndexIcon;
            }
            if (icon == null && (icon = (ImageIcon)BrowseIndexPanel.this.hmImages.get(value.getClass())) == null) {
                icon = (ImageIcon)BrowseIndexPanel.this.hmCategoryImages.get(value);
            }
            return icon;
        }
    }
}

