/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.DeleteBaseDNAndBackendTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.DeleteBaseDNPanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteBackendPanel
extends DeleteBaseDNPanel {
    private static final long serialVersionUID = 8744925738292396658L;

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_DELETE_BACKEND_TITLE.get();
    }

    @Override
    protected Message getNoElementsFoundLabel() {
        return AdminToolMessages.INFO_CTRL_PANEL_NO_BACKENDS_FOUND_LABEL.get();
    }

    @Override
    protected Message getListLabel() {
        return AdminToolMessages.INFO_CTRL_PANEL_SELECT_BACKENDS_TO_DELETE.get();
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        TreeSet<String> newElements = new TreeSet<String>();
        for (BackendDescriptor backend : desc.getBackends()) {
            if (backend.isConfigBackend()) continue;
            newElements.add(backend.getBackendID());
        }
        this.updateList(newElements);
        this.updateErrorPaneAndOKButtonIfAuthRequired(this.getInfo().getServerDescriptor(), AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_BACKEND_DELETE.get());
    }

    @Override
    public void okClicked() {
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        ProgressDialog progressDialog = new ProgressDialog((Component)Utilities.getParentDialog(this), this.getTitle(), this.getInfo());
        Object[] backends = this.list.getSelectedValues();
        ArrayList<BackendDescriptor> backendsToDelete = new ArrayList<BackendDescriptor>();
        block0: for (Object o : backends) {
            String id = (String)o;
            for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                if (!backend.getBackendID().equalsIgnoreCase(id)) continue;
                backendsToDelete.add(backend);
                continue block0;
            }
        }
        DeleteBaseDNAndBackendTask newTask = new DeleteBaseDNAndBackendTask(this.getInfo(), progressDialog, backendsToDelete, new HashSet<BaseDNDescriptor>());
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        if (errors.isEmpty()) {
            Message confirmationMessage = this.getConfirmationMessage(backendsToDelete);
            if (this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), confirmationMessage)) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_BACKENDS_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_BACKENDS_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_BACKENDS_SUCCESSFUL.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_BACKENDS_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_BACKENDS_ERROR_DETAILS.get(), null, progressDialog);
                progressDialog.setVisible(true);
                Utilities.getParentDialog(this).setVisible(false);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    private Message getConfirmationMessage(Collection<BackendDescriptor> backendsToDelete) {
        MessageBuilder mb = new MessageBuilder();
        mb.append(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_DELETE_BACKENDS_DETAILS.get());
        for (BackendDescriptor backend : backendsToDelete) {
            mb.append("<br> - " + backend.getBackendID());
        }
        mb.append("<br><br>");
        mb.append(AdminToolMessages.INFO_CTRL_PANEL_DO_YOU_WANT_TO_CONTINUE.get());
        return mb.toMessage();
    }
}

