/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JPanel;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.DBEnvironmentMonitoringPanel;
import org.opends.guitools.controlpanel.ui.EntryCachesMonitoringPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.JavaInformationMonitoringPanel;
import org.opends.guitools.controlpanel.ui.NoItemSelectedPanel;
import org.opends.guitools.controlpanel.ui.RootMonitoringPanel;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.SystemInformationMonitoringPanel;
import org.opends.guitools.controlpanel.ui.WorkQueueMonitoringPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class GeneralMonitoringRightPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -4197460101279681042L;
    protected JPanel mainPanel;
    private RootMonitoringPanel rootPanel = new RootMonitoringPanel();
    private WorkQueueMonitoringPanel workQueuePanel = new WorkQueueMonitoringPanel();
    private EntryCachesMonitoringPanel entryCachesPanel = new EntryCachesMonitoringPanel();
    private DBEnvironmentMonitoringPanel dbEnvironmentPanel = new DBEnvironmentMonitoringPanel();
    private SystemInformationMonitoringPanel systemInformationPanel = new SystemInformationMonitoringPanel();
    private JavaInformationMonitoringPanel javaInformationPanel = new JavaInformationMonitoringPanel();
    protected NoItemSelectedPanel noEntryPanel = new NoItemSelectedPanel();
    private final StatusGenericPanel[] panels = new StatusGenericPanel[]{this.rootPanel, this.workQueuePanel, this.entryCachesPanel, this.dbEnvironmentPanel, this.systemInformationPanel, this.javaInformationPanel};

    public GeneralMonitoringRightPanel() {
        this.createLayout();
    }

    public void displayMessage(Message msg) {
        this.noEntryPanel.setMessage(msg);
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.getTitle(this.noEntryPanel));
    }

    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        for (StatusGenericPanel panel : this.panels) {
            panel.setInfo(info);
        }
    }

    protected void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        CardLayout cardLayout = new CardLayout();
        this.mainPanel = new JPanel(cardLayout);
        this.mainPanel.setOpaque(false);
        this.noEntryPanel.setMessage(AdminToolMessages.INFO_CTRL_PANEL_GENERAL_MONITORING_NO_ITEM_SELECTED.get());
        JPanel[] panelsWithScroll = new JPanel[]{this.noEntryPanel, this.rootPanel, this.workQueuePanel, this.entryCachesPanel, this.systemInformationPanel, this.javaInformationPanel};
        JPanel[] panelsWithNoScroll = new JPanel[]{this.dbEnvironmentPanel};
        for (JPanel panel : panelsWithScroll) {
            this.mainPanel.add((Component)Utilities.createBorderLessScrollBar(panel), this.getTitle(panel));
        }
        for (JPanel panel : panelsWithNoScroll) {
            this.mainPanel.add((Component)panel, this.getTitle(panel));
        }
        cardLayout.show(this.mainPanel, this.getTitle(this.noEntryPanel));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.mainPanel, gbc);
    }

    public void okClicked() {
    }

    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.NO_BUTTON;
    }

    public Message getTitle() {
        return Message.EMPTY;
    }

    public Component getPreferredFocusComponent() {
        return null;
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    public void updateRoot() {
        this.rootPanel.updateContents();
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.getTitle(this.rootPanel));
    }

    public void updateSystemInformation() {
        this.systemInformationPanel.updateContents();
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.getTitle(this.systemInformationPanel));
    }

    public void updateWorkQueue() {
        this.workQueuePanel.updateContents();
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.getTitle(this.workQueuePanel));
    }

    public void updateEntryCaches() {
        this.entryCachesPanel.updateContents();
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.getTitle(this.entryCachesPanel));
    }

    public void updateDBEnvironment() {
        this.dbEnvironmentPanel.updateContents();
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.getTitle(this.dbEnvironmentPanel));
    }

    public void updateJavaInformation() {
        this.javaInformationPanel.updateContents();
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, this.getTitle(this.javaInformationPanel));
    }

    protected String getTitle(JPanel panel) {
        return panel.getClass().toString();
    }
}

