/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.OfflineUpdateException;
import org.opends.guitools.controlpanel.task.OnlineUpdateException;
import org.opends.guitools.controlpanel.task.SchemaTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.NewAttributePanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.BasicExpander;
import org.opends.guitools.controlpanel.ui.components.DoubleAddRemovePanel;
import org.opends.guitools.controlpanel.ui.renderer.SchemaElementComboBoxCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Attributes;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.Schema;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewObjectClassPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -4956885827963184571L;
    private JLabel lName = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_NAME_LABEL.get());
    private JLabel lParent = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_PARENT_LABEL.get());
    private JLabel lOID = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_OID_LABEL.get());
    private JLabel lAliases = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ALIASES_LABEL.get());
    private JLabel lOrigin = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ORIGIN_LABEL.get());
    private JLabel lFile = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_FILE_LABEL.get());
    private JTextField aliases = Utilities.createLongTextField();
    private JLabel lDescription = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_DESCRIPTION_LABEL.get());
    private JLabel lType = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_TYPE_LABEL.get());
    private JLabel lAttributes = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ATTRIBUTES_LABEL.get());
    private Set<AttributeType> inheritedOptionalAttributes = new HashSet<AttributeType>();
    private Set<AttributeType> inheritedRequiredAttributes = new HashSet<AttributeType>();
    private JLabel[] labels = new JLabel[]{this.lName, this.lParent, this.lOID, this.lAliases, this.lOrigin, this.lFile, this.lDescription, this.lType, this.lAttributes};
    private JTextField name = Utilities.createMediumTextField();
    private JComboBox parent = Utilities.createComboBox();
    private JComboBox type = Utilities.createComboBox();
    private JTextField oid = Utilities.createMediumTextField();
    private JTextField description = Utilities.createLongTextField();
    private JTextField origin = Utilities.createLongTextField();
    private JTextField file = Utilities.createLongTextField();
    private JCheckBox obsolete = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_OBSOLETE_LABEL.get());
    private DoubleAddRemovePanel<AttributeType> attributes;
    private Schema schema;
    private Component relativeComponent;

    public NewObjectClassPanel(Component relativeComponent) {
        this.relativeComponent = relativeComponent;
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_OBJECTCLASS_PANEL_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.name;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        Schema s = desc.getSchema();
        final boolean firstSchema = this.schema == null;
        final boolean[] repack = new boolean[]{firstSchema};
        final boolean[] error = new boolean[]{false};
        if (s != null) {
            this.schema = s;
            HashMap<String, ObjectClass> objectClassNameMap = new HashMap<String, ObjectClass>();
            for (String key : this.schema.getObjectClasses().keySet()) {
                ObjectClass oc = this.schema.getObjectClass(key);
                objectClassNameMap.put(oc.getNameOrOID(), oc);
            }
            TreeSet orderedKeys = new TreeSet();
            orderedKeys.addAll(objectClassNameMap.keySet());
            ArrayList newParents = new ArrayList();
            for (String key : orderedKeys) {
                newParents.add(objectClassNameMap.get(key));
            }
            this.updateComboBoxModel(newParents, (DefaultComboBoxModel)this.parent.getModel());
        } else {
            this.updateErrorPane(this.errorPane, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_SUMMARY.get(), ColorAndFontConstants.errorTitleFont, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get(), ColorAndFontConstants.defaultFont);
            repack[0] = true;
            error[0] = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewObjectClassPanel.this.setEnabledOK(!error[0]);
                NewObjectClassPanel.this.errorPane.setVisible(error[0]);
                if (NewObjectClassPanel.this.schema != null) {
                    if (firstSchema) {
                        NewObjectClassPanel.this.parent.setSelectedItem(NewObjectClassPanel.this.schema.getObjectClass("top"));
                    }
                    NewObjectClassPanel.this.updateAttributes();
                }
                if (repack[0]) {
                    NewObjectClassPanel.this.packParentDialog();
                    if (NewObjectClassPanel.this.relativeComponent != null) {
                        Utilities.centerGoldenMean(Utilities.getParentDialog(NewObjectClassPanel.this), NewObjectClassPanel.this.relativeComponent);
                    }
                }
            }
        });
        if (!error[0]) {
            this.updateErrorPaneAndOKButtonIfAuthRequired(desc, AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_TO_CREATE_OBJECTCLASS_SUMMARY.get());
        }
    }

    @Override
    public void okClicked() {
        String[] al;
        ArrayList<Message> errors = new ArrayList<Message>();
        for (JLabel label : this.labels) {
            this.setPrimaryValid(label);
        }
        String n = this.getObjectClassName();
        MessageBuilder err = new MessageBuilder();
        if (n.length() == 0) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_OBJECTCLASS_NAME_REQUIRED.get());
        } else if (!StaticUtils.isValidSchemaElement(n, 0, n.length(), err)) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_OBJECTCLASS_NAME.get(err.toString()));
            err = new MessageBuilder();
        } else {
            Message elementType = NewAttributePanel.getSchemaElementType(n, this.schema);
            if (elementType != null) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_OBJECTCLASS_NAME_ALREADY_IN_USE.get(n, elementType.toString()));
            }
        }
        n = this.oid.getText().trim();
        if (n.length() > 0) {
            if (!StaticUtils.isValidSchemaElement(n, 0, n.length(), err)) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_OID_NOT_VALID.get(err.toString()));
                err = new MessageBuilder();
            } else {
                Message elementType = NewAttributePanel.getSchemaElementType(n, this.schema);
                if (elementType != null) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_OID_ALREADY_IN_USE.get(n, elementType.toString()));
                }
            }
        }
        if (this.aliases.getText().trim().length() > 0 && (al = this.aliases.getText().split(",")).length > 0) {
            for (String alias : al) {
                if (alias.trim().length() == 0) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_EMPTY_ALIAS.get());
                    continue;
                }
                Message elementType = NewAttributePanel.getSchemaElementType(alias, this.schema);
                if (elementType == null) continue;
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_ALIAS_ALREADY_IN_USE.get(n, elementType.toString()));
            }
        }
        ProgressDialog dlg = new ProgressDialog((Component)Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_NEW_OBJECTCLASS_PANEL_TITLE.get(), this.getInfo());
        NewObjectClassTask newTask = null;
        if (errors.size() == 0) {
            newTask = new NewObjectClassTask(this.getInfo(), dlg);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
        }
        if (errors.size() == 0) {
            String ocName = this.getObjectClassName();
            this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_CREATING_OBJECTCLASS_SUMMARY.get(ocName), AdminToolMessages.INFO_CTRL_PANEL_CREATING_OBJECTCLASS_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_CREATING_OBJECTCLASS_SUCCESSFUL.get(ocName), AdminToolMessages.ERR_CTRL_PANEL_CREATING_OBJECTCLASS_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_CREATING_OBJECTCLASS_ERROR_DETAILS.get(ocName), null, dlg);
            dlg.setVisible(true);
            this.name.setText("");
            this.oid.setText("");
            this.description.setText("");
            this.aliases.setText("");
            this.name.grabFocus();
            Utilities.getParentDialog(this).setVisible(false);
        } else {
            this.displayErrorDialog(errors);
        }
    }

    private void updateAttributes() {
        int[][] selected = new int[][]{this.attributes.getAvailableList().getSelectedIndices(), this.attributes.getSelectedList1().getSelectedIndices(), this.attributes.getSelectedList2().getSelectedIndices()};
        JList[] lists = new JList[]{this.attributes.getAvailableList(), this.attributes.getSelectedList1(), this.attributes.getSelectedList2()};
        this.attributes.getAvailableListModel().clear();
        Collection<AttributeType> allAttrs = this.schema.getAttributeTypes().values();
        this.attributes.getAvailableListModel().addAll(allAttrs);
        HashSet<AttributeType> toDelete = new HashSet<AttributeType>();
        for (AttributeType attr : this.attributes.getSelectedListModel1().getData()) {
            if (!allAttrs.contains(attr)) {
                toDelete.add(attr);
                continue;
            }
            this.attributes.getAvailableListModel().remove(attr);
        }
        for (AttributeType attr : toDelete) {
            this.attributes.getSelectedListModel1().remove(attr);
        }
        toDelete = new HashSet();
        for (AttributeType attr : this.attributes.getSelectedListModel2().getData()) {
            if (!allAttrs.contains(attr)) {
                toDelete.add(attr);
                continue;
            }
            this.attributes.getAvailableListModel().remove(attr);
        }
        for (AttributeType attr : toDelete) {
            this.attributes.getSelectedListModel1().remove(attr);
        }
        int i = 0;
        for (int[] sel : selected) {
            if (sel != null) {
                ArrayList<Integer> indexes = new ArrayList<Integer>();
                for (int j = 0; j < sel.length; ++j) {
                    if (sel[j] >= lists[i].getModel().getSize()) continue;
                    indexes.add(sel[j]);
                }
                int[] newSelection = new int[indexes.size()];
                for (int j = 0; j < newSelection.length; ++j) {
                    newSelection[j] = (Integer)indexes.get(j);
                }
                lists[i].setSelectedIndices(newSelection);
            }
            ++i;
        }
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        Utilities.setRequiredIcon(this.lName);
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        JLabel requiredLabel = this.createRequiredLabel();
        gbc.insets.bottom = 10;
        this.add((Component)requiredLabel, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets.bottom = 0;
        SchemaElementComboBoxCellRenderer renderer = new SchemaElementComboBoxCellRenderer(this.parent);
        DefaultComboBoxModel<ObjectClassType> model = new DefaultComboBoxModel<ObjectClassType>();
        this.parent.setModel(model);
        this.parent.setRenderer(renderer);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                for (AttributeType attr : NewObjectClassPanel.this.inheritedRequiredAttributes) {
                    NewObjectClassPanel.this.attributes.getAvailableListModel().add(attr);
                    NewObjectClassPanel.this.attributes.getSelectedListModel1().remove(attr);
                }
                for (AttributeType attr : NewObjectClassPanel.this.inheritedOptionalAttributes) {
                    NewObjectClassPanel.this.attributes.getAvailableListModel().add(attr);
                    NewObjectClassPanel.this.attributes.getSelectedListModel2().remove(attr);
                }
                NewObjectClassPanel.this.inheritedOptionalAttributes.clear();
                NewObjectClassPanel.this.inheritedRequiredAttributes.clear();
                for (ObjectClass p = (ObjectClass)NewObjectClassPanel.this.parent.getSelectedItem(); p != null; p = p.getSuperiorClass()) {
                    for (AttributeType attr : p.getRequiredAttributeChain()) {
                        NewObjectClassPanel.this.inheritedRequiredAttributes.add(attr);
                    }
                    for (AttributeType attr : p.getOptionalAttributeChain()) {
                        NewObjectClassPanel.this.inheritedOptionalAttributes.add(attr);
                    }
                }
                for (AttributeType attr : NewObjectClassPanel.this.inheritedRequiredAttributes) {
                    NewObjectClassPanel.this.attributes.getAvailableListModel().remove(attr);
                    NewObjectClassPanel.this.attributes.getSelectedListModel1().add(attr);
                }
                for (AttributeType attr : NewObjectClassPanel.this.inheritedOptionalAttributes) {
                    NewObjectClassPanel.this.attributes.getAvailableListModel().remove(attr);
                    NewObjectClassPanel.this.attributes.getSelectedListModel2().add(attr);
                }
                NewObjectClassPanel.this.attributes.getAvailableListModel().fireContentsChanged(NewObjectClassPanel.this.attributes.getAvailableList(), 0, NewObjectClassPanel.this.attributes.getAvailableList().getModel().getSize() - 1);
                NewObjectClassPanel.this.attributes.getSelectedListModel1().fireContentsChanged(NewObjectClassPanel.this.attributes.getSelectedList1(), 0, NewObjectClassPanel.this.attributes.getSelectedList1().getModel().getSize() - 1);
                NewObjectClassPanel.this.attributes.getSelectedListModel2().fireContentsChanged(NewObjectClassPanel.this.attributes.getSelectedList2(), 0, NewObjectClassPanel.this.attributes.getSelectedList2().getModel().getSize() - 1);
                ArrayList unmovableItems = new ArrayList(NewObjectClassPanel.this.inheritedRequiredAttributes);
                unmovableItems.addAll(NewObjectClassPanel.this.inheritedOptionalAttributes);
                NewObjectClassPanel.this.attributes.setUnmovableItems(unmovableItems);
            }
        };
        this.parent.addItemListener(itemListener);
        model = new DefaultComboBoxModel();
        for (ObjectClassType t : ObjectClassType.values()) {
            model.addElement(t);
        }
        this.type.setModel(model);
        this.type.setSelectedItem((Object)ObjectClassType.STRUCTURAL);
        this.type.setRenderer(renderer);
        this.attributes = new DoubleAddRemovePanel<AttributeType>(0, AttributeType.class);
        Comparator<AttributeType> comparator = new Comparator<AttributeType>(){

            @Override
            public int compare(AttributeType attr1, AttributeType attr2) {
                return attr1.getNameOrOID().compareTo(attr2.getNameOrOID());
            }
        };
        this.attributes.getAvailableListModel().setComparator(comparator);
        this.attributes.getSelectedListModel1().setComparator(comparator);
        this.attributes.getSelectedListModel2().setComparator(comparator);
        Component[] basicComps = new Component[]{this.name, this.oid, this.description, this.parent};
        JLabel[] basicLabels = new JLabel[]{this.lName, this.lOID, this.lDescription, this.lParent};
        JLabel[] basicInlineHelp = new JLabel[]{null, null, null, null};
        this.add(basicLabels, basicComps, basicInlineHelp, this, gbc);
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        this.add((Component)this.lAttributes, gbc);
        ++gbc.gridx;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets.left = 10;
        this.add(this.attributes, gbc);
        this.attributes.getAvailableLabel().setText(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_AVAILABLE_ATTRIBUTES.get().toString());
        this.attributes.getSelectedLabel1().setText(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_REQUIRED_ATTRIBUTES.get().toString());
        this.attributes.getSelectedLabel2().setText(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_OPTIONAL_ATTRIBUTES.get().toString());
        AttributeTypeCellRenderer listRenderer = new AttributeTypeCellRenderer();
        this.attributes.getAvailableList().setCellRenderer(listRenderer);
        this.attributes.getSelectedList1().setCellRenderer(listRenderer);
        this.attributes.getSelectedList2().setCellRenderer(listRenderer);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.insets.top = 3;
        JLabel explanation = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_INHERITED_ATTRIBUTES_HELP.get());
        gbc.insets.top = 3;
        this.add((Component)explanation, gbc);
        final BasicExpander expander = new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_EXTRA_OPTIONS_EXPANDER.get());
        this.obsolete.setText("Obsolete");
        Component[] comps = new Component[]{this.aliases, this.origin, this.file, this.type, this.obsolete};
        JLabel[] labels = new JLabel[]{this.lAliases, this.lOrigin, this.lFile, this.lType, null};
        JLabel[] inlineHelps = new JLabel[]{Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SEPARATED_WITH_COMMAS_HELP.get()), null, Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SCHEMA_FILE_OBJECTCLASS_HELP.get(File.separator)), null, null};
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.insets.left = 0;
        ++gbc.gridy;
        this.add((Component)expander, gbc);
        final JPanel p = new JPanel(new GridBagLayout());
        gbc.insets.left = 15;
        ++gbc.gridy;
        this.add((Component)p, gbc);
        ++gbc.gridy;
        p.setOpaque(false);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.fill = 2;
        gbc1.gridy = 0;
        this.add(labels, comps, inlineHelps, p, gbc1);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                p.setVisible(expander.isSelected());
                NewObjectClassPanel.this.packParentDialog();
            }
        };
        expander.addChangeListener(changeListener);
        expander.setSelected(false);
        changeListener.stateChanged(null);
        this.file.setText("99-user.ldif");
    }

    private String getObjectClassName() {
        return this.name.getText().trim();
    }

    private String getOID() {
        String o = this.oid.getText().trim();
        if (o.length() == 0) {
            o = this.getObjectClassName() + "-oid";
        }
        return o;
    }

    private ObjectClass getSuperior() {
        return (ObjectClass)this.parent.getSelectedItem();
    }

    private Map<String, List<String>> getExtraProperties() {
        String or;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String f = this.file.getText().trim();
        if (f.length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(f);
            map.put("X-SCHEMA-FILE", list);
        }
        if ((or = this.origin.getText().trim()).length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(or);
            map.put("X-ORIGIN", list);
        }
        return map;
    }

    private ArrayList<String> getAliases() {
        ArrayList<String> al = new ArrayList<String>();
        String s = this.aliases.getText().trim();
        if (s.length() > 0) {
            String[] a;
            for (String alias : a = s.split(",")) {
                al.add(alias.trim());
            }
        }
        return al;
    }

    private ArrayList<String> getAllNames() {
        ArrayList<String> al = new ArrayList<String>();
        al.add(this.getObjectClassName());
        al.addAll(this.getAliases());
        return al;
    }

    private ObjectClass getObjectClass() {
        ObjectClass oc = new ObjectClass("", this.getObjectClassName(), this.getAllNames(), this.getOID(), this.description.getText().trim(), this.getSuperior(), this.getRequiredAttributes(), this.getAllowedAttributes(), this.getObjectClassType(), this.obsolete.isSelected(), this.getExtraProperties());
        return oc;
    }

    private ObjectClassType getObjectClassType() {
        return (ObjectClassType)((Object)this.type.getSelectedItem());
    }

    private Set<AttributeType> getRequiredAttributes() {
        HashSet<AttributeType> attrs = new HashSet<AttributeType>();
        attrs.addAll(this.attributes.getSelectedListModel1().getData());
        return attrs;
    }

    private Set<AttributeType> getAllowedAttributes() {
        HashSet<AttributeType> attrs = new HashSet<AttributeType>();
        attrs.addAll(this.attributes.getSelectedListModel2().getData());
        return attrs;
    }

    private class AttributeTypeCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer defaultRenderer;

        public AttributeTypeCellRenderer() {
            this.defaultRenderer = NewObjectClassPanel.this.attributes.getAvailableList().getCellRenderer();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof AttributeType) {
                AttributeType attr = (AttributeType)value;
                value = NewObjectClassPanel.this.inheritedOptionalAttributes.contains(value) || NewObjectClassPanel.this.inheritedRequiredAttributes.contains(value) ? attr.getNameOrOID() + " (*)" : attr.getNameOrOID();
            }
            return this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    protected class NewObjectClassTask
    extends SchemaTask {
        private ObjectClass oc;
        private String ocName;
        private String ocDefinition;
        private String ocWithoutFileDefinition;

        public NewObjectClassTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(info, dlg);
            this.ocName = NewObjectClassPanel.this.getObjectClassName();
            this.ocDefinition = this.getSchemaElement().toString();
            ObjectClass oc = NewObjectClassPanel.this.getObjectClass();
            oc.setExtraProperty("X-SCHEMA-FILE", (String)null);
            this.ocWithoutFileDefinition = oc.toString();
        }

        public Task.Type getType() {
            return Task.Type.NEW_OBJECTCLASS;
        }

        protected CommonSchemaElements getSchemaElement() {
            if (this.oc == null) {
                this.oc = NewObjectClassPanel.this.getObjectClass();
            }
            return this.oc;
        }

        public Message getTaskDescription() {
            return AdminToolMessages.INFO_CTRL_PANEL_NEW_OBJECTCLASS_TASK_DESCRIPTION.get(this.ocName);
        }

        protected String getSchemaFileAttributeName() {
            return "objectClasses";
        }

        protected String getSchemaFileAttributeValue() {
            if (this.isServerRunning()) {
                return this.ocDefinition;
            }
            return this.ocWithoutFileDefinition;
        }

        protected void updateSchema() throws OpenDsException {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewObjectClassTask.this.printEquivalentCommandToAdd();
                    NewObjectClassTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_CREATING_OBJECTCLASS_PROGRESS.get(NewObjectClassTask.this.ocName), ColorAndFontConstants.progressFont));
                }
            });
            if (this.isServerRunning()) {
                try {
                    BasicAttribute attr = new BasicAttribute(this.getSchemaFileAttributeName());
                    attr.add(this.getSchemaFileAttributeValue());
                    ModificationItem mod = new ModificationItem(1, attr);
                    this.getInfo().getDirContext().modifyAttributes("cn=schema", new ModificationItem[]{mod});
                }
                catch (NamingException ne) {
                    throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_SCHEMA.get(ne.toString()), (Throwable)ne);
                }
            } else {
                this.updateSchemaFile();
            }
            NewObjectClassPanel.this.notifyConfigurationElementCreated(this.oc);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewObjectClassTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSchemaFile() throws OpenDsException {
            if (this.isSchemaFileDefined) {
                LDIFExportConfig exportConfig = new LDIFExportConfig(this.schemaFile, ExistingFileBehavior.OVERWRITE);
                LDIFReader reader = null;
                Entry schemaEntry = null;
                try {
                    reader = new LDIFReader(new LDIFImportConfig(this.schemaFile));
                    schemaEntry = reader.readEntry();
                    Modification mod = new Modification(ModificationType.ADD, Attributes.create(this.getSchemaFileAttributeName().toLowerCase(), this.getSchemaFileAttributeValue()));
                    schemaEntry.applyModification(mod);
                    LDIFWriter writer = new LDIFWriter(exportConfig);
                    writer.writeEntry(schemaEntry);
                    exportConfig.getWriter().newLine();
                }
                catch (Throwable t) {
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable t) {}
                    }
                    if (exportConfig != null) {
                        try {
                            exportConfig.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            } else {
                LDIFExportConfig exportConfig = new LDIFExportConfig(this.schemaFile, ExistingFileBehavior.FAIL);
                try {
                    ArrayList<String> lines = this.getSchemaEntryLines();
                    for (String line : lines) {
                        LDIFWriter.writeLDIFLine(new StringBuilder(line), exportConfig.getWriter(), exportConfig.getWrapColumn() > 1, exportConfig.getWrapColumn());
                    }
                    exportConfig.getWriter().newLine();
                }
                catch (Throwable t) {
                    throw new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_SCHEMA.get(t.toString()), t);
                }
                finally {
                    if (exportConfig != null) {
                        try {
                            exportConfig.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
        }
    }
}

