/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.ui.AbstractNewEntryPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.OpenDsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewUserPanel
extends AbstractNewEntryPanel {
    private static final long serialVersionUID = -2450090053404111892L;
    private JLabel lFirstName = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_FIRST_NAME_LABEL.get());
    private JLabel lLastName = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_LAST_NAME_LABEL.get());
    private JLabel lCommonNames = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_COMMON_NAMES_LABEL.get());
    private JLabel lUserID = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_UID_LABEL.get());
    private JLabel lPassword = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_PASSWORD_LABEL.get());
    private JLabel lConfirmPassword = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_CONFIRM_PASSWORD_LABEL.get());
    private JLabel lEmail = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_EMAIL_LABEL.get());
    private JLabel lTelephoneNumber = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_TELEPHONE_NUMBER_LABEL.get());
    private JLabel lFaxNumber = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_FAX_NUMBER_LABEL.get());
    private JLabel lNamingAttribute = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_NAMING_ATTRIBUTE_LABEL.get());
    private JLabel lEntryDN = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_ENTRY_DN_LABEL.get());
    private JLabel[] labels = new JLabel[]{this.lFirstName, this.lLastName, this.lCommonNames, this.lUserID, this.lPassword, this.lConfirmPassword, this.lEmail, this.lTelephoneNumber, this.lFaxNumber, this.lNamingAttribute, this.lEntryDN};
    private JTextField firstName = Utilities.createLongTextField();
    private JTextField lastName = Utilities.createLongTextField();
    private JTextField commonName = Utilities.createLongTextField();
    private JTextField userID = Utilities.createLongTextField();
    private JPasswordField password = Utilities.createPasswordField();
    private JPasswordField confirmPassword = Utilities.createPasswordField(30);
    private JTextField eMail = Utilities.createLongTextField();
    private JTextField telephoneNumber = Utilities.createLongTextField();
    private JTextField faxNumber = Utilities.createLongTextField();
    private JComboBox namingAttribute = Utilities.createComboBox();
    private JLabel dn = Utilities.createDefaultLabel();
    Component[] comps = new Component[]{this.firstName, this.lastName, this.commonName, this.userID, this.password, this.confirmPassword, this.eMail, this.telephoneNumber, this.faxNumber, this.namingAttribute, this.dn};
    private final JTextField[] NAMING_ATTRIBUTE_TEXTFIELDS = new JTextField[]{this.commonName, this.firstName, this.lastName, this.userID};
    private final String[] NAMING_ATTRIBUTES = new String[]{"cn", "givenName", "sn", "uid"};

    public NewUserPanel() {
        this.createLayout();
    }

    @Override
    public void setParent(BasicNode parentNode, BrowserController controller) {
        super.setParent(parentNode, controller);
        this.dn.setText(this.namingAttribute.getSelectedItem() + "=," + parentNode.getDN());
        for (Component comp : this.comps) {
            if (!(comp instanceof JTextField)) continue;
            ((JTextField)comp).setText("");
        }
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_PANEL_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.firstName;
    }

    @Override
    protected Message getProgressDialogTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_USER_PANEL_TITLE.get();
    }

    @Override
    protected void checkSyntax(ArrayList<Message> errors) {
        char[] pwd2;
        String sPwd2;
        char[] pwd1;
        String sPwd1;
        for (JLabel label : this.labels) {
            this.setPrimaryValid(label);
        }
        JTextField[] requiredFields = new JTextField[]{this.lastName, this.commonName};
        Message[] msgs = new Message[]{AdminToolMessages.ERR_CTRL_PANEL_USER_LAST_NAME_REQUIRED.get(), AdminToolMessages.ERR_CTRL_PANEL_USER_COMMON_NAME_REQUIRED.get()};
        for (int i = 0; i < requiredFields.length; ++i) {
            String v = requiredFields[i].getText().trim();
            if (v.length() != 0) continue;
            errors.add(msgs[i]);
        }
        String attr = (String)this.namingAttribute.getSelectedItem();
        for (int i = 0; i < this.NAMING_ATTRIBUTE_TEXTFIELDS.length; ++i) {
            boolean isRequired = false;
            for (JTextField tf : requiredFields) {
                if (tf != this.NAMING_ATTRIBUTE_TEXTFIELDS[i]) continue;
                isRequired = true;
                break;
            }
            if (isRequired || !attr.equalsIgnoreCase(this.NAMING_ATTRIBUTES[i])) continue;
            String value = this.NAMING_ATTRIBUTE_TEXTFIELDS[i].getText().trim();
            if (value.length() != 0) break;
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_USER_NAMING_ATTRIBUTE_REQUIRED.get(attr));
            break;
        }
        if (!(sPwd1 = new String(pwd1 = this.password.getPassword())).equals(sPwd2 = new String(pwd2 = this.confirmPassword.getPassword()))) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_PASSWORD_DO_NOT_MATCH.get());
        }
        if (errors.size() == 0) {
            try {
                this.getEntry();
            }
            catch (OpenDsException ode) {
                errors.add(ode.getMessageObject());
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Unexpected error: " + ioe, ioe);
            }
        }
    }

    private void createLayout() {
        JTextField[] toAddListener;
        GridBagConstraints gbc = new GridBagConstraints();
        Utilities.setRequiredIcon(this.lLastName);
        Utilities.setRequiredIcon(this.lCommonNames);
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        JLabel requiredLabel = this.createRequiredLabel();
        gbc.insets.bottom = 10;
        this.add((Component)requiredLabel, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets.bottom = 0;
        Component[] inlineHelp = new Component[]{null, null, null, null, null, null, null, null, null, null, null};
        for (int i = 0; i < this.labels.length; ++i) {
            gbc.insets.left = 0;
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            this.add((Component)this.labels[i], gbc);
            gbc.insets.left = 10;
            gbc.gridx = 1;
            if (this.comps[i] instanceof JComboBox) {
                gbc.weightx = 0.0;
                gbc.fill = 0;
            } else {
                gbc.weightx = 1.0;
                gbc.fill = 2;
            }
            this.add(this.comps[i], gbc);
            if (inlineHelp[i] != null) {
                gbc.insets.top = 3;
                ++gbc.gridy;
                this.add(inlineHelp[i], gbc);
            }
            gbc.insets.top = 10;
            ++gbc.gridy;
        }
        this.addBottomGlue(gbc);
        DocumentListener listener = new DocumentListener(){

            public void insertUpdate(DocumentEvent ev) {
                NewUserPanel.this.updateDNValue();
            }

            public void changedUpdate(DocumentEvent ev) {
                this.insertUpdate(ev);
            }

            public void removeUpdate(DocumentEvent ev) {
                this.insertUpdate(ev);
            }
        };
        for (JTextField tf : toAddListener = new JTextField[]{this.firstName, this.lastName, this.commonName, this.userID}) {
            tf.getDocument().addDocumentListener(listener);
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(this.NAMING_ATTRIBUTES);
        this.namingAttribute.setModel(model);
        this.namingAttribute.setSelectedItem(this.NAMING_ATTRIBUTES[0]);
        this.namingAttribute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                NewUserPanel.this.updateDNValue();
            }
        });
    }

    private void updateDNValue() {
        String attr = (String)this.namingAttribute.getSelectedItem();
        for (int i = 0; i < this.NAMING_ATTRIBUTE_TEXTFIELDS.length; ++i) {
            if (!attr.equalsIgnoreCase(this.NAMING_ATTRIBUTES[i])) continue;
            String value = this.NAMING_ATTRIBUTE_TEXTFIELDS[i].getText().trim();
            String rdn = Utilities.getRDNString(attr, value);
            this.dn.setText(rdn + "," + this.parentNode.getDN());
            break;
        }
    }

    @Override
    protected String getLDIF() {
        StringBuilder sb = new StringBuilder();
        sb.append("dn: " + this.dn.getText() + "\n");
        String[] attrNames = new String[]{"givenName", "sn", "cn", "uid", "userPassword", "mail", "telephoneNumber", "facsimileTelephoneNumber"};
        JTextField[] textFields = new JTextField[]{this.firstName, this.lastName, this.commonName, this.userID, this.password, this.eMail, this.telephoneNumber, this.faxNumber};
        sb.append("objectclass: top\n");
        sb.append("objectclass: person\n");
        sb.append("objectclass: inetOrgPerson\n");
        for (int i = 0; i < attrNames.length; ++i) {
            String value = textFields[i].getText().trim();
            if (value.length() <= 0) continue;
            sb.append(attrNames[i] + ": " + value + "\n");
        }
        return sb.toString();
    }
}

