/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVSortOrder;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.OfflineUpdateException;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.AbstractVLVIndexPanel;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.LocalDBBackendCfgClient;
import org.opends.server.admin.std.client.LocalDBVLVIndexCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.LocalDBVLVIndexCfgDefn;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.cli.CommandBuilder;

public class NewVLVIndexPanel
extends AbstractVLVIndexPanel {
    private static final long serialVersionUID = 1554866540747530939L;

    public NewVLVIndexPanel(String backendName, Component relativeComponent) {
        super(backendName, relativeComponent);
        this.createBasicLayout(this, new GridBagConstraints(), false);
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_VLV_INDEX_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.name;
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        if (this.updateLayout(ev.getNewDescriptor())) {
            this.updateErrorPaneAndOKButtonIfAuthRequired(ev.getNewDescriptor(), AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_NEW_VLV.get());
        }
    }

    public void update(BackendDescriptor backend) {
        this.updateBaseDNCombo(backend);
        this.backendName.setText(backend.getBackendID());
    }

    public void okClicked() {
        List<Message> errors = this.checkErrors(true);
        if (errors.isEmpty()) {
            ProgressDialog dlg = new ProgressDialog((Component)Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_NEW_VLV_INDEX_TITLE.get(), this.getInfo());
            NewVLVIndexTask newTask = new NewVLVIndexTask(this.getInfo(), dlg);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            if (errors.isEmpty() && this.checkIndexRequired()) {
                String indexName = this.name.getText().trim();
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_CREATING_NEW_VLV_INDEX_SUMMARY.get(indexName), AdminToolMessages.INFO_CTRL_PANEL_CREATING_NEW_VLV_INDEX_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CREATING_NEW_VLV_INDEX_SUCCESSFUL_DETAILS.get(indexName), AdminToolMessages.ERR_CTRL_PANEL_CREATING_NEW_VLV_INDEX_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_CREATING_NEW_VLV_INDEX_ERROR_DETAILS.get(), null, dlg);
                dlg.setVisible(true);
                Utilities.getParentDialog(this).setVisible(false);
            }
        }
        if (!errors.isEmpty()) {
            this.displayErrorDialog(errors);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NewVLVIndexTask
    extends Task {
        private Set<String> backendSet;
        private String indexName;
        private LocalDBVLVIndexCfgDefn.Scope scope;
        private List<VLVSortOrder> sortOrder;
        private String baseDN;
        private String filterValue;
        private String backendID;
        private String ldif;
        private String sortOrderStringValue;
        private int maxBlock;
        private VLVIndexDescriptor newIndex;

        public NewVLVIndexTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(info, dlg);
            this.backendSet = new HashSet<String>();
            this.backendSet.add(NewVLVIndexPanel.this.backendName.getText());
            this.indexName = NewVLVIndexPanel.this.name.getText().trim();
            this.sortOrder = NewVLVIndexPanel.this.getSortOrder();
            this.baseDN = NewVLVIndexPanel.this.getBaseDN();
            this.filterValue = NewVLVIndexPanel.this.filter.getText().trim();
            this.scope = NewVLVIndexPanel.this.getScope();
            this.backendID = NewVLVIndexPanel.this.backendName.getText();
            this.ldif = NewVLVIndexPanel.this.getIndexLDIF(this.indexName);
            this.sortOrderStringValue = NewVLVIndexPanel.this.getSortOrderStringValue(this.sortOrder);
            this.maxBlock = Integer.parseInt(NewVLVIndexPanel.this.maxBlockSize.getText());
        }

        @Override
        public Task.Type getType() {
            return Task.Type.NEW_INDEX;
        }

        @Override
        public Set<String> getBackends() {
            return this.backendSet;
        }

        @Override
        public Message getTaskDescription() {
            return AdminToolMessages.INFO_CTRL_PANEL_NEW_VLV_INDEX_TASK_DESCRIPTION.get(this.indexName, this.backendID);
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (this.state == Task.State.RUNNING) {
                TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
                backends.retainAll(this.getBackends());
                if (backends.size() > 0) {
                    incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                    canLaunch = false;
                }
            }
            return canLaunch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConfiguration() throws OpenDsException {
            boolean configHandlerUpdated = false;
            try {
                if (!this.isServerRunning()) {
                    configHandlerUpdated = true;
                    this.getInfo().stopPooling();
                    if (this.getInfo().mustDeregisterConfig()) {
                        DirectoryServer.deregisterBaseDN(DN.decode("cn=config"));
                    }
                    DirectoryServer.getInstance().initializeConfiguration(ConfigFileHandler.class.getName(), ConfigReader.configFile);
                    this.getInfo().setMustDeregisterConfig(true);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StringBuilder sb = new StringBuilder();
                            sb.append(NewVLVIndexTask.this.getConfigCommandLineName());
                            List args = NewVLVIndexTask.this.getObfuscatedCommandLineArguments(NewVLVIndexTask.this.getDSConfigCommandLineArguments());
                            args.removeAll(NewVLVIndexTask.this.getConfigCommandLineArguments());
                            for (String arg : args) {
                                sb.append(" " + CommandBuilder.escapeValue(arg));
                            }
                            NewVLVIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_CREATE_VLV_INDEX.get() + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NewVLVIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_CREATING_NEW_VLV_INDEX_PROGRESS.get(NewVLVIndexTask.this.indexName), ColorAndFontConstants.progressFont));
                    }
                });
                if (this.isServerRunning()) {
                    this.createIndex(this.getInfo().getDirContext());
                } else {
                    this.createIndex();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NewVLVIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    }
                });
            }
            finally {
                if (configHandlerUpdated) {
                    DirectoryServer.getInstance().initializeConfiguration(ConfigReader.configClassName, ConfigReader.configFile);
                    this.getInfo().startPooling();
                }
            }
        }

        private void createIndex() throws OpenDsException {
            LDIFImportConfig ldifImportConfig = null;
            try {
                Entry backendConfigEntry;
                String topEntryDN = "cn=VLV Index," + Utilities.getRDNString("ds-cfg-backend-id", NewVLVIndexPanel.this.backendName.getText()) + ",cn=Backends,cn=config";
                boolean topEntryExists = DirectoryServer.getConfigHandler().entryExists(DN.decode(topEntryDN));
                if (!topEntryExists) {
                    String completeLDIF = Utilities.makeLdif("dn: " + topEntryDN, "objectClass: top", "objectClass: ds-cfg-branch", "cn: VLV Index", "") + this.ldif;
                    ldifImportConfig = new LDIFImportConfig(new StringReader(completeLDIF));
                } else {
                    ldifImportConfig = new LDIFImportConfig(new StringReader(this.ldif));
                }
                LDIFReader reader = new LDIFReader(ldifImportConfig);
                while ((backendConfigEntry = reader.readEntry()) != null) {
                    DirectoryServer.getConfigHandler().addEntry(backendConfigEntry, null);
                }
                DirectoryServer.getConfigHandler().writeUpdatedConfig();
            }
            catch (IOException ioe) {
                throw new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_CONFIGURATION.get(ioe.toString()), (Throwable)ioe);
            }
            finally {
                if (ldifImportConfig != null) {
                    ldifImportConfig.close();
                }
            }
        }

        private void createIndex(InitialLdapContext ctx) throws OpenDsException {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            LocalDBBackendCfgClient backend = (LocalDBBackendCfgClient)root.getBackend(NewVLVIndexPanel.this.backendName.getText());
            LocalDBVLVIndexCfgDefn provider = LocalDBVLVIndexCfgDefn.getInstance();
            LocalDBVLVIndexCfgClient index = backend.createLocalDBVLVIndex(provider, NewVLVIndexPanel.this.name.getText(), null);
            index.setFilter(NewVLVIndexPanel.this.filter.getText().trim());
            index.setSortOrder(NewVLVIndexPanel.this.getSortOrderStringValue(NewVLVIndexPanel.this.getSortOrder()));
            index.setBaseDN(DN.decode(NewVLVIndexPanel.this.getBaseDN()));
            index.setScope(NewVLVIndexPanel.this.getScope());
            index.setMaxBlockSize(Integer.parseInt(NewVLVIndexPanel.this.maxBlockSize.getText().trim()));
            index.commit();
        }

        @Override
        protected String getCommandLinePath() {
            return null;
        }

        protected ArrayList<String> getCommandLineArguments() {
            return new ArrayList<String>();
        }

        private String getConfigCommandLineName() {
            if (this.isServerRunning()) {
                return this.getCommandLinePath("dsconfig");
            }
            return null;
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                this.updateConfiguration();
                for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                    if (!backend.getBackendID().equalsIgnoreCase(this.backendID)) continue;
                    this.newIndex = new VLVIndexDescriptor(this.indexName, backend, DN.decode(this.baseDN), this.scope, this.filterValue, this.sortOrder, this.maxBlock);
                    this.getInfo().registerModifiedIndex(this.newIndex);
                    NewVLVIndexPanel.this.notifyConfigurationElementCreated(this.newIndex);
                    break;
                }
                this.state = Task.State.FINISHED_SUCCESSFULLY;
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
        }

        @Override
        public void postOperation() {
            if (this.lastException == null && this.state == Task.State.FINISHED_SUCCESSFULLY && this.newIndex != null) {
                NewVLVIndexPanel.this.rebuildIndexIfNecessary(this.newIndex, this.getProgressDialog());
            }
        }

        private ArrayList<String> getDSConfigCommandLineArguments() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("create-local-db-vlv-index");
            args.add("--backend-name");
            args.add(this.backendID);
            args.add("--type");
            args.add("generic");
            args.add("--index-name");
            args.add(this.indexName);
            args.add("--set");
            args.add("base-dn:" + this.baseDN);
            args.add("--set");
            args.add("filter:" + this.filterValue);
            args.add("--set");
            args.add("scope:" + this.scope.toString());
            args.add("--set");
            args.add("sort-order:" + this.sortOrderStringValue);
            args.addAll(this.getConnectionCommandLineArguments());
            args.add(this.getNoPropertiesFileArgument());
            args.add("--no-prompt");
            return args;
        }
    }
}

