/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.CategorizedComboBoxElement;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.datamodel.SortableListModel;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.IndexModifiedEvent;
import org.opends.guitools.controlpanel.event.IndexModifiedListener;
import org.opends.guitools.controlpanel.task.IndexTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.AddRemovePanel;
import org.opends.guitools.controlpanel.ui.renderer.CustomListCellRenderer;
import org.opends.guitools.controlpanel.ui.renderer.IndexCellRenderer;
import org.opends.guitools.controlpanel.ui.renderer.IndexComboBoxCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.guitools.controlpanel.util.ViewPositions;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class VerifyIndexPanel
extends StatusGenericPanel
implements IndexModifiedListener {
    private static final long serialVersionUID = 5252070109221657041L;
    private JComboBox baseDNs;
    private JRadioButton verifyIndexContents;
    private JRadioButton verifyKeyEntryIDs;
    private AddRemovePanel<AbstractIndexDescriptor> addRemove;
    private JComboBox keyEntryIDs;
    private HashMap<String, SortedSet<AbstractIndexDescriptor>> hmIndexes = new HashMap();
    private JLabel lBaseDN;
    private JLabel lAction;
    private JLabel lIndex;
    private JLabel lNoBaseDNsFound;
    private final String DATABASE_INDEXES = AdminToolMessages.INFO_CTRL_PANEL_DATABASE_INDEXES.get().toString();
    private final String ATTRIBUTE_INDEXES = AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_INDEXES.get().toString();
    private final String VLV_INDEXES = AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEXES.get().toString();

    public VerifyIndexPanel() {
        this.createLayout();
    }

    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        IndexCellRenderer indexCellRenderer = new IndexCellRenderer(this.addRemove.getAvailableList(), info);
        this.addRemove.getAvailableList().setCellRenderer(indexCellRenderer);
        this.addRemove.getSelectedList().setCellRenderer(indexCellRenderer);
        info.addIndexModifiedListener(this);
    }

    public void indexModified(IndexModifiedEvent ev) {
        this.refreshContents(this.getInfo().getServerDescriptor());
    }

    public void backendIndexesModified(IndexModifiedEvent ev) {
        this.refreshContents(this.getInfo().getServerDescriptor());
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.lBaseDN = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BASE_DN_LABEL.get());
        this.add((Component)this.lBaseDN, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.baseDNs = Utilities.createComboBox();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.baseDNs.setModel(model);
        this.baseDNs.setRenderer(new CustomListCellRenderer(this.baseDNs));
        ItemListener listener = new StatusGenericPanel.IgnoreItemListener(this.baseDNs);
        this.baseDNs.addItemListener(listener);
        this.baseDNs.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                VerifyIndexPanel.this.comboBoxSelected(VerifyIndexPanel.this.hmIndexes, (CategorizedComboBoxElement)VerifyIndexPanel.this.baseDNs.getSelectedItem(), VerifyIndexPanel.this.addRemove);
                VerifyIndexPanel.this.updateVerifyKeyEntriesComboBox();
            }
        });
        listener.itemStateChanged(null);
        gbc.gridwidth = 2;
        this.add((Component)this.baseDNs, gbc);
        this.lNoBaseDNsFound = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_BASE_DNS_FOUND_LABEL.get());
        this.add((Component)this.lNoBaseDNsFound, gbc);
        this.lNoBaseDNsFound.setVisible(false);
        this.lAction = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ACTION_LABEL.get());
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        this.add((Component)this.lAction, gbc);
        this.verifyIndexContents = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_VERIFY_ENTRY_CONTEXT_ARE_INDEXES.get());
        this.verifyIndexContents.setSelected(true);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.add((Component)this.verifyIndexContents, gbc);
        this.addRemove = new AddRemovePanel<AbstractIndexDescriptor>(AbstractIndexDescriptor.class);
        this.addRemove.getAvailableLabel().setText(AdminToolMessages.INFO_CTRL_PANEL_AVAILABLE_INDEXES_LABEL.get().toString());
        this.addRemove.getSelectedLabel().setText(AdminToolMessages.INFO_CTRL_PANEL_SELECTED_INDEXES_LABEL.get().toString());
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.insets.top = 5;
        gbc.insets.left = 30;
        gbc.fill = 1;
        this.add(this.addRemove, gbc);
        ++gbc.gridy;
        JLabel explanation = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_REQUIRES_REBUILD_LEGEND.get());
        gbc.insets.top = 3;
        this.add((Component)explanation, gbc);
        this.verifyKeyEntryIDs = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_VERIFY_ALL_KEYS.get());
        this.verifyKeyEntryIDs.setSelected(true);
        gbc.insets.left = 10;
        gbc.insets.top = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.add((Component)this.verifyKeyEntryIDs, gbc);
        ++gbc.gridy;
        gbc.insets.left = 30;
        gbc.insets.top = 5;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        this.lIndex = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_INDEX_LABEL.get());
        this.add((Component)this.lIndex, gbc);
        this.keyEntryIDs = Utilities.createComboBox();
        model = new DefaultComboBoxModel();
        this.keyEntryIDs.setModel(model);
        this.keyEntryIDs.setRenderer(new IndexComboBoxCellRenderer(this.keyEntryIDs));
        listener = new StatusGenericPanel.IgnoreItemListener(this.keyEntryIDs);
        this.keyEntryIDs.addItemListener(listener);
        listener.itemStateChanged(null);
        gbc.gridx = 2;
        gbc.insets.left = 5;
        this.add((Component)this.keyEntryIDs, gbc);
        this.addBottomGlue(gbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.verifyIndexContents);
        group.add(this.verifyKeyEntryIDs);
        this.verifyIndexContents.setSelected(true);
        listener = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                VerifyIndexPanel.this.addRemove.setEnabled(VerifyIndexPanel.this.verifyIndexContents.isSelected());
                VerifyIndexPanel.this.keyEntryIDs.setEnabled(!VerifyIndexPanel.this.verifyIndexContents.isSelected());
                VerifyIndexPanel.this.lIndex.setEnabled(!VerifyIndexPanel.this.verifyIndexContents.isSelected());
            }
        };
        this.verifyIndexContents.addItemListener(listener);
        listener.itemStateChanged(null);
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_VERIFY_INDEXES_PANEL_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.baseDNs;
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        this.refreshContents(ev.getNewDescriptor());
    }

    private void refreshContents(ServerDescriptor desc) {
        this.updateIndexMap(desc, this.hmIndexes);
        this.updateBaseDNComboBoxModel((DefaultComboBoxModel)this.baseDNs.getModel(), desc);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JScrollPane scroll = Utilities.getContainingScroll(VerifyIndexPanel.this);
                ViewPositions pos = scroll != null ? Utilities.getViewPositions(scroll) : Utilities.getViewPositions(VerifyIndexPanel.this);
                VerifyIndexPanel.this.comboBoxSelected(VerifyIndexPanel.this.hmIndexes, (CategorizedComboBoxElement)VerifyIndexPanel.this.baseDNs.getSelectedItem(), VerifyIndexPanel.this.addRemove);
                VerifyIndexPanel.this.updateVerifyKeyEntriesComboBox();
                VerifyIndexPanel.this.addRemove.getAvailableList().repaint();
                VerifyIndexPanel.this.addRemove.getSelectedList().repaint();
                boolean comboVisible = VerifyIndexPanel.this.baseDNs.getModel().getSize() > 0;
                VerifyIndexPanel.this.baseDNs.setVisible(comboVisible);
                VerifyIndexPanel.this.lNoBaseDNsFound.setVisible(!comboVisible);
                Utilities.updateViewPositions(pos);
            }
        });
    }

    public void cancelClicked() {
        this.setPrimaryValid(this.lBaseDN);
        this.setSecondaryValid(this.addRemove.getSelectedLabel());
        this.setSecondaryValid(this.lIndex);
        super.cancelClicked();
    }

    public void okClicked() {
        this.setPrimaryValid(this.lBaseDN);
        this.setSecondaryValid(this.addRemove.getSelectedLabel());
        this.setSecondaryValid(this.lIndex);
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        String baseDN = this.getSelectedBaseDN();
        if (baseDN == null) {
            this.setPrimaryInvalid(this.lBaseDN);
            if (this.baseDNs.getItemCount() == 0) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_BASE_DNS_DEFINED_LABEL.get());
            } else {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_MUST_SELECT_BASE_DN.get());
            }
        }
        if (this.verifyIndexContents.isSelected()) {
            SortableListModel<AbstractIndexDescriptor> model = this.addRemove.getSelectedListModel();
            if (model.getSize() == 0) {
                this.setSecondaryInvalid(this.addRemove.getSelectedLabel());
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INDEX_TO_BE_VERIFIED_REQUIRED.get());
            }
        } else {
            AbstractIndexDescriptor index = this.getSelectedIndex();
            if (index == null) {
                this.setPrimaryInvalid(this.lIndex);
                if (this.keyEntryIDs.getItemCount() == 0 && baseDN != null) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_INDEXES_FOR_BASEDN.get(baseDN));
                } else {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_INDEX_MUST_BE_SELECTED.get());
                }
            }
        }
        if (errors.isEmpty()) {
            ProgressDialog progressDialog = new ProgressDialog((Component)Utilities.getParentDialog(this), this.getTitle(), this.getInfo());
            VerifyIndexTask newTask = new VerifyIndexTask(this.getInfo(), progressDialog);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            if (errors.isEmpty()) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_VERIFYING_INDEXES_SUMMARY.get(baseDN), AdminToolMessages.INFO_CTRL_PANEL_VERIFYING_INDEXES_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_VERIFYING_INDEXES_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_VERIFYING_INDEXES_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_VERIFYING_INDEXES_ERROR_DETAILS, progressDialog);
                progressDialog.setVisible(true);
                Utilities.getParentDialog(this).setVisible(false);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    protected boolean displayBackend(BackendDescriptor backend) {
        return !backend.isConfigBackend() && backend.getType() == BackendDescriptor.Type.LOCAL_DB;
    }

    private String getSelectedBaseDN() {
        String dn = null;
        CategorizedComboBoxElement o = (CategorizedComboBoxElement)this.baseDNs.getSelectedItem();
        if (o != null) {
            dn = (String)o.getValue();
        }
        return dn;
    }

    private AbstractIndexDescriptor getSelectedIndex() {
        AbstractIndexDescriptor index = null;
        CategorizedComboBoxElement o = (CategorizedComboBoxElement)this.keyEntryIDs.getSelectedItem();
        if (o != null) {
            index = (AbstractIndexDescriptor)o.getValue();
        }
        return index;
    }

    private void updateVerifyKeyEntriesComboBox() {
        SortedSet<AbstractIndexDescriptor> indexes;
        String dn = this.getSelectedBaseDN();
        if (dn != null && (indexes = this.hmIndexes.get(dn)) != null) {
            ArrayList<CategorizedComboBoxElement> newElements = new ArrayList<CategorizedComboBoxElement>();
            ArrayList<IndexDescriptor> databaseIndexes = new ArrayList<IndexDescriptor>();
            ArrayList<IndexDescriptor> attributeIndexes = new ArrayList<IndexDescriptor>();
            ArrayList<AbstractIndexDescriptor> vlvIndexes = new ArrayList<AbstractIndexDescriptor>();
            for (AbstractIndexDescriptor abstractIndexDescriptor : indexes) {
                if (abstractIndexDescriptor instanceof IndexDescriptor) {
                    IndexDescriptor standardIndex = (IndexDescriptor)abstractIndexDescriptor;
                    if (standardIndex.isDatabaseIndex()) {
                        databaseIndexes.add(standardIndex);
                        continue;
                    }
                    attributeIndexes.add(standardIndex);
                    continue;
                }
                vlvIndexes.add(abstractIndexDescriptor);
            }
            if (databaseIndexes.size() > 0) {
                newElements.add(new CategorizedComboBoxElement(this.DATABASE_INDEXES, CategorizedComboBoxElement.Type.CATEGORY));
                for (AbstractIndexDescriptor abstractIndexDescriptor : databaseIndexes) {
                    newElements.add(new CategorizedComboBoxElement(abstractIndexDescriptor, CategorizedComboBoxElement.Type.REGULAR));
                }
            }
            if (attributeIndexes.size() > 0) {
                newElements.add(new CategorizedComboBoxElement(this.ATTRIBUTE_INDEXES, CategorizedComboBoxElement.Type.CATEGORY));
                for (AbstractIndexDescriptor abstractIndexDescriptor : attributeIndexes) {
                    newElements.add(new CategorizedComboBoxElement(abstractIndexDescriptor, CategorizedComboBoxElement.Type.REGULAR));
                }
            }
            if (vlvIndexes.size() > 0) {
                newElements.add(new CategorizedComboBoxElement(this.VLV_INDEXES, CategorizedComboBoxElement.Type.CATEGORY));
                for (AbstractIndexDescriptor abstractIndexDescriptor : vlvIndexes) {
                    newElements.add(new CategorizedComboBoxElement(abstractIndexDescriptor, CategorizedComboBoxElement.Type.REGULAR));
                }
            }
            this.updateComboBoxModel(newElements, (DefaultComboBoxModel)this.keyEntryIDs.getModel());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VerifyIndexTask
    extends IndexTask {
        private String baseDN;

        public VerifyIndexTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(info, dlg, VerifyIndexPanel.this.getSelectedBaseDN());
            this.baseDN = VerifyIndexPanel.this.getSelectedBaseDN();
        }

        @Override
        public Task.Type getType() {
            return Task.Type.VERIFY_INDEXES;
        }

        @Override
        public Message getTaskDescription() {
            return AdminToolMessages.INFO_CTRL_PANEL_VERIFY_INDEX_TASK_DESCRIPTION.get(this.baseDN);
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (this.state == Task.State.RUNNING) {
                TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
                backends.retainAll(this.getBackends());
                Task.Type type = taskToBeLaunched.getType();
                if (type != Task.Type.BACKUP && type != Task.Type.EXPORT_LDIF && type != Task.Type.ENABLE_WINDOWS_SERVICE && type != Task.Type.DISABLE_WINDOWS_SERVICE && backends.size() > 0) {
                    incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                    canLaunch = false;
                }
            }
            return canLaunch;
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                List arguments = this.getCommandLineArguments();
                String[] args = new String[((ArrayList)arguments).size()];
                ((ArrayList)arguments).toArray(args);
                this.returnCode = this.executeCommandLine(this.getCommandLinePath(), args);
                this.state = this.returnCode != 0 ? Task.State.FINISHED_WITH_ERROR : Task.State.FINISHED_SUCCESSFULLY;
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
        }

        protected ArrayList<String> getCommandLineArguments() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--baseDN");
            args.add(VerifyIndexPanel.this.getSelectedBaseDN());
            if (VerifyIndexPanel.this.verifyIndexContents.isSelected()) {
                SortableListModel model = VerifyIndexPanel.this.addRemove.getSelectedListModel();
                for (AbstractIndexDescriptor index : model.getData()) {
                    args.add("--index");
                    if (index instanceof VLVIndexDescriptor) {
                        args.add(Utilities.getVLVNameInCommandLine((VLVIndexDescriptor)index));
                        continue;
                    }
                    args.add(index.getName());
                }
            } else {
                args.add("--index");
                AbstractIndexDescriptor index = VerifyIndexPanel.this.getSelectedIndex();
                if (index instanceof VLVIndexDescriptor) {
                    args.add(Utilities.getVLVNameInCommandLine((VLVIndexDescriptor)index));
                } else {
                    args.add(index.getName());
                }
                args.add("--clean");
            }
            args.add("--countErrors");
            return args;
        }

        @Override
        protected String getCommandLinePath() {
            return this.getCommandLinePath("verify-index");
        }
    }
}

