/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.opends.guitools.controlpanel.datamodel.BinaryValue;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.components.CellEditorButton;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class BinaryCellPanel
extends JPanel {
    private static final long serialVersionUID = 6607973945986559802L;
    private JButton iconButton;
    private JLabel label;
    private CellEditorButton editButton;
    private CellEditorButton deleteButton;
    private boolean displayDelete;
    private JLabel lockLabel = Utilities.createDefaultLabel();
    private ImageIcon lockIcon = Utilities.createImageIcon("org/opends/guitools/controlpanel/images/field-locked.png");
    private Object value;
    private static final int THUMBNAIL_HEIGHT = 50;
    private static final Logger LOG = Logger.getLogger(BinaryCellPanel.class.getName());

    public BinaryCellPanel() {
        super(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.iconButton = Utilities.createButton(Message.EMPTY);
        this.label = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_VALUE_SPECIFIED.get());
        this.add(this.iconButton);
        this.iconButton.setVisible(false);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        this.add((Component)this.label, gbc);
        this.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridx;
        this.editButton = new CellEditorButton(AdminToolMessages.INFO_CTRL_PANEL_EDIT_BUTTON_LABEL.get());
        this.editButton.setForeground(ColorAndFontConstants.buttonForeground);
        this.editButton.setOpaque(false);
        gbc.insets.left = 5;
        gbc.weightx = 0.0;
        this.add((Component)this.editButton, gbc);
        ++gbc.gridx;
        this.deleteButton = new CellEditorButton(AdminToolMessages.INFO_CTRL_PANEL_DELETE_BUTTON_LABEL.get());
        this.deleteButton.setForeground(ColorAndFontConstants.buttonForeground);
        this.deleteButton.setOpaque(false);
        this.deleteButton.setVisible(this.isDisplayDelete());
        this.add((Component)this.deleteButton, gbc);
        gbc.insets.left = 5;
        ++gbc.gridx;
        this.add((Component)this.lockLabel, gbc);
        this.lockLabel.setVisible(false);
    }

    public Message getString(byte[] value, boolean isImage) {
        if (value == null) {
            return AdminToolMessages.INFO_CTRL_PANEL_NO_VALUE_SPECIFIED.get();
        }
        if (isImage) {
            return Message.EMPTY;
        }
        return AdminToolMessages.INFO_CTRL_PANEL_BINARY_VALUE.get();
    }

    public void setLockIconVisible(boolean visible) {
        if (visible) {
            this.lockLabel.setIcon(this.lockIcon);
            this.lockLabel.setVisible(true);
        } else {
            this.lockLabel.setIcon(null);
            this.lockLabel.setVisible(false);
        }
    }

    public void setEditButtonText(Message text) {
        this.editButton.setText(text.toString());
    }

    public Message getMessage(BinaryValue value, boolean isImage) {
        Message returnValue = value == null ? AdminToolMessages.INFO_CTRL_PANEL_NO_VALUE_SPECIFIED.get() : (isImage ? Message.EMPTY : (value.getType() == BinaryValue.Type.BASE64_STRING ? AdminToolMessages.INFO_CTRL_PANEL_BINARY_VALUE.get() : AdminToolMessages.INFO_CTRL_PANEL_CONTENTS_OF_FILE.get(value.getFile().toString())));
        return returnValue;
    }

    public void setValue(byte[] value, boolean isImage) {
        this.label.setText(this.getString(value, isImage).toString());
        this.deleteButton.setVisible(value != null && this.isDisplayDelete());
        this.value = value;
        if (!isImage) {
            this.label.setIcon(null);
            this.label.setVisible(true);
            this.iconButton.setVisible(false);
        } else {
            this.updateIcon(value);
        }
    }

    public void setValue(BinaryValue value, boolean isImage) {
        this.label.setText(this.getMessage(value, isImage).toString());
        this.deleteButton.setVisible(value != null && this.isDisplayDelete());
        this.value = value;
        if (!isImage) {
            this.label.setIcon(null);
            this.label.setVisible(true);
            this.iconButton.setVisible(false);
        } else {
            try {
                this.updateIcon(value.getBytes());
            }
            catch (ParseException pe) {
                LOG.log(Level.WARNING, "Error decoding base 64 value: " + pe, pe);
                Utilities.setWarningLabel(this.label, AdminToolMessages.ERR_LOADING_IMAGE.get());
            }
        }
    }

    private void updateIcon(byte[] value) {
        if (value == null) {
            this.label.setVisible(true);
            this.iconButton.setVisible(false);
        } else {
            Icon icon = this.getIcon(value);
            if (icon == null || icon.getIconHeight() <= 0) {
                Utilities.setWarningLabel(this.label, AdminToolMessages.ERR_LOADING_IMAGE.get());
                this.label.setVisible(true);
                this.iconButton.setVisible(false);
            } else {
                this.iconButton.setVisible(true);
                this.iconButton.setIcon(icon);
                this.label.setVisible(false);
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void requestFocusForButton() {
        this.editButton.requestFocusInWindow();
    }

    public void addEditActionListener(ActionListener listener) {
        this.editButton.addActionListener(listener);
        this.iconButton.addActionListener(listener);
    }

    public void removeEditActionListener(ActionListener listener) {
        this.editButton.removeActionListener(listener);
        this.iconButton.removeActionListener(listener);
    }

    public void addDeleteActionListener(ActionListener listener) {
        this.deleteButton.addActionListener(listener);
    }

    public void removeDeleteActionListener(ActionListener listener) {
        this.deleteButton.removeActionListener(listener);
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return this.editButton.processKeyBinding(ks, e, condition, pressed);
    }

    public boolean isDisplayDelete() {
        return this.displayDelete;
    }

    public void setDisplayDelete(boolean displayDelete) {
        this.displayDelete = displayDelete;
    }

    private Icon getIcon(byte[] bytes) {
        return Utilities.createImageIcon(bytes, 50, AdminToolMessages.INFO_CTRL_PANEL_THUMBNAIL_DESCRIPTION.get(), true);
    }
}

