/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.ToolTipManager;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.Message;

public class LabelWithHelpIcon
extends JPanel {
    private static final long serialVersionUID = 4502977901538910797L;
    protected JLabel label = Utilities.createDefaultLabel();
    protected JLabel iconLabel = new JLabel(icon);
    private static final ImageIcon icon = Utilities.createImageIcon("org/opends/quicksetup/images/help_small.gif");
    private static final ToolTipManager ttipManager = ToolTipManager.sharedInstance();
    private Popup tipWindow;
    private boolean isVisible;
    protected final int INSET_WITH_ICON = 3;

    public LabelWithHelpIcon(Message text, Message tooltipIcon) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.label.setText(text.toString());
        this.label.setForeground(ColorAndFontConstants.foreground);
        if (tooltipIcon != null) {
            this.iconLabel.setToolTipText(tooltipIcon.toString());
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.add((Component)this.label, gbc);
        ++gbc.gridx;
        gbc.insets.left = 3;
        this.add((Component)this.iconLabel, gbc);
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add(Box.createHorizontalGlue(), gbc);
        ttipManager.unregisterComponent(this.iconLabel);
        this.iconLabel.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent event) {
                LabelWithHelpIcon.this.hideToolTip(event);
            }

            public void mousePressed(MouseEvent event) {
                if (LabelWithHelpIcon.this.isVisible) {
                    LabelWithHelpIcon.this.hideToolTip(event);
                } else {
                    LabelWithHelpIcon.this.displayToolTip(event);
                }
            }
        });
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setFont(Font font) {
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    public void setHelpTooltip(String tooltip) {
        this.iconLabel.setToolTipText(tooltip);
    }

    public String getHelpTooltip() {
        return this.iconLabel.getToolTipText();
    }

    public void setHelpIconVisible(boolean visible) {
        if (visible) {
            if (this.iconLabel.getIcon() != icon) {
                this.iconLabel.setIcon(icon);
            }
        } else if (this.iconLabel.getIcon() != null) {
            this.iconLabel.setIcon(null);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    private void displayToolTip(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        String toolTipText = component.getToolTipText();
        if (toolTipText != null) {
            Point preferredLocation = component.getToolTipLocation(event);
            Rectangle sBounds = component.getGraphicsConfiguration().getBounds();
            JToolTip tip = component.createToolTip();
            tip.setTipText(toolTipText);
            Dimension size = tip.getPreferredSize();
            Point location = new Point();
            Point screenLocation = component.getLocationOnScreen();
            if (preferredLocation != null) {
                location.x = screenLocation.x + preferredLocation.x;
                location.y = screenLocation.y + preferredLocation.y;
            } else {
                location.x = screenLocation.x + event.getX();
                location.y = screenLocation.y + event.getY() + 20;
            }
            if (location.x < sBounds.x) {
                location.x = sBounds.x;
            } else if (location.x - sBounds.x + size.width > sBounds.width) {
                location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
            }
            if (location.y < sBounds.y) {
                location.y = sBounds.y;
            } else if (location.y - sBounds.y + size.height > sBounds.height) {
                location.y = sBounds.y + Math.max(0, sBounds.height - size.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = popupFactory.getPopup(component, tip, location.x, location.y);
            this.tipWindow.show();
        }
        this.isVisible = true;
    }

    private void hideToolTip(MouseEvent event) {
        if (this.tipWindow != null) {
            this.tipWindow.hide();
            this.tipWindow = null;
        }
        this.isVisible = false;
    }
}

