/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.event.EntryReadErrorEvent;
import org.opends.guitools.controlpanel.event.EntryReadEvent;
import org.opends.guitools.controlpanel.event.EntryReadListener;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPEntryReader
extends BackgroundTask<CustomSearchResult> {
    private String dn;
    private InitialLdapContext ctx;
    private Schema schema;
    private Set<EntryReadListener> listeners = new HashSet<EntryReadListener>();
    private boolean isOver;

    public LDAPEntryReader(String dn, InitialLdapContext ctx, Schema schema) {
        this.dn = dn;
        this.ctx = ctx;
        this.schema = schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomSearchResult processBackgroundTask() throws Throwable {
        this.isOver = false;
        try {
            SearchControls controls = new SearchControls();
            controls.setCountLimit(1L);
            Set<String> operational = this.getAllOperationalAttributes();
            String[] attrs = new String[operational.size() + 1];
            Iterator<String> it = operational.iterator();
            int i = 0;
            while (it.hasNext()) {
                attrs[i] = it.next();
                ++i;
            }
            attrs[attrs.length - 1] = "*";
            controls.setReturningAttributes(attrs);
            controls.setSearchScope(0);
            String filter = "(|(objectclass=*)(objectclass=ldapsubentry))";
            NamingEnumeration<SearchResult> en = this.ctx.search(Utilities.getJNDIName(this.dn), "(|(objectclass=*)(objectclass=ldapsubentry))", controls);
            SearchResult sr = en.next();
            CustomSearchResult customSearchResult = new CustomSearchResult(sr, this.dn);
            return customSearchResult;
        }
        finally {
            if (this.isInterrupted()) {
                this.isOver = true;
            }
        }
    }

    @Override
    public void backgroundTaskCompleted(CustomSearchResult sr, Throwable throwable) {
        if (!this.isInterrupted()) {
            if (throwable == null) {
                this.notifyListeners(sr);
            } else {
                this.notifyListeners(throwable);
            }
        }
        this.isOver = true;
    }

    public boolean isOver() {
        return this.isOver;
    }

    private void notifyListeners(CustomSearchResult sr) {
        EntryReadEvent ev = new EntryReadEvent(this, sr);
        for (EntryReadListener listener : this.listeners) {
            listener.entryRead(ev);
        }
    }

    private void notifyListeners(Throwable t) {
        EntryReadErrorEvent ev = new EntryReadErrorEvent(this, this.dn, t);
        for (EntryReadListener listener : this.listeners) {
            listener.entryReadError(ev);
        }
    }

    public void addEntryReadListener(EntryReadListener listener) {
        this.listeners.add(listener);
    }

    public void removeEntryReadListener(EntryReadListener listener) {
        this.listeners.remove(listener);
    }

    private Set<String> getAllOperationalAttributes() {
        HashSet<String> attrs = new HashSet<String>();
        if (this.schema != null) {
            for (AttributeType attr : this.schema.getAttributeTypes().values()) {
                if (!attr.isOperational()) continue;
                attrs.add(attr.getNameOrOID());
            }
        }
        return attrs;
    }
}

