/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.uninstaller;

import java.io.IOException;
import java.util.Iterator;
import org.opends.admin.ads.ADSContext;
import org.opends.quicksetup.Configuration;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.util.Utils;

public class UninstallData {
    private boolean isServerRunning;
    private boolean isADS;
    private boolean isReplicationServer;
    private int replicationServerPort;

    public UninstallData(Installation installation) throws IOException {
        this.isServerRunning = installation.getStatus().isServerRunning();
        Configuration conf = new Configuration(installation, installation.getCurrentConfigurationFile());
        Iterator<String> it = conf.getBaseDNs().iterator();
        while (it.hasNext() && !this.isADS) {
            this.isADS = Utils.areDnsEqual(it.next(), ADSContext.getAdministrationSuffixDN());
        }
        this.isReplicationServer = conf.isReplicationServer();
        this.replicationServerPort = conf.getReplicationPort();
    }

    public boolean isADS() {
        return this.isADS;
    }

    public boolean isReplicationServer() {
        return this.isReplicationServer;
    }

    public boolean isServerRunning() {
        return this.isServerRunning;
    }

    public int getReplicationServerPort() {
        return this.replicationServerPort;
    }
}

