/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private static final Logger LOG = Logger.getLogger(Configuration.class.getName());
    private String contents = null;
    private String lowerCaseContents = null;
    private Installation install = null;
    private File file = null;

    public Configuration(Installation install, File file) {
        if (install == null) {
            throw new NullPointerException("config file cannot be null");
        }
        if (file == null) {
            throw new NullPointerException("config file cannot be null");
        }
        if (!file.getName().startsWith("config.ldif")) {
            throw new IllegalArgumentException("file must be a config.ldif file");
        }
        this.install = install;
        this.file = file;
    }

    public Set<String> getDirectoryManagerDns() throws IOException {
        return this.getConfigurationValues("ds-cfg-alternate-bind-dn");
    }

    public int getPort() throws IOException {
        return this.getLDAPPort("ds-cfg-listen-port");
    }

    public boolean isReplicationServer() throws IOException {
        return this.getReplicationPort() != -1;
    }

    public int getReplicationPort() throws IOException {
        int index2;
        String attrWithPoints;
        int index1;
        int port = -1;
        String contents = this.getLowerCaseContents();
        int index = contents.indexOf("cn=replication server");
        if (index != -1 && (index1 = contents.indexOf(attrWithPoints = "ds-cfg-replication-port:", index)) != -1 && (index2 = contents.indexOf(Constants.LINE_SEPARATOR, index1)) != -1) {
            String sPort = contents.substring(attrWithPoints.length() + index1, index2).trim();
            try {
                port = Integer.parseInt(sPort);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return port;
    }

    public Set<String> getLogPaths() throws IOException {
        return this.getConfigurationValues("ds-cfg-log-file");
    }

    private int getLDAPPort(String portAttr) throws IOException {
        int index2;
        String attrWithPoints;
        int index1;
        int port = -1;
        String contents = this.getLowerCaseContents();
        int index = contents.indexOf("cn=ldap connection handler");
        if (index != -1 && (index1 = contents.indexOf(attrWithPoints = portAttr + ":", index)) != -1 && (index2 = contents.indexOf(Constants.LINE_SEPARATOR, index1)) != -1) {
            String sPort = contents.substring(attrWithPoints.length() + index1, index2).trim();
            try {
                port = Integer.parseInt(sPort);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return port;
    }

    public boolean hasBeenModified() throws IOException {
        boolean isConfigFileModified;
        boolean bl = isConfigFileModified = this.getPort() != 389;
        if (!isConfigFileModified) {
            isConfigFileModified = this.getLowerCaseContents().indexOf("# cddl header start") == -1;
        }
        return isConfigFileModified;
    }

    public Set<String> getOutsideLogs() throws IOException {
        return this.getOutsidePaths(this.getLogPaths());
    }

    public Set<String> getOutsideDbs() throws IOException {
        return this.getOutsidePaths(this.getDatabasePaths());
    }

    private Set<String> getOutsidePaths(Set<String> paths) {
        HashSet<String> outsidePaths = new HashSet<String>();
        for (String path : paths) {
            File pathFile = new File(path);
            File fullDbPath = pathFile.isAbsolute() ? pathFile : new File(this.install.getInstanceDirectory(), path);
            if (Utils.isDescendant(fullDbPath, this.install.getInstanceDirectory())) continue;
            outsidePaths.add(Utils.getPath(fullDbPath));
        }
        return outsidePaths;
    }

    public String getContents() throws IOException {
        if (this.contents == null) {
            this.load();
        }
        return this.contents;
    }

    public String getLowerCaseContents() throws IOException {
        if (this.lowerCaseContents == null) {
            this.load();
        }
        return this.lowerCaseContents;
    }

    public Set<String> getDatabasePaths() throws IOException {
        return this.getConfigurationValues("ds-cfg-db-directory");
    }

    public Set<String> getBaseDNs() throws IOException {
        return this.getConfigurationValues("ds-cfg-base-dn");
    }

    public void load() throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        FileReader reader = new FileReader(this.file);
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            buf.append(line).append(Constants.LINE_SEPARATOR);
        }
        reader.close();
        this.contents = buf.toString();
        this.lowerCaseContents = this.contents.toLowerCase();
    }

    private Set<String> getConfigurationValues(String attrName) throws IOException {
        HashSet<String> set = new HashSet<String>();
        attrName = attrName + ":";
        String lowerCaseContents = this.getLowerCaseContents();
        String contents = this.getContents();
        int index1 = lowerCaseContents.indexOf(attrName);
        while (index1 != -1) {
            int index2 = lowerCaseContents.indexOf(Constants.LINE_SEPARATOR, index1);
            String value = index2 > index1 + attrName.length() ? contents.substring(attrName.length() + index1, index2).trim() : (lowerCaseContents.length() > index1 + attrName.length() ? contents.substring(attrName.length() + index1).trim() : null);
            if (value != null && value.length() > 0) {
                set.add(value);
            }
            index1 = lowerCaseContents.indexOf(attrName, index1 + attrName.length());
        }
        return set;
    }
}

