/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.File;
import java.io.IOException;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.util.Utils;
import org.opends.server.core.LockFileManager;

public class Status {
    private Installation installation;

    public Status(Installation installation) {
        this.installation = installation;
    }

    public boolean isInstalled() {
        File rootDirectory = this.installation.getRootDirectory();
        return rootDirectory == null || !rootDirectory.exists() || !rootDirectory.isDirectory();
    }

    public boolean configurationHasBeenModified() {
        boolean mod = false;
        try {
            mod = this.installation.getCurrentConfiguration().hasBeenModified();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mod;
    }

    public boolean schemaHasBeenModified() {
        File f = this.installation.getSchemaConcatFile();
        return f.exists();
    }

    public boolean isServerRunning() {
        boolean isServerRunning;
        String lockFileName = "server.lock";
        String lockFile = Utils.getPath(new File(this.installation.getLocksDirectory(), lockFileName));
        StringBuilder failureReason = new StringBuilder();
        try {
            if (LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                LockFileManager.releaseLock(lockFile, failureReason);
                isServerRunning = false;
            } else {
                isServerRunning = true;
            }
        }
        catch (Throwable t) {
            isServerRunning = true;
        }
        return isServerRunning;
    }

    public boolean dbFilesExist() {
        boolean dbFilesExist = false;
        File dbDir = this.installation.getDatabasesDirectory();
        File[] children = dbDir.listFiles();
        if (children != null && children.length > 0) {
            dbFilesExist = true;
        }
        return dbFilesExist;
    }
}

