/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer;

import org.opends.quicksetup.installer.AuthenticationData;
import org.opends.quicksetup.util.Utils;

public class DataReplicationOptions {
    private Type type;
    private int replicationPort = DataReplicationOptions.getDefaultReplicationPort();
    private boolean secureReplication;
    private AuthenticationData authenticationData = new AuthenticationData();

    private DataReplicationOptions() {
        this.authenticationData.setDn("cn=Directory Manager");
        this.authenticationData.setPort(4444);
    }

    public static DataReplicationOptions createFirstInTopology(int replicationPort, boolean secureReplication) {
        DataReplicationOptions options = new DataReplicationOptions();
        options.type = Type.FIRST_IN_TOPOLOGY;
        options.replicationPort = replicationPort;
        options.secureReplication = secureReplication;
        return options;
    }

    public static DataReplicationOptions createStandalone() {
        DataReplicationOptions options = new DataReplicationOptions();
        options.type = Type.STANDALONE;
        return options;
    }

    public static DataReplicationOptions createInExistingTopology(AuthenticationData authenticationData, int replicationPort, boolean secureReplication) {
        DataReplicationOptions options = new DataReplicationOptions();
        options.type = Type.IN_EXISTING_TOPOLOGY;
        options.authenticationData = authenticationData;
        options.replicationPort = replicationPort;
        options.secureReplication = secureReplication;
        return options;
    }

    public Type getType() {
        return this.type;
    }

    public AuthenticationData getAuthenticationData() {
        return this.authenticationData;
    }

    public int getReplicationPort() {
        return this.replicationPort;
    }

    public boolean useSecureReplication() {
        return this.secureReplication;
    }

    static int getDefaultReplicationPort() {
        int defaultPort = -1;
        for (int i = 0; i < 10000 && defaultPort == -1; i += 1000) {
            int port = i + 8989;
            if (!Utils.canUseAsPort(port)) continue;
            defaultPort = port;
        }
        return defaultPort;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STANDALONE,
        FIRST_IN_TOPOLOGY,
        IN_EXISTING_TOPOLOGY;

    }
}

