/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.upgrader.Upgrader;
import org.opends.quicksetup.util.Utils;
import org.opends.server.tools.ToolConstants;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class UpgradeLauncher
extends Launcher {
    public static final String LOG_FILE_PREFIX = "opends-upgrade-";
    private static final Logger LOG = Logger.getLogger(UpgradeLauncher.class.getName());
    public static final Character FILE_OPTION_SHORT = Character.valueOf('f');
    public static final String FILE_OPTION_LONG = "file";
    public static final Character REVERT_ARCHIVE_OPTION_SHORT = Character.valueOf('a');
    public static final String REVERT_ARCHIVE_OPTION_LONG = "reversionArchive";
    public static final Character REVERT_MOST_RECENT_OPTION_SHORT = Character.valueOf('r');
    public static final String REVERT_MOST_RECENT_OPTION_LONG = "revertMostRecent";
    protected boolean isUpgrade;
    protected boolean isReversion;
    private ArgumentParser argParser;
    private BooleanArgument showUsage;
    private StringArgument file;
    private BooleanArgument quiet;
    private BooleanArgument noPrompt;
    private BooleanArgument verbose;
    private BooleanArgument revertMostRecent;
    private StringArgument reversionArchive;

    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, ".log"));
        }
        catch (Throwable t) {
            System.err.println(QuickSetupMessages.INFO_ERROR_INITIALIZING_LOG.get());
            t.printStackTrace();
        }
        new UpgradeLauncher(args).launch();
    }

    protected Message getFrameTitle() {
        return Utils.getCustomizedObject("INFO_FRAME_UPGRADE_TITLE", QuickSetupMessages.INFO_FRAME_UPGRADE_TITLE.get(), Message.class);
    }

    protected boolean isCli() {
        return true;
    }

    protected void printUsage(boolean toStdErr) {
        try {
            ArgumentParser argParser = this.getArgumentParser();
            if (argParser != null) {
                String msg = argParser.getUsage();
                this.printUsage(msg, toStdErr);
            }
        }
        catch (Throwable t) {
            System.out.println("ERROR: " + t);
            t.printStackTrace();
        }
    }

    protected CliApplication createCliApplication() {
        return new Upgrader();
    }

    protected void willLaunchGui() {
        System.out.println(QuickSetupMessages.INFO_UPGRADE_LAUNCHER_LAUNCHING_GUI.get());
        System.setProperty("org.opends.quicksetup.Application.class", "org.opends.quicksetup.upgrader.Upgrader");
    }

    protected void guiLaunchFailed(String logFilePath) {
        if (logFilePath != null) {
            System.err.println(QuickSetupMessages.INFO_UPGRADE_LAUNCHER_GUI_LAUNCHED_FAILED_DETAILS.get(logFilePath));
        } else {
            System.err.println(QuickSetupMessages.INFO_UPGRADE_LAUNCHER_GUI_LAUNCHED_FAILED.get());
        }
    }

    public ArgumentParser getArgumentParser() {
        return this.argParser;
    }

    public boolean isQuiet() {
        return this.quiet.isPresent();
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    public boolean isNoPrompt() {
        return this.noPrompt.isPresent();
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    public boolean isReversion() {
        return this.isReversion;
    }

    public boolean isInteractive() {
        return !this.file.isPresent() && !this.reversionArchive.isPresent() && !this.revertMostRecent.isPresent();
    }

    public String getUpgradeFileName() {
        return this.file.getValue();
    }

    public String getReversionArchiveDirectoryName() {
        return this.reversionArchive.getValue();
    }

    public File getReversionArchiveDirectory() {
        File f = null;
        String s = this.reversionArchive.getValue();
        if (s != null) {
            f = new File(s);
        }
        return f;
    }

    public boolean isRevertMostRecent() {
        return this.revertMostRecent.isPresent();
    }

    public boolean isRevertToArchive() {
        return this.reversionArchive.isPresent();
    }

    protected UpgradeLauncher(String[] args) {
        super(args);
        String scriptName = Utils.isWindows() ? "upgrade.bat" : "upgrade";
        if (System.getProperty("org.opends.server.scriptName") == null) {
            System.setProperty("org.opends.server.scriptName", scriptName);
        }
        this.argParser = new ArgumentParser(this.getClass().getName(), QuickSetupMessages.INFO_UPGRADE_LAUNCHER_USAGE_DESCRIPTION.get(), false);
        try {
            this.file = new StringArgument(FILE_OPTION_LONG, FILE_OPTION_SHORT, FILE_OPTION_LONG, false, false, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_UPGRADE_DESCRIPTION_FILE.get());
            this.argParser.addArgument(this.file);
            this.revertMostRecent = new BooleanArgument(REVERT_MOST_RECENT_OPTION_LONG, REVERT_MOST_RECENT_OPTION_SHORT, REVERT_MOST_RECENT_OPTION_LONG, ToolMessages.INFO_REVERT_DESCRIPTION_RECENT.get());
            this.argParser.addArgument(this.revertMostRecent);
            this.reversionArchive = new StringArgument(REVERT_ARCHIVE_OPTION_LONG, REVERT_ARCHIVE_OPTION_SHORT, REVERT_ARCHIVE_OPTION_LONG, false, false, true, ToolMessages.INFO_DIRECTORY_PLACEHOLDER.get(), null, null, ToolMessages.INFO_REVERT_DESCRIPTION_DIRECTORY.get());
            this.argParser.addArgument(this.reversionArchive);
            this.noPrompt = new BooleanArgument("no-prompt", ToolConstants.OPTION_SHORT_NO_PROMPT, "no-prompt", ToolMessages.INFO_UPGRADE_DESCRIPTION_NO_PROMPT.get());
            this.argParser.addArgument(this.noPrompt);
            this.quiet = new BooleanArgument("quiet", ToolConstants.OPTION_SHORT_QUIET, "quiet", ToolMessages.INFO_UPGRADE_DESCRIPTION_SILENT.get());
            this.argParser.addArgument(this.quiet);
            this.verbose = new BooleanArgument("verbose", ToolConstants.OPTION_SHORT_VERBOSE, "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get());
            this.argParser.addArgument(this.verbose);
            this.showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            this.argParser.addArgument(this.showUsage);
            this.argParser.setUsageArgument(this.showUsage);
            try {
                this.argParser.parseArguments(args);
                this.isUpgrade = this.file.isPresent();
                boolean bl = this.isReversion = this.reversionArchive.isPresent() || this.revertMostRecent.isPresent();
                if (this.argParser.usageOrVersionDisplayed()) {
                    System.exit(ReturnCode.PRINT_USAGE.getReturnCode());
                } else if (this.isUpgrade) {
                    if (this.reversionArchive.isPresent()) {
                        System.err.println(ToolMessages.ERR_UPGRADE_INCOMPATIBLE_ARGS.get(this.file.getName(), this.reversionArchive.getName()));
                        System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                    } else if (this.revertMostRecent.isPresent()) {
                        System.err.println(ToolMessages.ERR_UPGRADE_INCOMPATIBLE_ARGS.get(this.file.getName(), this.revertMostRecent.getName()));
                        System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                    }
                }
            }
            catch (ArgumentException ae) {
                System.err.println(ae.getMessageObject());
                this.printUsage(false);
                System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
            }
        }
        catch (Throwable t) {
            System.out.println("ERROR: " + t);
            t.printStackTrace();
        }
    }
}

