/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.admin.ads.ADSContext;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.HistoricalRecord;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.LicenseFile;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.WizardStep;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.FinishedPanel;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.ProgressPanel;
import org.opends.quicksetup.ui.QuickSetup;
import org.opends.quicksetup.ui.QuickSetupDialog;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.upgrader.MigrationManager;
import org.opends.quicksetup.upgrader.RemoteBuildManager;
import org.opends.quicksetup.upgrader.Stage;
import org.opends.quicksetup.upgrader.UpgradeFileFilter;
import org.opends.quicksetup.upgrader.UpgradeIssueNotifier;
import org.opends.quicksetup.upgrader.UpgradeLauncher;
import org.opends.quicksetup.upgrader.UpgradeProgressStep;
import org.opends.quicksetup.upgrader.UpgradeUserData;
import org.opends.quicksetup.upgrader.UpgradeWizardStep;
import org.opends.quicksetup.upgrader.UpgraderCliHelper;
import org.opends.quicksetup.upgrader.ui.UpgraderReviewPanel;
import org.opends.quicksetup.upgrader.ui.WelcomePanel;
import org.opends.quicksetup.util.ExternalTools;
import org.opends.quicksetup.util.FileManager;
import org.opends.quicksetup.util.InProcessServerController;
import org.opends.quicksetup.util.OperationOutput;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.ServerHealthChecker;
import org.opends.quicksetup.util.Utils;
import org.opends.quicksetup.util.ZipExtractor;
import org.opends.quicksetup.webstart.WebStartDownloader;
import org.opends.server.tools.JavaPropertiesTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Upgrader
extends GuiApplication
implements CliApplication {
    private static final Logger LOG = Logger.getLogger(Upgrader.class.getName());
    private static final String SYS_PROP_INSTALL_ROOT = "org.opends.quicksetup.upgrader.Root";
    private static final String SYS_PROP_INSTANCE_ROOT = "org.opends.quicksetup.upgrader.Instance";
    private static final String SYS_PROP_CREATE_ERROR = "org.opends.quicksetup.upgrader.CreateError";
    private static final String SYS_PROP_CREATE_VERIFY_ERROR = "org.opends.quicksetup.upgrader.VerifyError";
    static final String SYS_PROP_NO_ABORT = "org.opends.quicksetup.upgrader.NoAbort";
    static final String[] ROOT_FILES_TO_IGNORE_DURING_BACKUP = new String[]{"changelogDb", "db", "logs", "locks", "history", "tmp", "instance.loc"};
    static final String[] ROOT_FILE_FOR_INSTALL_DIR = new String[]{"bin", "lib", "bat", "config" + File.separator + "schema", "setup", "setup.bat", "uninstall", "uninstall.bat", "install.html", "install.txt", "legal-notices", "opends_logo.png", "README", "upgrade", "upgrade.bat", "QuickSetup.app", "Uninstall.app", "tmpl_instance"};
    static final String[] FILES_TO_IGNORE_DURING_BACKUP = new String[]{Installation.TOOLS_PROPERTIES, Installation.RELATIVE_JAVA_PROPERTIES_FILE, ADSContext.getAdminLDIFFile()};
    private ProgressStep currentProgressStep = UpgradeProgressStep.NOT_STARTED;
    private ApplicationException runError = null;
    private ApplicationException runWarning = null;
    private File backupDirectory = null;
    private Long historicalOperationId;
    protected BuildInformation currentVersion = null;
    protected BuildInformation currentInstanceVersion = null;
    private BuildInformation stagedVersion = null;
    private Installation stagedInstallation = null;
    private RemoteBuildManager remoteBuildManager = null;
    private Stage stage = null;
    private boolean abort = false;

    public Upgrader() {
        try {
            if (!QuickSetupLog.isInitialized()) {
                QuickSetupLog.initLogFileHandler(File.createTempFile("opends-upgrade-", ".log"));
            }
        }
        catch (IOException e) {
            System.err.println(QuickSetupMessages.INFO_ERROR_INITIALIZING_LOG.get());
            e.printStackTrace();
        }
        if (Utils.isWebStart()) {
            this.initLoader();
        }
        String installRootFromSystem = System.getProperty(SYS_PROP_INSTALL_ROOT);
        String instanceRootFromSystem = System.getProperty(SYS_PROP_INSTANCE_ROOT);
        if (installRootFromSystem != null) {
            if (instanceRootFromSystem != null) {
                this.setInstallation(new Installation(installRootFromSystem, instanceRootFromSystem));
            } else {
                this.setInstallation(new Installation(installRootFromSystem, installRootFromSystem));
            }
        }
    }

    @Override
    public Message getFrameTitle() {
        return Utils.getCustomizedObject("INFO_FRAME_UPGRADE_TITLE", QuickSetupMessages.INFO_FRAME_UPGRADE_TITLE.get(), Message.class);
    }

    @Override
    public WizardStep getFirstWizardStep() {
        return UpgradeWizardStep.WELCOME;
    }

    @Override
    public void setWizardDialogState(QuickSetupDialog dlg, UserData userData, WizardStep step) {
        if (step == UpgradeWizardStep.REVIEW) {
            dlg.setFocusOnButton(ButtonName.FINISH);
            dlg.setDefaultButton(ButtonName.FINISH);
        } else if (step == UpgradeWizardStep.WELCOME) {
            dlg.setDefaultButton(ButtonName.NEXT);
            dlg.setFocusOnButton(ButtonName.NEXT);
        } else if (step == UpgradeWizardStep.PROGRESS || step == UpgradeWizardStep.FINISHED) {
            dlg.setDefaultButton(ButtonName.CLOSE);
            dlg.setFocusOnButton(ButtonName.CLOSE);
        }
    }

    public RemoteBuildManager getRemoteBuildManager() {
        if (this.remoteBuildManager == null) {
            try {
                String listUrlString = System.getProperty("org.opends.quicksetup.upgrader.BuildList");
                if (listUrlString == null) {
                    listUrlString = "http://www.opends.org/upgrade-builds";
                }
                URL buildRepo = new URL(listUrlString);
                Proxy proxy = null;
                String proxyHost = System.getProperty("http.proxyHost");
                String proxyPort = System.getProperty("http.proxyPort");
                if (proxyHost != null && proxyPort != null) {
                    try {
                        InetSocketAddress addr = new InetSocketAddress(proxyHost, (int)new Integer(proxyPort));
                        proxy = new Proxy(Proxy.Type.HTTP, addr);
                    }
                    catch (NumberFormatException nfe) {
                        LOG.log(Level.INFO, "Illegal proxy port number " + proxyPort);
                    }
                }
                this.remoteBuildManager = new RemoteBuildManager(this, buildRepo, proxy);
            }
            catch (MalformedURLException e) {
                LOG.log(Level.INFO, "", e);
            }
        }
        return this.remoteBuildManager;
    }

    @Override
    public int getExtraDialogHeight() {
        return 177;
    }

    @Override
    public String getInstallationPath() {
        String path;
        String installationPath = System.getProperty("INSTALL_ROOT");
        if (installationPath == null && (path = Utils.getInstallPathFromClasspath()) != null) {
            File f = new File(path);
            installationPath = f.getParentFile() != null && f.getParentFile().getParentFile() != null && new File(f.getParentFile().getParentFile(), "locks").exists() ? Utils.getPath(f.getParentFile().getParentFile()) : path;
        }
        return installationPath;
    }

    @Override
    public String getInstancePath() {
        String installPath = this.getInstallationPath();
        if (installPath == null) {
            return null;
        }
        return Utils.getInstancePathFromClasspath(installPath);
    }

    @Override
    public ProgressStep getCurrentProgressStep() {
        return this.currentProgressStep;
    }

    @Override
    public Integer getRatio(ProgressStep step) {
        return ((UpgradeProgressStep)step).getProgress();
    }

    @Override
    public Message getSummary(ProgressStep step) {
        Message txt = step == UpgradeProgressStep.FINISHED ? this.getFinalSuccessMessage() : (step == UpgradeProgressStep.FINISHED_CANCELED ? this.getFinalCanceledMessage() : (step == UpgradeProgressStep.FINISHED_WITH_ERRORS ? this.getFinalErrorMessage() : (step == UpgradeProgressStep.FINISHED_WITH_WARNINGS ? this.getFinalWarningMessage() : ((UpgradeProgressStep)step).getSummaryMessage())));
        return txt;
    }

    @Override
    public void windowClosing(QuickSetupDialog dlg, WindowEvent evt) {
        if (dlg.getDisplayedStep() == UpgradeWizardStep.PROGRESS || dlg.getDisplayedStep() == UpgradeWizardStep.FINISHED) {
            dlg.notifyButtonEvent(ButtonName.CLOSE);
        } else {
            dlg.notifyButtonEvent(ButtonName.QUIT);
        }
    }

    private Message getLogMsg(UpgradeProgressStep step) {
        Message txt = step == UpgradeProgressStep.FINISHED ? this.getFinalSuccessMessage() : (step == UpgradeProgressStep.FINISHED_CANCELED ? this.getFinalCanceledMessage() : (step == UpgradeProgressStep.FINISHED_WITH_ERRORS ? this.getFinalErrorMessage() : (step == UpgradeProgressStep.FINISHED_WITH_WARNINGS ? this.getFinalWarningMessage() : step.getLogMsg(this.isVerbose()))));
        return txt;
    }

    @Override
    public ButtonName getInitialFocusButtonName() {
        return null;
    }

    @Override
    public Set<? extends WizardStep> getWizardSteps() {
        return Collections.unmodifiableSet(EnumSet.allOf(UpgradeWizardStep.class));
    }

    @Override
    public QuickSetupStepPanel createWizardStepPanel(WizardStep step) {
        QuickSetupStepPanel pnl = null;
        if (UpgradeWizardStep.WELCOME.equals(step)) {
            pnl = new WelcomePanel(this);
        } else if (UpgradeWizardStep.REVIEW.equals(step)) {
            pnl = new UpgraderReviewPanel(this);
        } else if (UpgradeWizardStep.PROGRESS.equals(step)) {
            pnl = new ProgressPanel(this);
        } else if (UpgradeWizardStep.FINISHED.equals(step)) {
            pnl = new FinishedPanel(this);
        }
        return pnl;
    }

    @Override
    public WizardStep getNextWizardStep(WizardStep step) {
        UpgradeWizardStep next = null;
        if (UpgradeWizardStep.WELCOME.equals(step)) {
            next = UpgradeWizardStep.REVIEW;
        } else if (UpgradeWizardStep.REVIEW.equals(step)) {
            next = UpgradeWizardStep.PROGRESS;
        } else if (UpgradeWizardStep.PROGRESS.equals(step)) {
            next = UpgradeWizardStep.FINISHED;
        }
        return next;
    }

    @Override
    public WizardStep getPreviousWizardStep(WizardStep step) {
        UpgradeWizardStep prev = null;
        if (UpgradeWizardStep.FINISHED.equals(step)) {
            prev = UpgradeWizardStep.PROGRESS;
        } else if (UpgradeWizardStep.PROGRESS.equals(step)) {
            prev = UpgradeWizardStep.REVIEW;
        } else if (UpgradeWizardStep.REVIEW.equals(step)) {
            prev = UpgradeWizardStep.WELCOME;
        }
        return prev;
    }

    @Override
    public WizardStep getFinishedStep() {
        return UpgradeWizardStep.FINISHED;
    }

    @Override
    public boolean canQuit(WizardStep step) {
        return UpgradeWizardStep.WELCOME == step || UpgradeWizardStep.REVIEW == step;
    }

    @Override
    public Message getFinishButtonToolTip() {
        return QuickSetupMessages.INFO_FINISH_BUTTON_UPGRADE_TOOLTIP.get();
    }

    @Override
    public Message getQuitButtonToolTip() {
        return QuickSetupMessages.INFO_QUIT_BUTTON_UPGRADE_TOOLTIP.get();
    }

    @Override
    public void cancel() {
        this.abort = true;
    }

    @Override
    public boolean confirmCancel(QuickSetup qs) {
        return qs.displayConfirmation(QuickSetupMessages.INFO_CONFIRM_CANCEL_UPGRADE_MSG.get(), QuickSetupMessages.INFO_CONFIRM_CANCEL_UPGRADE_TITLE.get());
    }

    @Override
    public boolean isFinished() {
        return this.getCurrentProgressStep() == UpgradeProgressStep.FINISHED || this.getCurrentProgressStep() == UpgradeProgressStep.FINISHED_WITH_ERRORS || this.getCurrentProgressStep() == UpgradeProgressStep.FINISHED_WITH_WARNINGS || this.getCurrentProgressStep() == UpgradeProgressStep.FINISHED_CANCELED;
    }

    @Override
    public boolean isCancellable() {
        return true;
    }

    @Override
    public void quitClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == UpgradeWizardStep.PROGRESS) {
            throw new IllegalStateException("Cannot click on quit from progress step");
        }
        if (this.isFinished()) {
            qs.quit();
        } else if (qs.displayConfirmation(QuickSetupMessages.INFO_CONFIRM_QUIT_UPGRADE_MSG.get(), QuickSetupMessages.INFO_CONFIRM_QUIT_UPGRADE_TITLE.get())) {
            qs.quit();
        }
    }

    @Override
    public void updateUserData(WizardStep cStep, QuickSetup qs) throws UserDataException {
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        UpgradeUserData uud = this.getUpgradeUserData();
        if (cStep == UpgradeWizardStep.WELCOME) {
            if (Utils.isWebStart()) {
                String serverLocationString = qs.getFieldStringValue(FieldName.SERVER_TO_UPGRADE_LOCATION);
                if (serverLocationString == null || "".equals(serverLocationString.trim())) {
                    errorMsgs.add(QuickSetupMessages.INFO_EMPTY_SERVER_LOCATION.get());
                    qs.displayFieldInvalid(FieldName.SERVER_TO_UPGRADE_LOCATION, true);
                } else {
                    try {
                        block12: {
                            File serverLocation = new File(serverLocationString);
                            Installation.validateRootDirectory(serverLocation);
                            Installation currentInstallation = this.getInstallation();
                            if (currentInstallation == null || !serverLocation.equals(this.getInstallation().getRootDirectory())) {
                                LOG.log(Level.INFO, "user changed server root from " + (currentInstallation == null ? "'null'" : currentInstallation.getRootDirectory()) + " to " + serverLocation);
                                Installation installation = new Installation(serverLocation, serverLocation);
                                this.setInstallation(installation);
                                try {
                                    installation.getBuildInformation(true);
                                }
                                catch (ApplicationException ae) {
                                    if (!ae.getMessageObject().getDescriptor().equals(QuickSetupMessages.INFO_ERROR_CREATING_BUILD_INFO_MSG) || ae.getMessageObject().toString().indexOf("OPENDS_JAVA_HOME") == -1) break block12;
                                    String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                                    String setJavaHome = installation.getSetJavaHomeFile().getAbsolutePath();
                                    String dsJavaProperties = installation.getJavaPropertiesCommandFile().getAbsolutePath();
                                    errorMsgs.add(QuickSetupMessages.ERR_INVALID_JAVA_ARGS.get(serverLocationString, javaBin, setJavaHome, dsJavaProperties));
                                }
                            }
                        }
                        uud.setServerLocation(serverLocationString);
                        qs.displayFieldInvalid(FieldName.SERVER_TO_UPGRADE_LOCATION, false);
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.log(Level.INFO, "illegal OpenDS installation directory selected", iae);
                        errorMsgs.add(QuickSetupMessages.INFO_ERROR_INVALID_SERVER_LOCATION.get(serverLocationString));
                        qs.displayFieldInvalid(FieldName.SERVER_TO_UPGRADE_LOCATION, true);
                    }
                }
            }
        } else if (cStep == UpgradeWizardStep.REVIEW) {
            Boolean startServer = (Boolean)qs.getFieldValue(FieldName.SERVER_START_UPGRADER);
            uud.setStartServer(startServer);
        }
        if (errorMsgs.size() > 0) {
            throw new UserDataException(UpgradeWizardStep.WELCOME, Utils.getMessageFromCollection(errorMsgs, "\n"));
        }
    }

    @Override
    public void previousClicked(WizardStep cStep, QuickSetup qs) {
    }

    @Override
    public boolean finishClicked(WizardStep cStep, QuickSetup qs) {
        return true;
    }

    @Override
    public void nextClicked(WizardStep cStep, QuickSetup qs) {
    }

    @Override
    public boolean canFinish(WizardStep step) {
        return UpgradeWizardStep.REVIEW.equals(step);
    }

    @Override
    public boolean canGoBack(WizardStep step) {
        return super.canGoBack(step) && !step.equals(UpgradeWizardStep.PROGRESS) && !step.equals(UpgradeWizardStep.FINISHED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block182: {
            List<Message> errors;
            this.runError = null;
            if (Utils.isWebStart()) {
                ZipExtractor extractor;
                this.setCurrentProgressStep(UpgradeProgressStep.DOWNLOADING);
                try {
                    LOG.log(Level.INFO, "Waiting for Java Web Start jar download");
                    this.waitForLoader(UpgradeProgressStep.EXTRACTING.getProgress());
                    LOG.log(Level.INFO, "Downloaded build file");
                    String zipName = WebStartDownloader.getZipFileName();
                    InputStream in = Upgrader.class.getClassLoader().getResourceAsStream(zipName);
                    extractor = new ZipExtractor(in, UpgradeProgressStep.EXTRACTING.getProgress(), UpgradeProgressStep.INITIALIZING.getProgress(), Utils.getNumberZipEntries(), zipName, this);
                }
                catch (ApplicationException e) {
                    LOG.log(Level.SEVERE, "Error downloading Web Start jars", e);
                    throw e;
                }
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                this.checkAbort();
                try {
                    this.setCurrentProgressStep(UpgradeProgressStep.EXTRACTING);
                    if (this.isVerbose()) {
                        this.notifyListeners(this.getLineBreak());
                    }
                    extractor.extract(this.getStageDirectory());
                    if (!this.isVerbose()) {
                        this.notifyListeners(this.getFormattedDoneWithLineBreak());
                    } else {
                        this.notifyListeners(this.getLineBreak());
                    }
                    LOG.log(Level.INFO, "extraction finished");
                }
                catch (ApplicationException e) {
                    LOG.log(Level.INFO, "Error extracting build file", e);
                    throw e;
                }
            }
            this.checkAbort();
            if (!LicenseFile.isAlreadyApproved()) {
                String currentInstallRoot = System.getProperty("INSTALL_ROOT");
                System.setProperty("INSTALL_ROOT", this.getStageDirectory().getAbsolutePath());
                if (LicenseFile.exists()) {
                    String licenseString = LicenseFile.getText();
                    System.out.println(licenseString);
                    if (this.getUserData().isInteractive()) {
                        String yes = QuickSetupMessages.INFO_LICENSE_CLI_ACCEPT_YES.get().toString();
                        String no = QuickSetupMessages.INFO_LICENSE_CLI_ACCEPT_NO.get().toString();
                        System.out.println(QuickSetupMessages.INFO_LICENSE_DETAILS_LABEL.get().toString());
                        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                        while (true) {
                            System.out.print(QuickSetupMessages.INFO_LICENSE_CLI_ACCEPT_QUESTION.get(yes, no, no).toString());
                            try {
                                String response = in.readLine();
                                if (response == null || response.toLowerCase().equals(no.toLowerCase()) || response.length() == 0) {
                                    System.exit(ReturnCode.CANCELLED.getReturnCode());
                                    continue;
                                }
                                if (response.toLowerCase().equals(yes.toLowerCase())) {
                                    LicenseFile.setApproval(true);
                                    LicenseFile.createFileLicenseApproved();
                                    break;
                                }
                                System.out.println(QuickSetupMessages.INFO_LICENSE_CLI_ACCEPT_INVALID_RESPONSE.get().toString());
                            }
                            catch (IOException e) {
                                System.out.println(QuickSetupMessages.INFO_LICENSE_CLI_ACCEPT_INVALID_RESPONSE.get().toString());
                            }
                        }
                    }
                }
                if (currentInstallRoot != null) {
                    System.setProperty("INSTALL_ROOT", currentInstallRoot);
                } else {
                    System.clearProperty("INSTALL_ROOT");
                }
            }
            if (!Utils.isWebStart()) {
                this.getUserData().setStartServer(this.getInstallation().getStatus().isServerRunning());
            }
            try {
                LOG.log(Level.INFO, "initializing upgrade");
                this.setCurrentProgressStep(UpgradeProgressStep.INITIALIZING);
                this.initialize();
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                LOG.log(Level.INFO, "initialization finished");
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "Error initializing upgrader", e);
                throw e;
            }
            this.checkAbort();
            MigrationManager migration = new MigrationManager(this.getInstallation(), this.getUpgradeBackupDirectory(), this.userInteraction());
            try {
                LOG.log(Level.INFO, "checking for schema customizations");
                this.setCurrentProgressStep(UpgradeProgressStep.CALCULATING_SCHEMA_CUSTOMIZATIONS);
                migration.calculateSchemaCustomizations();
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                LOG.log(Level.INFO, "check for schema customizations finished");
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "Error calculating schema customizations", e);
                throw e;
            }
            this.checkAbort();
            try {
                LOG.log(Level.INFO, "checking for config customizations");
                this.setCurrentProgressStep(UpgradeProgressStep.CALCULATING_CONFIGURATION_CUSTOMIZATIONS);
                migration.calculateConfigCustomizations();
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                LOG.log(Level.INFO, "check for config customizations finished");
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "Error calculating config customizations", e);
                throw e;
            }
            this.checkAbort();
            if (this.getUpgradeUserData().getPerformDatabaseBackup()) {
                try {
                    LOG.log(Level.INFO, "backing up databases");
                    this.setCurrentProgressStep(UpgradeProgressStep.BACKING_UP_DATABASES);
                    this.backupDatabases();
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                    LOG.log(Level.INFO, "database backup finished");
                }
                catch (ApplicationException e) {
                    LOG.log(Level.INFO, "Error backing up databases", e);
                    throw e;
                }
            }
            this.checkAbort();
            try {
                LOG.log(Level.INFO, "backing up filesystem");
                this.setCurrentProgressStep(UpgradeProgressStep.BACKING_UP_FILESYSTEM);
                this.backupFilesystem();
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                LOG.log(Level.INFO, "filesystem backup finished");
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "Error backing up files", e);
                throw e;
            }
            this.checkAbort();
            try {
                LOG.log(Level.INFO, "upgrading components");
                this.setCurrentProgressStep(UpgradeProgressStep.UPGRADING_COMPONENTS);
                this.upgradeComponents();
                this.updateConfigDirectory();
                this.updateExtensionsDirectory();
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                LOG.log(Level.INFO, "component upgrade finished");
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "Error upgrading components", e);
                throw e;
            }
            this.checkAbort();
            LOG.log(Level.INFO, "schema customization " + (migration.isSchemaCustomized() ? "" : "not ") + "present");
            LOG.log(Level.INFO, "config customization " + (migration.isConfigurationCustomized() ? "" : "not ") + "present");
            if (migration.isSchemaCustomized() || migration.isConfigurationCustomized()) {
                try {
                    LOG.log(Level.INFO, "starting server");
                    this.setCurrentProgressStep(UpgradeProgressStep.PREPARING_CUSTOMIZATIONS);
                    InProcessServerController ipsc = new InProcessServerController(this.getInstallation());
                    InProcessServerController.disableConnectionHandlers(true);
                    InProcessServerController.disableAdminDataSynchronization(true);
                    InProcessServerController.disableSynchronization(true);
                    ipsc.startServer();
                    LOG.log(Level.INFO, "start server finished");
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Error starting server in order to apply customschema and/or configuration", e);
                    throw new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.INFO_ERROR_STARTING_SERVER.get(), e);
                }
                this.checkAbort();
                if (migration.isSchemaCustomized()) {
                    try {
                        LOG.log(Level.INFO, "Applying schema customizations");
                        this.setCurrentProgressStep(UpgradeProgressStep.APPLYING_SCHEMA_CUSTOMIZATIONS);
                        migration.migrateSchema();
                        this.notifyListeners(this.getFormattedDoneWithLineBreak());
                        LOG.log(Level.INFO, "custom schema application finished");
                    }
                    catch (ApplicationException e) {
                        LOG.log(Level.INFO, "Error applying schema customizations", e);
                        throw e;
                    }
                }
                this.checkAbort();
                if (migration.isConfigurationCustomized()) {
                    try {
                        LOG.log(Level.INFO, "Applying config customizations");
                        this.setCurrentProgressStep(UpgradeProgressStep.APPLYING_CONFIGURATION_CUSTOMIZATIONS);
                        migration.migrateConfiguration();
                        this.notifyListeners(this.getFormattedDoneWithLineBreak());
                        LOG.log(Level.INFO, "custom config application finished");
                    }
                    catch (ApplicationException e) {
                        LOG.log(Level.INFO, "Error applying configuration customizations", e);
                        throw e;
                    }
                }
                this.checkAbort();
                if (migration.mustMigrateADS()) {
                    try {
                        LOG.log(Level.INFO, "Applying registration changes");
                        if (this.isVerbose()) {
                            this.setCurrentProgressStep(UpgradeProgressStep.APPLYING_ADS_CUSTOMIZATIONS);
                        }
                        migration.migrateADS(this.getStagedInstallation().getADSBackendFile());
                        if (this.isVerbose()) {
                            this.notifyListeners(this.getFormattedDone());
                        }
                        LOG.log(Level.INFO, "custom registration application finished");
                    }
                    catch (ApplicationException e) {
                        LOG.log(Level.INFO, "Error applying registration customizations", e);
                        throw e;
                    }
                }
                this.checkAbort();
                if (migration.mustMigrateToolProperties()) {
                    try {
                        LOG.log(Level.INFO, "Applying tools properties");
                        migration.migrateToolPropertiesFile(this.getStagedInstallation().getToolsPropertiesFile());
                        LOG.log(Level.INFO, "tools properties application finished");
                    }
                    catch (ApplicationException e) {
                        LOG.log(Level.INFO, "Error applying tools properties changes", e);
                        throw e;
                    }
                }
                if (migration.mustRunDSJavaProperties()) {
                    try {
                        LOG.log(Level.INFO, "Upgrading script with java properties");
                        String propertiesFile = new File(this.getInstallation().getConfigurationDirectory(), "java.properties").getAbsolutePath();
                        String setJavaFile = this.getInstallation().getSetJavaHomeFile().getAbsolutePath();
                        String[] args = new String[]{"--propertiesFile", propertiesFile, "--destinationFile", setJavaFile, "--quiet"};
                        int returnValue = JavaPropertiesTool.mainCLI(args);
                        if (returnValue != JavaPropertiesTool.ErrorReturnCode.SUCCESSFUL.getReturnCode() && returnValue != JavaPropertiesTool.ErrorReturnCode.SUCCESSFUL_NOP.getReturnCode()) {
                            throw new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.ERR_ERROR_CREATING_JAVA_HOME_SCRIPTS.get(returnValue), null);
                        }
                        LOG.log(Level.INFO, "scripts successfully upgraded");
                    }
                    catch (ApplicationException e) {
                        LOG.log(Level.INFO, "Error upgrading scripts", e);
                        throw e;
                    }
                }
                this.checkAbort();
                try {
                    LOG.log(Level.INFO, "stopping server");
                    if (this.isVerbose()) {
                        this.notifyListeners(QuickSetupMessages.INFO_PROGRESS_UPGRADE_INTERNAL_STOP.get());
                    }
                    new InProcessServerController(this.getInstallation()).stopServer();
                    InProcessServerController.disableConnectionHandlers(false);
                    if (this.isVerbose()) {
                        this.notifyListeners(this.getFormattedDone());
                    }
                    LOG.log(Level.INFO, "server stopped");
                }
                catch (Throwable t) {
                    LOG.log(Level.INFO, "Error stopping server", t);
                    throw new ApplicationException(ReturnCode.BUG, QuickSetupMessages.INFO_ERROR_STOPPING_SERVER.get(), t);
                }
            }
            this.checkAbort();
            if ("true".equals(System.getProperty(SYS_PROP_CREATE_ERROR))) {
                LOG.log(Level.WARNING, "creating artificial error");
                throw new ApplicationException(null, QuickSetupMessages.INFO_ERROR_ARTIFICIAL.get(), null);
            }
            try {
                LOG.log(Level.INFO, "verifying upgrade");
                this.setCurrentProgressStep(UpgradeProgressStep.VERIFYING);
                Installation installation = this.getInstallation();
                ServerHealthChecker healthChecker = new ServerHealthChecker(installation);
                healthChecker.checkServer();
                errors = healthChecker.getProblemMessages();
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "error performing server health check", e);
                throw e;
            }
            if ("true".equals(System.getProperty(SYS_PROP_CREATE_VERIFY_ERROR))) {
                LOG.log(Level.WARNING, "creating artificial verification error");
                if (errors == null || errors.size() == 0) {
                    errors = new ArrayList<Message>();
                    errors.add(Message.raw("Artificial verification error for testing", new Object[0]));
                }
            }
            if (errors != null && errors.size() > 0) {
                this.notifyListeners(this.getFormattedErrorWithLineBreak());
                Message formattedDetails = Utils.listToMessage(errors, Constants.LINE_SEPARATOR, "\u2022 ", "");
                ApplicationException ae = new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.INFO_ERROR_UPGRADED_SERVER_STARTS_WITH_ERRORS.get(Constants.LINE_SEPARATOR + formattedDetails), null);
                UserInteraction ui = this.userInteraction();
                if (ui == null) throw ae;
                this.runWarning = ae;
                Message cancel = QuickSetupMessages.INFO_UPGRADE_VERIFICATION_FAILURE_CANCEL.get();
                if (cancel.equals(ui.confirm(QuickSetupMessages.INFO_UPGRADE_VERIFICATION_FAILURE_TITLE.get(), QuickSetupMessages.INFO_UPGRADE_VERIFICATION_FAILURE_PROMPT.get(), formattedDetails, QuickSetupMessages.INFO_UPGRADE_VERIFICATION_FAILURE_TITLE.get(), UserInteraction.MessageType.ERROR, new Message[]{QuickSetupMessages.INFO_CONTINUE_BUTTON_LABEL.get(), cancel}, cancel, QuickSetupMessages.INFO_UPGRADE_VERIFICATION_FAILURE_VIEW_DETAILS.get()))) {
                    this.cancel();
                    this.checkAbort();
                }
            } else {
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
            }
            LOG.log(Level.INFO, "upgrade verification complete");
            try {
                ServerController control = new ServerController(this.getInstallation());
                boolean serverRunning = this.getInstallation().getStatus().isServerRunning();
                boolean userRequestsStart = this.getUserData().getStartServer();
                if (userRequestsStart && !serverRunning) {
                    try {
                        LOG.log(Level.INFO, "starting server");
                        this.setCurrentProgressStep(UpgradeProgressStep.STARTING_SERVER);
                        if (this.isVerbose()) {
                            this.notifyListeners(this.getTaskSeparator());
                        } else {
                            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_STARTING_NON_VERBOSE.get()));
                        }
                        int port = this.getInstallation().getCurrentConfiguration().getPort();
                        if (port != -1 && !Utils.canUseAsPort(port)) {
                            throw new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.INFO_ERROR_PORT_IN_USE.get(Integer.toString(port)), null);
                        }
                        control.startServer(!this.isVerbose());
                        if (!this.isVerbose()) {
                            this.notifyListeners(this.getFormattedDoneWithLineBreak());
                            break block182;
                        }
                        this.notifyListeners(this.getLineBreak());
                    }
                    catch (ApplicationException e) {
                        if (this.isVerbose()) {
                            this.notifyListeners(this.getLineBreak());
                        }
                        this.notifyListeners(this.getFormattedErrorWithLineBreak());
                        LOG.log(Level.INFO, "error starting server");
                        this.runWarning = e;
                    }
                    break block182;
                }
                if (userRequestsStart || !serverRunning) break block182;
                try {
                    LOG.log(Level.INFO, "stopping server");
                    if (this.isVerbose()) {
                        this.notifyListeners(this.getTaskSeparator());
                    } else {
                        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_STOPPING_NON_VERBOSE.get()));
                    }
                    this.setCurrentProgressStep(UpgradeProgressStep.STOPPING_SERVER);
                    control.stopServer(!this.isVerbose());
                    if (!this.isVerbose()) {
                        this.notifyListeners(this.getFormattedDoneWithLineBreak());
                        break block182;
                    }
                    this.notifyListeners(this.getLineBreak());
                }
                catch (ApplicationException e) {
                    if (this.isVerbose()) {
                        this.notifyListeners(this.getLineBreak());
                    }
                    this.notifyListeners(this.getFormattedErrorWithLineBreak());
                    LOG.log(Level.INFO, "error stopping server");
                    this.runWarning = e;
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.INFO, "error determining if server running");
                this.runWarning = new ApplicationException(ReturnCode.TOOL_ERROR, QuickSetupMessages.INFO_ERROR_SERVER_STATUS.get(), ioe);
            }
        }
        Object var8_35 = null;
        try {
            HistoricalRecord.Status status;
            String note = null;
            if (this.runError == null && !this.abort) {
                status = HistoricalRecord.Status.SUCCESS;
                this.backupWindowsUpgradeFile();
            } else {
                if (this.abort) {
                    status = HistoricalRecord.Status.CANCEL;
                } else {
                    status = HistoricalRecord.Status.FAILURE;
                    note = this.runError.getLocalizedMessage();
                }
                if (this.runError != null) {
                    this.notifyListeners(this.getFormattedErrorWithLineBreak());
                    Message msg = this.runError.getCause() != null ? this.getFormattedError(Utils.getThrowableMsg(this.runError.getMessageObject(), this.runError.getCause()), true) : this.getFormattedError(this.runError, true);
                    this.notifyListeners(msg);
                    if (Utils.isCli()) {
                        this.notifyListeners(this.getLineBreak());
                        this.notifyListeners(this.getLineBreak());
                    }
                }
                LOG.log(Level.INFO, "canceling upgrade");
                ProgressStep lastProgressStep = this.getCurrentProgressStep();
                this.setCurrentProgressStep(UpgradeProgressStep.ABORT);
                this.abort(lastProgressStep);
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                LOG.log(Level.INFO, "cancelation complete");
            }
            LOG.log(Level.INFO, "cleaning up after upgrade");
            this.setCurrentProgressStep(UpgradeProgressStep.CLEANUP);
            this.cleanup();
            this.notifyListeners(this.getFormattedDoneWithLineBreak());
            LOG.log(Level.INFO, "clean up complete");
            LOG.log(Level.INFO, "recording upgrade history");
            this.setCurrentProgressStep(UpgradeProgressStep.RECORDING_HISTORY);
            this.writeHistoricalRecord(this.historicalOperationId, this.getCurrentBuildInformation(), this.getStagedBuildInformation(), status, note);
            this.notifyListeners(this.getFormattedDoneWithLineBreak());
            LOG.log(Level.INFO, "history recorded");
            this.notifyListeners(new MessageBuilder().append(QuickSetupMessages.INFO_GENERAL_SEE_FOR_HISTORY.get(Utils.getPath(this.getInstallation().getHistoryLogFile()))).append(this.formatter.getLineBreak()).toMessage());
            try {
                Stage stage = this.getStage();
                List<Message> stageMessages = stage.getMessages();
                for (Message m : stageMessages) {
                    this.notifyListeners(m);
                }
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "failed to access stage", e);
            }
        }
        catch (ApplicationException e) {
            this.notifyListeners(this.getFormattedErrorWithLineBreak());
            Message msg = e.getCause() != null ? this.getFormattedError(Utils.getThrowableMsg(e.getMessageObject(), e.getCause()), true) : this.getFormattedError(e, true);
            this.notifyListeners(msg);
            if (Utils.isCli()) {
                this.notifyListeners(this.getLineBreak());
            }
            LOG.log(Level.INFO, "Error cleaning up after upgrade.", e);
        }
        if (this.abort) {
            LOG.log(Level.INFO, "upgrade canceled by user");
            if (!Utils.isCli()) {
                this.notifyListenersOfLog();
                this.currentProgressStep = UpgradeProgressStep.FINISHED_CANCELED;
                this.notifyListeners(null);
                return;
            } else {
                this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_CANCELED);
                this.notifyListeners(this.getLineBreak());
            }
            return;
        }
        if (this.runError != null) {
            LOG.log(Level.INFO, "upgrade completed with errors", this.runError);
            if (!Utils.isCli()) {
                this.notifyListenersOfLog();
                this.currentProgressStep = UpgradeProgressStep.FINISHED_WITH_ERRORS;
                return;
            } else {
                this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_WITH_ERRORS);
                this.notifyListeners(this.getLineBreak());
            }
            return;
        }
        if (this.runWarning != null) {
            LOG.log(Level.INFO, "upgrade completed with warnings");
            Message warningText = this.runWarning.getMessageObject();
            if (!Utils.isCli()) {
                this.notifyListenersOfLog();
                this.currentProgressStep = UpgradeProgressStep.FINISHED_WITH_WARNINGS;
                this.notifyListeners(this.getFormattedError(warningText, true));
                return;
            } else {
                this.notifyListeners(this.getFormattedErrorWithLineBreak(warningText, true));
                this.notifyListeners(this.getLineBreak());
                this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_WITH_WARNINGS);
                this.notifyListeners(this.getLineBreak());
            }
            return;
        }
        LOG.log(Level.INFO, "upgrade completed successfully");
        if (!Utils.isCli()) {
            this.notifyListenersOfLog();
            this.currentProgressStep = UpgradeProgressStep.FINISHED;
            this.notifyListeners(null);
            return;
        }
        this.setCurrentProgressStep(UpgradeProgressStep.FINISHED);
        this.notifyListeners(this.getLineBreak());
        {
            return;
            catch (ApplicationException ae) {
                if (ae.getType() != ReturnCode.CANCELLED) {
                    this.runError = ae;
                } else {
                    this.abort = true;
                }
                Object var8_36 = null;
                try {
                    HistoricalRecord.Status status;
                    String note = null;
                    if (this.runError == null && !this.abort) {
                        status = HistoricalRecord.Status.SUCCESS;
                        this.backupWindowsUpgradeFile();
                    } else {
                        if (this.abort) {
                            status = HistoricalRecord.Status.CANCEL;
                        } else {
                            status = HistoricalRecord.Status.FAILURE;
                            note = this.runError.getLocalizedMessage();
                        }
                        if (this.runError != null) {
                            this.notifyListeners(this.getFormattedErrorWithLineBreak());
                            Message msg = this.runError.getCause() != null ? this.getFormattedError(Utils.getThrowableMsg(this.runError.getMessageObject(), this.runError.getCause()), true) : this.getFormattedError(this.runError, true);
                            this.notifyListeners(msg);
                            if (Utils.isCli()) {
                                this.notifyListeners(this.getLineBreak());
                                this.notifyListeners(this.getLineBreak());
                            }
                        }
                        LOG.log(Level.INFO, "canceling upgrade");
                        ProgressStep lastProgressStep = this.getCurrentProgressStep();
                        this.setCurrentProgressStep(UpgradeProgressStep.ABORT);
                        this.abort(lastProgressStep);
                        this.notifyListeners(this.getFormattedDoneWithLineBreak());
                        LOG.log(Level.INFO, "cancelation complete");
                    }
                    LOG.log(Level.INFO, "cleaning up after upgrade");
                    this.setCurrentProgressStep(UpgradeProgressStep.CLEANUP);
                    this.cleanup();
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                    LOG.log(Level.INFO, "clean up complete");
                    LOG.log(Level.INFO, "recording upgrade history");
                    this.setCurrentProgressStep(UpgradeProgressStep.RECORDING_HISTORY);
                    this.writeHistoricalRecord(this.historicalOperationId, this.getCurrentBuildInformation(), this.getStagedBuildInformation(), status, note);
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                    LOG.log(Level.INFO, "history recorded");
                    this.notifyListeners(new MessageBuilder().append(QuickSetupMessages.INFO_GENERAL_SEE_FOR_HISTORY.get(Utils.getPath(this.getInstallation().getHistoryLogFile()))).append(this.formatter.getLineBreak()).toMessage());
                    try {
                        Stage stage = this.getStage();
                        List<Message> stageMessages = stage.getMessages();
                        for (Message m : stageMessages) {
                            this.notifyListeners(m);
                        }
                    }
                    catch (IOException e) {
                        LOG.log(Level.INFO, "failed to access stage", e);
                    }
                }
                catch (ApplicationException e) {
                    this.notifyListeners(this.getFormattedErrorWithLineBreak());
                    Message msg = e.getCause() != null ? this.getFormattedError(Utils.getThrowableMsg(e.getMessageObject(), e.getCause()), true) : this.getFormattedError(e, true);
                    this.notifyListeners(msg);
                    if (Utils.isCli()) {
                        this.notifyListeners(this.getLineBreak());
                    }
                    LOG.log(Level.INFO, "Error cleaning up after upgrade.", e);
                }
                if (this.abort) {
                    LOG.log(Level.INFO, "upgrade canceled by user");
                    if (!Utils.isCli()) {
                        this.notifyListenersOfLog();
                        this.currentProgressStep = UpgradeProgressStep.FINISHED_CANCELED;
                        this.notifyListeners(null);
                        return;
                    } else {
                        this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_CANCELED);
                        this.notifyListeners(this.getLineBreak());
                    }
                    return;
                } else if (this.runError != null) {
                    LOG.log(Level.INFO, "upgrade completed with errors", this.runError);
                    if (!Utils.isCli()) {
                        this.notifyListenersOfLog();
                        this.currentProgressStep = UpgradeProgressStep.FINISHED_WITH_ERRORS;
                        return;
                    } else {
                        this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_WITH_ERRORS);
                        this.notifyListeners(this.getLineBreak());
                    }
                    return;
                } else if (this.runWarning != null) {
                    LOG.log(Level.INFO, "upgrade completed with warnings");
                    Message warningText = this.runWarning.getMessageObject();
                    if (!Utils.isCli()) {
                        this.notifyListenersOfLog();
                        this.currentProgressStep = UpgradeProgressStep.FINISHED_WITH_WARNINGS;
                        this.notifyListeners(this.getFormattedError(warningText, true));
                        return;
                    } else {
                        this.notifyListeners(this.getFormattedErrorWithLineBreak(warningText, true));
                        this.notifyListeners(this.getLineBreak());
                        this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_WITH_WARNINGS);
                        this.notifyListeners(this.getLineBreak());
                    }
                    return;
                } else {
                    LOG.log(Level.INFO, "upgrade completed successfully");
                    if (!Utils.isCli()) {
                        this.notifyListenersOfLog();
                        this.currentProgressStep = UpgradeProgressStep.FINISHED;
                        this.notifyListeners(null);
                        return;
                    } else {
                        this.setCurrentProgressStep(UpgradeProgressStep.FINISHED);
                        this.notifyListeners(this.getLineBreak());
                    }
                }
                return;
            }
            catch (Throwable t) {
                this.runError = new ApplicationException(ReturnCode.BUG, QuickSetupMessages.INFO_BUG_MSG.get(), t);
                Object var8_37 = null;
                try {
                    HistoricalRecord.Status status;
                    String note = null;
                    if (this.runError == null && !this.abort) {
                        status = HistoricalRecord.Status.SUCCESS;
                        this.backupWindowsUpgradeFile();
                    } else {
                        if (this.abort) {
                            status = HistoricalRecord.Status.CANCEL;
                        } else {
                            status = HistoricalRecord.Status.FAILURE;
                            note = this.runError.getLocalizedMessage();
                        }
                        if (this.runError != null) {
                            this.notifyListeners(this.getFormattedErrorWithLineBreak());
                            Message msg = this.runError.getCause() != null ? this.getFormattedError(Utils.getThrowableMsg(this.runError.getMessageObject(), this.runError.getCause()), true) : this.getFormattedError(this.runError, true);
                            this.notifyListeners(msg);
                            if (Utils.isCli()) {
                                this.notifyListeners(this.getLineBreak());
                                this.notifyListeners(this.getLineBreak());
                            }
                        }
                        LOG.log(Level.INFO, "canceling upgrade");
                        ProgressStep lastProgressStep = this.getCurrentProgressStep();
                        this.setCurrentProgressStep(UpgradeProgressStep.ABORT);
                        this.abort(lastProgressStep);
                        this.notifyListeners(this.getFormattedDoneWithLineBreak());
                        LOG.log(Level.INFO, "cancelation complete");
                    }
                    LOG.log(Level.INFO, "cleaning up after upgrade");
                    this.setCurrentProgressStep(UpgradeProgressStep.CLEANUP);
                    this.cleanup();
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                    LOG.log(Level.INFO, "clean up complete");
                    LOG.log(Level.INFO, "recording upgrade history");
                    this.setCurrentProgressStep(UpgradeProgressStep.RECORDING_HISTORY);
                    this.writeHistoricalRecord(this.historicalOperationId, this.getCurrentBuildInformation(), this.getStagedBuildInformation(), status, note);
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                    LOG.log(Level.INFO, "history recorded");
                    this.notifyListeners(new MessageBuilder().append(QuickSetupMessages.INFO_GENERAL_SEE_FOR_HISTORY.get(Utils.getPath(this.getInstallation().getHistoryLogFile()))).append(this.formatter.getLineBreak()).toMessage());
                    try {
                        Stage stage = this.getStage();
                        List<Message> stageMessages = stage.getMessages();
                        for (Message m : stageMessages) {
                            this.notifyListeners(m);
                        }
                    }
                    catch (IOException e) {
                        LOG.log(Level.INFO, "failed to access stage", e);
                    }
                }
                catch (ApplicationException e) {
                    this.notifyListeners(this.getFormattedErrorWithLineBreak());
                    Message msg = e.getCause() != null ? this.getFormattedError(Utils.getThrowableMsg(e.getMessageObject(), e.getCause()), true) : this.getFormattedError(e, true);
                    this.notifyListeners(msg);
                    if (Utils.isCli()) {
                        this.notifyListeners(this.getLineBreak());
                    }
                    LOG.log(Level.INFO, "Error cleaning up after upgrade.", e);
                }
                if (this.abort) {
                    LOG.log(Level.INFO, "upgrade canceled by user");
                    if (!Utils.isCli()) {
                        this.notifyListenersOfLog();
                        this.currentProgressStep = UpgradeProgressStep.FINISHED_CANCELED;
                        this.notifyListeners(null);
                        return;
                    } else {
                        this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_CANCELED);
                        this.notifyListeners(this.getLineBreak());
                    }
                    return;
                } else if (this.runError != null) {
                    LOG.log(Level.INFO, "upgrade completed with errors", this.runError);
                    if (!Utils.isCli()) {
                        this.notifyListenersOfLog();
                        this.currentProgressStep = UpgradeProgressStep.FINISHED_WITH_ERRORS;
                        return;
                    } else {
                        this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_WITH_ERRORS);
                        this.notifyListeners(this.getLineBreak());
                    }
                    return;
                } else if (this.runWarning != null) {
                    LOG.log(Level.INFO, "upgrade completed with warnings");
                    Message warningText = this.runWarning.getMessageObject();
                    if (!Utils.isCli()) {
                        this.notifyListenersOfLog();
                        this.currentProgressStep = UpgradeProgressStep.FINISHED_WITH_WARNINGS;
                        this.notifyListeners(this.getFormattedError(warningText, true));
                        return;
                    } else {
                        this.notifyListeners(this.getFormattedErrorWithLineBreak(warningText, true));
                        this.notifyListeners(this.getLineBreak());
                        this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_WITH_WARNINGS);
                        this.notifyListeners(this.getLineBreak());
                    }
                    return;
                } else {
                    LOG.log(Level.INFO, "upgrade completed successfully");
                    if (!Utils.isCli()) {
                        this.notifyListenersOfLog();
                        this.currentProgressStep = UpgradeProgressStep.FINISHED;
                        this.notifyListeners(null);
                        return;
                    } else {
                        this.setCurrentProgressStep(UpgradeProgressStep.FINISHED);
                        this.notifyListeners(this.getLineBreak());
                    }
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_38 = null;
            try {
                HistoricalRecord.Status status;
                String note = null;
                if (this.runError == null && !this.abort) {
                    status = HistoricalRecord.Status.SUCCESS;
                    this.backupWindowsUpgradeFile();
                } else {
                    if (this.abort) {
                        status = HistoricalRecord.Status.CANCEL;
                    } else {
                        status = HistoricalRecord.Status.FAILURE;
                        note = this.runError.getLocalizedMessage();
                    }
                    if (this.runError != null) {
                        this.notifyListeners(this.getFormattedErrorWithLineBreak());
                        Message msg = this.runError.getCause() != null ? this.getFormattedError(Utils.getThrowableMsg(this.runError.getMessageObject(), this.runError.getCause()), true) : this.getFormattedError(this.runError, true);
                        this.notifyListeners(msg);
                        if (Utils.isCli()) {
                            this.notifyListeners(this.getLineBreak());
                            this.notifyListeners(this.getLineBreak());
                        }
                    }
                    LOG.log(Level.INFO, "canceling upgrade");
                    ProgressStep lastProgressStep = this.getCurrentProgressStep();
                    this.setCurrentProgressStep(UpgradeProgressStep.ABORT);
                    this.abort(lastProgressStep);
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                    LOG.log(Level.INFO, "cancelation complete");
                }
                LOG.log(Level.INFO, "cleaning up after upgrade");
                this.setCurrentProgressStep(UpgradeProgressStep.CLEANUP);
                this.cleanup();
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                LOG.log(Level.INFO, "clean up complete");
                LOG.log(Level.INFO, "recording upgrade history");
                this.setCurrentProgressStep(UpgradeProgressStep.RECORDING_HISTORY);
                this.writeHistoricalRecord(this.historicalOperationId, this.getCurrentBuildInformation(), this.getStagedBuildInformation(), status, note);
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                LOG.log(Level.INFO, "history recorded");
                this.notifyListeners(new MessageBuilder().append(QuickSetupMessages.INFO_GENERAL_SEE_FOR_HISTORY.get(Utils.getPath(this.getInstallation().getHistoryLogFile()))).append(this.formatter.getLineBreak()).toMessage());
                try {
                    Stage stage = this.getStage();
                    List<Message> stageMessages = stage.getMessages();
                    for (Message m : stageMessages) {
                        this.notifyListeners(m);
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, "failed to access stage", e);
                }
            }
            catch (ApplicationException e) {
                this.notifyListeners(this.getFormattedErrorWithLineBreak());
                Message msg = e.getCause() != null ? this.getFormattedError(Utils.getThrowableMsg(e.getMessageObject(), e.getCause()), true) : this.getFormattedError(e, true);
                this.notifyListeners(msg);
                if (Utils.isCli()) {
                    this.notifyListeners(this.getLineBreak());
                }
                LOG.log(Level.INFO, "Error cleaning up after upgrade.", e);
            }
            if (this.abort) {
                LOG.log(Level.INFO, "upgrade canceled by user");
                if (!Utils.isCli()) {
                    this.notifyListenersOfLog();
                    this.currentProgressStep = UpgradeProgressStep.FINISHED_CANCELED;
                    this.notifyListeners(null);
                    throw throwable;
                } else {
                    this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_CANCELED);
                    this.notifyListeners(this.getLineBreak());
                }
                throw throwable;
            } else if (this.runError != null) {
                LOG.log(Level.INFO, "upgrade completed with errors", this.runError);
                if (!Utils.isCli()) {
                    this.notifyListenersOfLog();
                    this.currentProgressStep = UpgradeProgressStep.FINISHED_WITH_ERRORS;
                    throw throwable;
                } else {
                    this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_WITH_ERRORS);
                    this.notifyListeners(this.getLineBreak());
                }
                throw throwable;
            } else if (this.runWarning != null) {
                LOG.log(Level.INFO, "upgrade completed with warnings");
                Message warningText = this.runWarning.getMessageObject();
                if (!Utils.isCli()) {
                    this.notifyListenersOfLog();
                    this.currentProgressStep = UpgradeProgressStep.FINISHED_WITH_WARNINGS;
                    this.notifyListeners(this.getFormattedError(warningText, true));
                    throw throwable;
                } else {
                    this.notifyListeners(this.getFormattedErrorWithLineBreak(warningText, true));
                    this.notifyListeners(this.getLineBreak());
                    this.setCurrentProgressStep(UpgradeProgressStep.FINISHED_WITH_WARNINGS);
                    this.notifyListeners(this.getLineBreak());
                }
                throw throwable;
            } else {
                LOG.log(Level.INFO, "upgrade completed successfully");
                if (!Utils.isCli()) {
                    this.notifyListenersOfLog();
                    this.currentProgressStep = UpgradeProgressStep.FINISHED;
                    this.notifyListeners(null);
                    throw throwable;
                } else {
                    this.setCurrentProgressStep(UpgradeProgressStep.FINISHED);
                    this.notifyListeners(this.getLineBreak());
                }
            }
            throw throwable;
        }
    }

    @Override
    public void checkAbort() throws ApplicationException {
        if (this.abort) {
            throw new ApplicationException(ReturnCode.CANCELLED, QuickSetupMessages.INFO_UPGRADE_CANCELED.get(), null);
        }
    }

    private void abort(ProgressStep lastStep) throws ApplicationException {
        if ("true".equals(System.getProperty(SYS_PROP_NO_ABORT))) {
            return;
        }
        UpgradeProgressStep lastUpgradeStep = (UpgradeProgressStep)lastStep;
        EnumSet<UpgradeProgressStep> stepsStarted = EnumSet.range(UpgradeProgressStep.NOT_STARTED, lastUpgradeStep);
        if (stepsStarted.contains(UpgradeProgressStep.BACKING_UP_FILESYSTEM)) {
            File root = this.getInstallation().getRootDirectory();
            try {
                File f;
                File backupDirectory = this.getFilesInstallBackupDirectory();
                FileManager fm = new FileManager();
                boolean restoreError = false;
                for (String fileName : backupDirectory.list()) {
                    f = new File(backupDirectory, fileName);
                    try {
                        fm.move(f, root, null);
                    }
                    catch (Throwable t) {
                        restoreError = true;
                        this.notifyListeners(QuickSetupMessages.INFO_ERROR_RESTORING_FILE.get(Utils.getPath(f), Utils.getPath(root)));
                    }
                }
                if (!restoreError) {
                    fm.deleteRecursively(backupDirectory);
                }
                if (!this.instanceAndInstallInSameDir()) {
                    root = this.getInstallation().getInstanceDirectory();
                    backupDirectory = this.getFilesInstanceBackupDirectory();
                    fm = new FileManager();
                    for (String fileName : backupDirectory.list()) {
                        f = new File(backupDirectory, fileName);
                        try {
                            fm.move(f, root, null);
                        }
                        catch (Throwable t) {
                            restoreError = true;
                            this.notifyListeners(QuickSetupMessages.INFO_ERROR_RESTORING_FILE.get(Utils.getPath(f), Utils.getPath(root)));
                        }
                    }
                    if (!restoreError) {
                        fm.deleteRecursively(backupDirectory);
                    }
                }
                ServerController sc = new ServerController(this.getInstallation());
                sc.stopServer(true);
                sc.startServer(true);
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Error getting backup directory", e);
            }
        }
    }

    protected Stage getStage() throws IOException, ApplicationException {
        if (this.stage == null) {
            this.stage = new Stage(this.getStageDirectory());
        }
        return this.stage;
    }

    protected void upgradeComponents() throws ApplicationException {
        try {
            Stage stage = this.getStage();
            Installation installation = this.getInstallation();
            File root = installation.getRootDirectory();
            if (this.instanceAndInstallInSameDir()) {
                stage.move(root, new UpgradeFileFilter(this.getStageDirectory()));
            } else {
                stage.move(root, new UpgradeFileFilter(this.getStageDirectory(), true));
                root = installation.getInstanceDirectory();
                stage.move(root, new UpgradeFileFilter(this.getStageDirectory(), false));
            }
            File instanceFile = new File(installation.getRootDirectory(), "instance.loc");
            if (!instanceFile.exists()) {
                BufferedWriter instanceLoc = new BufferedWriter(new FileWriter(instanceFile));
                instanceLoc.append(installation.getInstanceDirectory().getAbsolutePath());
                instanceLoc.close();
            }
            LOG.log(Level.INFO, "upgraded bits to " + installation.getBuildInformation(false));
        }
        catch (IOException e) {
            throw ApplicationException.createFileSystemException(QuickSetupMessages.INFO_ERROR_UPGRADING_COMPONENTS.get(), e);
        }
    }

    private void updateConfigDirectory() throws IOException, ApplicationException {
        File oldInstallConfigDir = new File(this.getFilesInstallBackupDirectory(), "config");
        File oldInstanceConfigDir = new File(this.getFilesInstanceBackupDirectory(), "config");
        File newInstallConfigDir = this.getInstallation().getInstallConfigurationDirectory();
        File newInstanceConfigDir = this.getInstallation().getConfigurationDirectory();
        FileManager fm = new FileManager();
        final File oldConfigUpgradeDir = new File(oldInstallConfigDir, "upgrade");
        final File oldConfigSchemaDir = new File(oldInstallConfigDir, "schema");
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                return !Utils.isDescendant(f, oldConfigUpgradeDir) && !Utils.isDescendant(f, oldConfigSchemaDir);
            }
        };
        fm.synchronize(oldInstallConfigDir, newInstallConfigDir, filter);
        oldConfigUpgradeDir = new File(oldInstanceConfigDir, "upgrade");
        FileFilter filter2 = new FileFilter(){

            public boolean accept(File f) {
                return !Utils.isDescendant(f, oldConfigUpgradeDir);
            }
        };
        fm.synchronize(oldInstanceConfigDir, newInstanceConfigDir, filter2);
    }

    private void updateExtensionsDirectory() throws IOException, ApplicationException {
        File savedDir = new File(this.getFilesInstanceBackupDirectory(), "lib");
        File destDir = this.getInstallation().getInstanceDirectory();
        FileManager fm = new FileManager();
        fm.copyRecursively(savedDir, destDir);
        savedDir = new File(this.getFilesInstanceBackupDirectory(), "classes");
        destDir = this.getInstallation().getInstanceDirectory();
        fm.copyRecursively(savedDir, destDir);
    }

    protected void backupFilesystem() throws ApplicationException {
        try {
            File f;
            File filesBackupDirectory = this.getFilesInstallBackupDirectory();
            FileManager fm = new FileManager();
            File root = this.getInstallation().getRootDirectory();
            UpgradeFileFilter filter = new UpgradeFileFilter(root);
            for (String fileName : root.list()) {
                f = new File(root, fileName);
                if (Utils.isWindows() && fileName.equals("upgrade.bat")) continue;
                fm.move(f, filesBackupDirectory, filter);
            }
            if (!this.instanceAndInstallInSameDir()) {
                filesBackupDirectory = this.getFilesInstanceBackupDirectory();
                root = this.getInstallation().getInstanceDirectory();
                filter = new UpgradeFileFilter(root);
                for (String fileName : root.list()) {
                    f = new File(root, fileName);
                    if (Utils.isWindows() && fileName.equals("upgrade.bat")) continue;
                    fm.move(f, filesBackupDirectory, filter);
                }
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ApplicationException(ReturnCode.FILE_SYSTEM_ACCESS_ERROR, QuickSetupMessages.INFO_ERROR_BACKUP_FILESYSTEM.get(), e);
        }
    }

    private void backupWindowsUpgradeFile() throws ApplicationException {
        try {
            if (Utils.isWindows()) {
                File filesBackupDirectory = this.getFilesInstallBackupDirectory();
                FileManager fm = new FileManager();
                File root = this.getInstallation().getRootDirectory();
                File f = new File(root, "upgrade.bat");
                fm.copy(f, filesBackupDirectory);
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ApplicationException(ReturnCode.FILE_SYSTEM_ACCESS_ERROR, QuickSetupMessages.INFO_ERROR_BACKUP_FILESYSTEM.get(), e);
        }
    }

    private void backupDatabases() throws ApplicationException {
        try {
            ExternalTools et = new ExternalTools(this.getInstallation());
            OperationOutput output = et.backup(this.getUpgradeBackupDirectory());
            int ret = output.getReturnCode();
            if (ret != 0) {
                throw new ApplicationException(ReturnCode.TOOL_ERROR, QuickSetupMessages.INFO_ERROR_BACKUP_DB_TOOL_RETURN_CODE.get(Integer.toString(ret)), null);
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ApplicationException(ReturnCode.TOOL_ERROR, QuickSetupMessages.INFO_ERROR_BACKUP_DB.get(), e);
        }
    }

    protected void cleanup() throws ApplicationException {
        this.deleteStagingDirectory();
    }

    private void deleteStagingDirectory() throws ApplicationException {
        File stagingDir = null;
        try {
            stagingDir = this.getStageDirectory();
            FileManager fm = new FileManager();
            if (stagingDir.exists()) {
                fm.deleteRecursively(stagingDir, null, FileManager.DeletionPolicy.DELETE_ON_EXIT_IF_UNSUCCESSFUL);
            }
        }
        catch (IOException e) {
            throw ApplicationException.createFileSystemException(QuickSetupMessages.INFO_ERROR_DELETING_STAGE_DIRECTORY.get(Utils.getPath(stagingDir)), e);
        }
    }

    protected void initialize() throws ApplicationException {
        try {
            BuildInformation fromVersion = this.getCurrentInstanceBuildInformation();
            BuildInformation toVersion = this.getStagedBuildInformation();
            if (fromVersion.equals(toVersion)) {
                String fromProductName = this.getCurrentBuildInformation().getName();
                String toProductName = toVersion.getName();
                LOG.log(Level.FINEST, "fromProductName=" + fromProductName);
                LOG.log(Level.FINEST, "toProductName=" + toProductName);
                if (fromProductName != null && toProductName != null && fromProductName.equals(toProductName)) {
                    throw new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.INFO_UPGRADE_ORACLE_SAME_VERSION.get(toVersion.toString()), null);
                }
            }
            if (this.getInstallation().getStatus().isServerRunning()) {
                new ServerController(this.getInstallation()).stopServer(true);
            }
            this.historicalOperationId = this.writeInitialHistoricalRecord(fromVersion, toVersion);
            this.insureUpgradability();
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ApplicationException(ReturnCode.FILE_SYSTEM_ACCESS_ERROR, QuickSetupMessages.INFO_ERROR_INITIALIZING_UPGRADE.get(), e);
        }
    }

    private void insureUpgradability() throws ApplicationException {
        BuildInformation newVersion;
        this.currentVersion = this.getCurrentInstanceBuildInformation();
        try {
            newVersion = this.getStagedInstallation().getBuildInformation();
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "error getting build information for staged installation", e);
            throw ApplicationException.createFileSystemException(QuickSetupMessages.INFO_ERROR_DETERMINING_UPGRADE_BUILD.get(), e);
        }
        UpgradeIssueNotifier uo = new UpgradeIssueNotifier(this.userInteraction(), this.currentVersion, newVersion);
        uo.notifyUser();
        if (uo.noServerStartFollowingOperation()) {
            this.getUserData().setStartServer(false);
        }
    }

    protected Installation getStagedInstallation() throws IOException, ApplicationException {
        if (this.stagedInstallation == null) {
            File stageDir = this.getStageDirectory();
            try {
                Installation.validateRootDirectory(stageDir);
                this.stagedInstallation = new Installation(this.getStageDirectory(), this.getStageDirectory());
            }
            catch (IllegalArgumentException e) {
                Message msg = QuickSetupMessages.INFO_ERROR_BAD_STAGE_DIRECTORY.get(Utils.getPath(this.getStageDirectory()));
                throw ApplicationException.createFileSystemException(msg, e);
            }
        }
        return this.stagedInstallation;
    }

    @Override
    public UserData createUserData() {
        UpgradeUserData uud = new UpgradeUserData();
        String instanceRootFromSystem = System.getProperty(SYS_PROP_INSTALL_ROOT);
        if (instanceRootFromSystem != null) {
            uud.setServerLocation(instanceRootFromSystem);
        }
        return uud;
    }

    @Override
    public UserData createUserData(Launcher launcher) throws UserDataException {
        return new UpgraderCliHelper((UpgradeLauncher)launcher).createUserData(launcher.getArguments());
    }

    @Override
    public ApplicationException getRunError() {
        return this.runError;
    }

    @Override
    public ReturnCode getReturnCode() {
        return null;
    }

    private void setCurrentProgressStep(UpgradeProgressStep step) {
        this.currentProgressStep = step;
        int progress = step.getProgress();
        Message msg = this.getSummary(step);
        Message log = this.getLogMsg(step);
        if (step.logRequiresPoints(this.isVerbose()) && log != null) {
            log = this.getFormattedWithPoints(log);
        }
        this.notifyListeners(progress, msg, log);
    }

    private Message getFinalSuccessMessage() {
        String newVersion;
        String installPath = Utils.getPath(this.getInstallation().getRootDirectory());
        try {
            BuildInformation bi = this.getInstallation().getBuildInformation();
            newVersion = bi != null ? bi.toString() : QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get().toString();
        }
        catch (ApplicationException e) {
            newVersion = QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get().toString();
        }
        Message txt = Utils.isCli() ? QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_SUCCESSFULLY_CLI.get(this.formatter.getFormattedText(Message.raw(installPath, new Object[0])), newVersion) : this.getFormattedSuccess(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_SUCCESSFULLY.get(this.formatter.getFormattedText(Message.raw(installPath, new Object[0])), newVersion));
        return txt;
    }

    private Message getFinalCanceledMessage() {
        Message txt = Utils.isCli() ? QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_CANCELED_CLI.get() : this.getFormattedSuccess(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_CANCELED.get());
        return txt;
    }

    private Message getFinalErrorMessage() {
        Message txt = Utils.isCli() ? QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_WITH_ERRORS_CLI.get() : this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_WITH_ERRORS.get());
        return txt;
    }

    private Message getFinalWarningMessage() {
        Message txt = Utils.isCli() ? QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_WITH_WARNINGS_CLI.get() : this.getFormattedWarning(QuickSetupMessages.INFO_SUMMARY_UPGRADE_FINISHED_WITH_WARNINGS.get());
        return txt;
    }

    protected File getStageDirectory() throws ApplicationException, IOException {
        return this.getInstallation().getTemporaryUpgradeDirectory();
    }

    private UpgradeUserData getUpgradeUserData() {
        return (UpgradeUserData)this.getUserData();
    }

    private boolean instanceAndInstallInSameDir() {
        Installation installation = this.getInstallation();
        File installDir = installation.getRootDirectory();
        try {
            installDir = installDir.getCanonicalFile();
        }
        catch (Exception e) {
            installDir = installation.getRootDirectory();
        }
        File instanceDir = installation.getInstanceDirectory();
        try {
            instanceDir = instanceDir.getCanonicalFile();
        }
        catch (Exception e) {
            instanceDir = installation.getInstanceDirectory();
        }
        return installDir.getAbsolutePath().equals(instanceDir.getAbsolutePath());
    }

    protected File getFilesInstanceBackupDirectory() throws IOException {
        if (this.instanceAndInstallInSameDir()) {
            return this.getFilesBackupDirectory();
        }
        return new File(this.getFilesBackupDirectory(), "instance");
    }

    private File getFilesInstallBackupDirectory() throws IOException {
        if (this.instanceAndInstallInSameDir()) {
            return this.getFilesBackupDirectory();
        }
        return new File(this.getFilesBackupDirectory(), "install");
    }

    private File getFilesBackupDirectory() throws IOException {
        File files = new File(this.getUpgradeBackupDirectory(), "files");
        if (!files.exists() && !files.mkdirs()) {
            throw new IOException("error creating files backup directory");
        }
        if (!this.instanceAndInstallInSameDir()) {
            File install = new File(files, "install");
            if (!install.exists() && !install.mkdirs()) {
                throw new IOException("error creating files backup directory");
            }
            File instance = new File(files, "instance");
            if (!instance.exists() && !instance.mkdirs()) {
                throw new IOException("error creating files backup directory");
            }
        }
        return files;
    }

    private File getUpgradeBackupDirectory() throws IOException {
        if (this.backupDirectory == null) {
            this.backupDirectory = this.getInstallation().createHistoryBackupDirectory();
        }
        return this.backupDirectory;
    }

    private BuildInformation getCurrentBuildInformation() {
        if (this.currentVersion == null) {
            try {
                this.currentVersion = this.getInstallation().getBuildInformation();
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "error trying to determine current version", e);
            }
        }
        return this.currentVersion;
    }

    private BuildInformation getCurrentInstanceBuildInformation() {
        if (this.currentInstanceVersion == null) {
            this.currentInstanceVersion = this.getInstallation().getInstanceBuildInformation();
        }
        return this.currentInstanceVersion;
    }

    private BuildInformation getStagedBuildInformation() {
        if (this.stagedVersion == null) {
            try {
                this.stagedVersion = this.getStagedInstallation().getBuildInformation();
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "error getting build info for staged installation", e);
            }
        }
        return this.stagedVersion;
    }
}

