/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.EnumSet;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.admin.SizeUnit;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SizePropertyDefinition
extends PropertyDefinition<Long> {
    private static final String UNLIMITED = "unlimited";
    private final long lowerLimit;
    private final Long upperLimit;
    private final boolean allowUnlimited;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private SizePropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Long> defaultBehavior, Long lowerLimit, Long upperLimit, boolean allowUnlimited) {
        super(d, Long.class, propertyName, options, adminAction, defaultBehavior);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.allowUnlimited = allowUnlimited;
    }

    public long getLowerLimit() {
        return this.lowerLimit;
    }

    public Long getUpperLimit() {
        return this.upperLimit;
    }

    public boolean isAllowUnlimited() {
        return this.allowUnlimited;
    }

    @Override
    public void validateValue(Long value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
        if (!this.allowUnlimited && value < this.lowerLimit) {
            throw new IllegalPropertyValueException(this, value);
        }
        if (value >= 0L && value < this.lowerLimit) {
            throw new IllegalPropertyValueException(this, value);
        }
        if (this.upperLimit != null && value > this.upperLimit) {
            throw new IllegalPropertyValueException(this, value);
        }
    }

    @Override
    public String encodeValue(Long value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
        if (this.allowUnlimited && value < 0L) {
            return UNLIMITED;
        }
        StringBuilder builder = new StringBuilder();
        SizeUnit unit = SizeUnit.getBestFitUnitExact(value);
        builder.append((long)unit.fromBytes(value));
        builder.append(' ');
        builder.append(unit.toString());
        return builder.toString();
    }

    @Override
    public Long decodeValue(String value) throws IllegalPropertyValueStringException {
        Long i;
        Validator.ensureNotNull(value);
        if (this.allowUnlimited && value.trim().equalsIgnoreCase(UNLIMITED)) {
            return -1L;
        }
        try {
            i = SizeUnit.parseValue(value, SizeUnit.BYTES);
        }
        catch (NumberFormatException e) {
            throw new IllegalPropertyValueStringException(this, value);
        }
        try {
            this.validateValue(i);
        }
        catch (IllegalPropertyValueException e) {
            throw new IllegalPropertyValueStringException(this, value);
        }
        return i;
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitSize(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, Long value, P p) {
        return v.visitSize(this, value, p);
    }

    @Override
    public void toString(StringBuilder builder) {
        super.toString(builder);
        builder.append(" lowerLimit=");
        builder.append(this.lowerLimit);
        if (this.upperLimit != null) {
            builder.append(" upperLimit=");
            builder.append(this.upperLimit);
        }
        builder.append(" allowUnlimited=");
        builder.append(this.allowUnlimited);
    }

    @Override
    public int compare(Long o1, Long o2) {
        return o1.compareTo(o2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends PropertyDefinition.AbstractBuilder<Long, SizePropertyDefinition> {
        private long lowerLimit = 0L;
        private Long upperLimit = null;
        private boolean allowUnlimited = false;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void setLowerLimit(long lowerLimit) throws IllegalArgumentException {
            if (lowerLimit < 0L) {
                throw new IllegalArgumentException("Negative lower limit");
            }
            if (this.upperLimit != null && lowerLimit > this.upperLimit) {
                throw new IllegalArgumentException("Lower limit greater than upper limit");
            }
            this.lowerLimit = lowerLimit;
        }

        public final void setLowerLimit(String lowerLimit) throws IllegalArgumentException {
            this.setLowerLimit(SizeUnit.parseValue(lowerLimit, SizeUnit.BYTES));
        }

        public final void setUpperLimit(Long upperLimit) throws IllegalArgumentException {
            if (upperLimit != null) {
                if (upperLimit < 0L) {
                    throw new IllegalArgumentException("Negative upper limit");
                }
                if (this.lowerLimit > upperLimit) {
                    throw new IllegalArgumentException("Lower limit greater than upper limit");
                }
            }
            this.upperLimit = upperLimit;
        }

        public final void setUpperLimit(String upperLimit) throws IllegalArgumentException {
            if (upperLimit == null) {
                this.setUpperLimit((Long)null);
            } else {
                this.setUpperLimit(SizeUnit.parseValue(upperLimit, SizeUnit.BYTES));
            }
        }

        public final void setAllowUnlimited(boolean allowUnlimited) {
            this.allowUnlimited = allowUnlimited;
        }

        @Override
        protected SizePropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Long> defaultBehavior) {
            return new SizePropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.lowerLimit, this.upperLimit, this.allowUnlimited);
        }
    }
}

