/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.Rdn;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.messages.AdminMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.client.cli.DsFrameworkCliParser;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.DsFrameworkCliSubCommandGroup;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsFrameworkCliServerGroup
implements DsFrameworkCliSubCommandGroup {
    private String EOL = System.getProperty("line.separator");
    DsFrameworkCliParser argParser;
    BooleanArgument verboseArg;
    public SubCommand createGroupSubCmd;
    private StringArgument createGroupDescriptionArg;
    private StringArgument createGroupGroupNameArg;
    private SubCommand modifyGroupSubCmd;
    private StringArgument modifyGroupDescriptionArg;
    private StringArgument modifyGroupGroupIdArg;
    private StringArgument modifyGroupGroupNameArg;
    private SubCommand deleteGroupSubCmd;
    private StringArgument deleteGroupGroupNameArg;
    private SubCommand listGroupSubCmd;
    private SubCommand addToGroupSubCmd;
    private StringArgument addToGroupGroupNameArg;
    private StringArgument addToGoupMemberNameArg;
    private SubCommand removeFromGroupSubCmd;
    private StringArgument removeFromGroupGroupNameArg;
    private StringArgument removeFromGoupMemberNameArg;
    private SubCommand listMembersSubCmd;
    private StringArgument listMembersGroupNameArg;
    private SubCommand listMembershipSubCmd;
    private StringArgument listMembershipMemberNameArg;
    private HashMap<ADSContext.ServerGroupProperty, String> attributeDisplayName;
    private HashSet<SubCommand> subCommands = new HashSet();
    private boolean isHidden;
    private String groupName;

    public String getAttributeDisplayName(ADSContext.ServerGroupProperty prop) {
        return this.attributeDisplayName.get((Object)prop);
    }

    @Override
    public Set<SubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void initializeCliGroup(DsFrameworkCliParser argParser, BooleanArgument verboseArg) throws ArgumentException {
        this.verboseArg = verboseArg;
        this.isHidden = false;
        this.groupName = "server-group";
        this.argParser = argParser;
        this.createGroupSubCmd = new SubCommand(argParser, SubCommandNameEnum.CREATE_GROUP.toString(), AdminMessages.INFO_ADMIN_SUBCMD_CREATE_GROUP_DESCRIPTION.get());
        this.subCommands.add(this.createGroupSubCmd);
        this.createGroupDescriptionArg = new StringArgument("description", Character.valueOf('d'), "description", false, false, true, ToolMessages.INFO_DESCRIPTION_PLACEHOLDER.get(), "", null, AdminMessages.INFO_ADMIN_ARG_DESCRIPTION_DESCRIPTION.get());
        this.createGroupSubCmd.addArgument(this.createGroupDescriptionArg);
        this.createGroupGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, ToolMessages.INFO_GROUPNAME_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_CREATE_GROUP_GROUPNAME_DESCRIPTION.get());
        this.createGroupSubCmd.addArgument(this.createGroupGroupNameArg);
        this.modifyGroupSubCmd = new SubCommand(argParser, SubCommandNameEnum.MODIFY_GROUP.toString(), AdminMessages.INFO_ADMIN_SUBCMD_MODIFY_GROUP_DESCRIPTION.get());
        this.subCommands.add(this.modifyGroupSubCmd);
        this.modifyGroupDescriptionArg = new StringArgument("new-description", Character.valueOf('d'), "description", false, false, true, ToolMessages.INFO_DESCRIPTION_PLACEHOLDER.get(), "", null, AdminMessages.INFO_ADMIN_ARG_NEW_DESCRIPTION_DESCRIPTION.get());
        this.modifyGroupSubCmd.addArgument(this.modifyGroupDescriptionArg);
        this.modifyGroupGroupIdArg = new StringArgument("new-groupName", Character.valueOf('n'), "newGroupName", false, false, true, ToolMessages.INFO_GROUPNAME_PLACEHOLDER.get(), "", null, AdminMessages.INFO_ADMIN_ARG_NEW_GROUPNAME_DESCRIPTION.get());
        this.modifyGroupSubCmd.addArgument(this.modifyGroupGroupIdArg);
        this.modifyGroupGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, ToolMessages.INFO_GROUPNAME_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_GROUPNAME_DESCRIPTION.get());
        this.modifyGroupSubCmd.addArgument(this.modifyGroupGroupNameArg);
        this.deleteGroupSubCmd = new SubCommand(argParser, SubCommandNameEnum.DELETE_GROUP.toString(), AdminMessages.INFO_ADMIN_SUBCMD_DELETE_GROUP_DESCRIPTION.get());
        this.subCommands.add(this.deleteGroupSubCmd);
        this.deleteGroupGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, ToolMessages.INFO_GROUPNAME_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_GROUPNAME_DESCRIPTION.get());
        this.deleteGroupSubCmd.addArgument(this.deleteGroupGroupNameArg);
        this.listGroupSubCmd = new SubCommand(argParser, "list-groups", AdminMessages.INFO_ADMIN_SUBCMD_LIST_GROUPS_DESCRIPTION.get());
        this.subCommands.add(this.listGroupSubCmd);
        this.addToGroupSubCmd = new SubCommand(argParser, SubCommandNameEnum.ADD_TO_GROUP.toString(), AdminMessages.INFO_ADMIN_SUBCMD_ADD_TO_GROUP_DESCRIPTION.get());
        this.subCommands.add(this.addToGroupSubCmd);
        this.addToGoupMemberNameArg = new StringArgument("memberName", Character.valueOf('m'), "memberName", true, true, ToolMessages.INFO_MEMBERNAME_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_ADD_MEMBERNAME_DESCRIPTION.get());
        this.addToGroupSubCmd.addArgument(this.addToGoupMemberNameArg);
        this.addToGroupGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, ToolMessages.INFO_GROUPNAME_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_GROUPNAME_DESCRIPTION.get());
        this.addToGroupSubCmd.addArgument(this.addToGroupGroupNameArg);
        this.removeFromGroupSubCmd = new SubCommand(argParser, SubCommandNameEnum.REMOVE_FROM_GROUP.toString(), AdminMessages.INFO_ADMIN_SUBCMD_REMOVE_FROM_GROUP_DESCRIPTION.get());
        this.subCommands.add(this.removeFromGroupSubCmd);
        this.removeFromGoupMemberNameArg = new StringArgument("memberName", Character.valueOf('m'), "memberName", true, true, ToolMessages.INFO_MEMBERNAME_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_REMOVE_MEMBERNAME_DESCRIPTION.get());
        this.removeFromGroupSubCmd.addArgument(this.removeFromGoupMemberNameArg);
        this.removeFromGroupGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, ToolMessages.INFO_GROUPNAME_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_GROUPNAME_DESCRIPTION.get());
        this.removeFromGroupSubCmd.addArgument(this.removeFromGroupGroupNameArg);
        this.listMembersSubCmd = new SubCommand(argParser, SubCommandNameEnum.LIST_MEMBERS.toString(), AdminMessages.INFO_ADMIN_SUBCMD_LIST_MEMBERS_DESCRIPTION.get());
        this.subCommands.add(this.listMembersSubCmd);
        this.listMembersGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, ToolMessages.INFO_GROUPNAME_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_GROUPNAME_DESCRIPTION.get());
        this.listMembersSubCmd.addArgument(this.listMembersGroupNameArg);
        this.listMembershipSubCmd = new SubCommand(argParser, SubCommandNameEnum.LIST_MEMBERSHIP.toString(), AdminMessages.INFO_ADMIN_SUBCMD_LIST_MEMBERSHIP_DESCRIPTION.get());
        this.subCommands.add(this.listMembershipSubCmd);
        this.listMembershipMemberNameArg = new StringArgument("memberName", Character.valueOf('m'), "memberName", true, true, ToolMessages.INFO_MEMBERNAME_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_MEMBERNAME_DESCRIPTION.get());
        this.listMembershipSubCmd.addArgument(this.listMembershipMemberNameArg);
        this.attributeDisplayName = new HashMap();
        this.attributeDisplayName.put(ADSContext.ServerGroupProperty.UID, "groupName");
        this.attributeDisplayName.put(ADSContext.ServerGroupProperty.DESCRIPTION, "description");
        this.attributeDisplayName.put(ADSContext.ServerGroupProperty.MEMBERS, "memberName");
    }

    @Override
    public boolean isSubCommand(SubCommand subCmd) {
        return SubCommandNameEnum.isSubCommand(subCmd.getName());
    }

    @Override
    public DsFrameworkCliReturnCode performSubCommand(SubCommand subCmd, OutputStream outStream, OutputStream errStream) throws ADSContextException, ArgumentException {
        DsFrameworkCliReturnCode returnCode;
        InitialContext ctx;
        block64: {
            ADSContext adsCtx = null;
            ctx = null;
            returnCode = DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
            try {
                if (subCmd.getName().equals(this.createGroupSubCmd.getName())) {
                    String groupId = this.createGroupGroupNameArg.getValue();
                    HashMap<ADSContext.ServerGroupProperty, Object> serverGroupProperties = new HashMap<ADSContext.ServerGroupProperty, Object>();
                    serverGroupProperties.put(ADSContext.ServerGroupProperty.UID, groupId);
                    if (this.createGroupDescriptionArg.isPresent()) {
                        serverGroupProperties.put(ADSContext.ServerGroupProperty.DESCRIPTION, this.createGroupDescriptionArg.getValue());
                    }
                    if ((ctx = this.argParser.getContext(outStream, errStream)) == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    adsCtx.createServerGroup(serverGroupProperties);
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block64;
                }
                if (subCmd.getName().equals(this.deleteGroupSubCmd.getName())) {
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    String groupId = this.deleteGroupGroupNameArg.getValue();
                    if (groupId.equals("all-servers")) {
                        return DsFrameworkCliReturnCode.ACCESS_PERMISSION;
                    }
                    HashMap<ADSContext.ServerGroupProperty, Object> serverGroupProperties = new HashMap<ADSContext.ServerGroupProperty, Object>();
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set<String> serverList = adsCtx.getServerGroupMemberList(groupId);
                    for (String serverId : serverList) {
                        DsFrameworkCliServerGroup.removeServerFromGroup(adsCtx, groupId, serverId.substring(3));
                    }
                    serverGroupProperties.put(ADSContext.ServerGroupProperty.UID, groupId);
                    adsCtx.deleteServerGroup(serverGroupProperties);
                    break block64;
                }
                if (subCmd.getName().equals(this.listGroupSubCmd.getName())) {
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set<Map<ADSContext.ServerGroupProperty, Object>> result = adsCtx.readServerGroupRegistry();
                    StringBuilder buffer = new StringBuilder();
                    if (!this.verboseArg.isPresent()) {
                        for (Map<ADSContext.ServerGroupProperty, Object> groupProps : result) {
                            buffer.append(groupProps.get((Object)ADSContext.ServerGroupProperty.UID));
                            buffer.append(this.EOL);
                        }
                    } else {
                        int uidLength = 0;
                        for (ADSContext.ServerGroupProperty sgp : ADSContext.ServerGroupProperty.values()) {
                            int cur = this.attributeDisplayName.get((Object)sgp).toString().length();
                            if (cur <= uidLength) continue;
                            uidLength = cur;
                        }
                        ++uidLength;
                        for (Map<ADSContext.ServerGroupProperty, Object> groupProps : result) {
                            int curLen;
                            buffer.append(this.attributeDisplayName.get((Object)ADSContext.ServerGroupProperty.UID));
                            for (int i = curLen = this.attributeDisplayName.get((Object)ADSContext.ServerGroupProperty.UID).length(); i < uidLength; ++i) {
                                buffer.append(" ");
                            }
                            buffer.append(": ");
                            buffer.append(groupProps.get((Object)ADSContext.ServerGroupProperty.UID));
                            buffer.append(this.EOL);
                            for (ADSContext.ServerGroupProperty propName : ADSContext.ServerGroupProperty.values()) {
                                if (propName.compareTo(ADSContext.ServerGroupProperty.UID) == 0) continue;
                                buffer.append(this.attributeDisplayName.get((Object)propName));
                                for (int i = curLen = this.attributeDisplayName.get((Object)propName).length(); i < uidLength; ++i) {
                                    buffer.append(" ");
                                }
                                buffer.append(": ");
                                if (propName.compareTo(ADSContext.ServerGroupProperty.MEMBERS) == 0) {
                                    Set atts = (Set)groupProps.get((Object)propName);
                                    if (atts != null) {
                                        boolean indent = false;
                                        for (Object att : atts) {
                                            if (indent) {
                                                buffer.append(this.EOL);
                                                for (int i = 0; i < uidLength + 2; ++i) {
                                                    buffer.append(" ");
                                                }
                                            } else {
                                                indent = true;
                                            }
                                            buffer.append(att.toString().substring(3));
                                        }
                                    }
                                } else if (groupProps.get((Object)propName) != null) {
                                    buffer.append(groupProps.get((Object)propName));
                                }
                                buffer.append(this.EOL);
                            }
                            buffer.append(this.EOL);
                        }
                    }
                    try {
                        outStream.write(buffer.toString().getBytes());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block64;
                }
                if (subCmd.getName().equals(this.modifyGroupSubCmd.getName())) {
                    String groupId = this.modifyGroupGroupNameArg.getValue();
                    HashMap<ADSContext.ServerGroupProperty, Object> serverGroupProperties = new HashMap<ADSContext.ServerGroupProperty, Object>();
                    HashSet<ADSContext.ServerGroupProperty> serverGroupPropertiesToRemove = new HashSet<ADSContext.ServerGroupProperty>();
                    Boolean updateRequired = false;
                    Boolean removeRequired = false;
                    if (this.modifyGroupGroupIdArg.isPresent()) {
                        serverGroupProperties.put(ADSContext.ServerGroupProperty.UID, this.modifyGroupGroupIdArg.getValue());
                        updateRequired = true;
                    } else {
                        serverGroupProperties.put(ADSContext.ServerGroupProperty.UID, groupId);
                    }
                    if (this.modifyGroupDescriptionArg.isPresent()) {
                        String newDesc = this.modifyGroupDescriptionArg.getValue();
                        if (newDesc.length() == 0) {
                            serverGroupPropertiesToRemove.add(ADSContext.ServerGroupProperty.DESCRIPTION);
                            removeRequired = true;
                        } else {
                            serverGroupProperties.put(ADSContext.ServerGroupProperty.DESCRIPTION, this.modifyGroupDescriptionArg.getValue());
                            updateRequired = true;
                        }
                    }
                    if (!updateRequired.booleanValue() && !removeRequired.booleanValue()) {
                        returnCode = DsFrameworkCliReturnCode.SUCCESSFUL_NOP;
                    }
                    if ((ctx = this.argParser.getContext(outStream, errStream)) == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    if (updateRequired.booleanValue()) {
                        adsCtx.updateServerGroup(groupId, serverGroupProperties);
                    }
                    if (removeRequired.booleanValue()) {
                        adsCtx.removeServerGroupProp(groupId, serverGroupPropertiesToRemove);
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block64;
                }
                if (subCmd.getName().equals(this.addToGroupSubCmd.getName())) {
                    String groupId = this.addToGroupGroupNameArg.getValue();
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set<Map<ADSContext.ServerProperty, Object>> serverList = adsCtx.readServerRegistry();
                    boolean found = false;
                    Map<ADSContext.ServerProperty, Object> foundServerProperties = null;
                    for (Map<ADSContext.ServerProperty, Object> serverProperties : serverList) {
                        String serverId = ADSContext.getServerIdFromServerProperties(serverProperties);
                        if (!this.addToGoupMemberNameArg.getValue().equals(serverId)) continue;
                        found = true;
                        foundServerProperties = serverProperties;
                        break;
                    }
                    if (!found) {
                        throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
                    }
                    returnCode = DsFrameworkCliServerGroup.addServerTogroup(adsCtx, groupId, foundServerProperties);
                    break block64;
                }
                if (subCmd.getName().equals(this.removeFromGroupSubCmd.getName())) {
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    returnCode = DsFrameworkCliServerGroup.removeServerFromGroup(adsCtx, this.removeFromGroupGroupNameArg.getValue(), this.removeFromGoupMemberNameArg.getValue());
                    break block64;
                }
                if (subCmd.getName().equals(this.listMembersSubCmd.getName())) {
                    String groupId = this.listMembersGroupNameArg.getValue();
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set<String> memberList = adsCtx.getServerGroupMemberList(groupId);
                    if (memberList == null) {
                        returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    }
                    StringBuilder buffer = new StringBuilder();
                    for (String member : memberList) {
                        buffer.append(member.substring(3));
                        buffer.append(this.EOL);
                    }
                    try {
                        outStream.write(buffer.toString().getBytes());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block64;
                }
                if (subCmd.getName().equals(this.listMembershipSubCmd.getName())) {
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set<Map<ADSContext.ServerGroupProperty, Object>> result = adsCtx.readServerGroupRegistry();
                    String MemberId = this.listMembershipMemberNameArg.getValue();
                    StringBuilder buffer = new StringBuilder();
                    block23: for (Map<ADSContext.ServerGroupProperty, Object> groupProps : result) {
                        String groupId = groupProps.get((Object)ADSContext.ServerGroupProperty.UID).toString();
                        for (ADSContext.ServerGroupProperty propName : groupProps.keySet()) {
                            if (propName.compareTo(ADSContext.ServerGroupProperty.MEMBERS) != 0) continue;
                            Set atts = (Set)groupProps.get((Object)propName);
                            for (Object att : atts) {
                                if (!att.toString().substring(3).toLowerCase().equals(MemberId.toLowerCase())) continue;
                                buffer.append(groupId);
                                buffer.append(this.EOL);
                                continue block23;
                            }
                            continue block23;
                        }
                    }
                    try {
                        outStream.write(buffer.toString().getBytes());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block64;
                }
                returnCode = DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
            }
            catch (ADSContextException e) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException x) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException x) {
                // empty catch block
            }
        }
        return returnCode;
    }

    static DsFrameworkCliReturnCode removeServerFromGroup(ADSContext adsCtx, String groupId, String serverId) throws ADSContextException {
        String memberToRemove;
        DsFrameworkCliReturnCode returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
        Set<String> memberList = adsCtx.getServerGroupMemberList(groupId);
        if (memberList == null) {
            returnCode = DsFrameworkCliReturnCode.NOT_YET_REGISTERED;
        }
        if (!memberList.contains(memberToRemove = "cn=" + Rdn.escapeValue(serverId))) {
            returnCode = DsFrameworkCliReturnCode.NOT_YET_REGISTERED;
        }
        memberList.remove(memberToRemove);
        HashMap<ADSContext.ServerGroupProperty, Object> serverGroupProperties = new HashMap<ADSContext.ServerGroupProperty, Object>();
        serverGroupProperties.put(ADSContext.ServerGroupProperty.MEMBERS, memberList);
        adsCtx.updateServerGroup(groupId, serverGroupProperties);
        Set<Map<ADSContext.ServerProperty, Object>> serverList = adsCtx.readServerRegistry();
        boolean found = false;
        Map<ADSContext.ServerProperty, Object> serverProperties = null;
        for (Map<ADSContext.ServerProperty, Object> elm : serverList) {
            if (!serverId.equals(elm.get((Object)ADSContext.ServerProperty.ID))) continue;
            found = true;
            serverProperties = elm;
            break;
        }
        if (!found) {
            return DsFrameworkCliReturnCode.SERVER_NOT_REGISTERED;
        }
        Set rawGroupList = (Set)serverProperties.get((Object)ADSContext.ServerProperty.GROUPS);
        HashSet<String> groupList = new HashSet<String>();
        if (rawGroupList != null) {
            for (Object elm : rawGroupList.toArray()) {
                if (groupId.equals(elm)) continue;
                groupList.add(elm.toString());
            }
        }
        serverProperties.put(ADSContext.ServerProperty.GROUPS, groupList);
        adsCtx.updateServer(serverProperties, null);
        return returnCode;
    }

    static DsFrameworkCliReturnCode addServerTogroup(ADSContext adsCtx, String groupId, Map<ADSContext.ServerProperty, Object> map) throws ADSContextException {
        String newMember;
        DsFrameworkCliReturnCode returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
        String serverId = (String)map.get((Object)ADSContext.ServerProperty.ID);
        HashMap<ADSContext.ServerGroupProperty, Object> serverGroupProperties = new HashMap<ADSContext.ServerGroupProperty, Object>();
        Set<String> memberList = adsCtx.getServerGroupMemberList(groupId);
        if (memberList == null) {
            memberList = new HashSet<String>();
        }
        if (memberList.contains(newMember = "cn=" + Rdn.escapeValue(serverId))) {
            returnCode = DsFrameworkCliReturnCode.ALREADY_REGISTERED;
        }
        memberList.add(newMember);
        serverGroupProperties.put(ADSContext.ServerGroupProperty.MEMBERS, memberList);
        adsCtx.updateServerGroup(groupId, serverGroupProperties);
        Set rawGroupList = (Set)map.get((Object)ADSContext.ServerProperty.GROUPS);
        HashSet<String> groupList = new HashSet<String>();
        if (rawGroupList != null) {
            for (Object elm : rawGroupList.toArray()) {
                groupList.add(elm.toString());
            }
        }
        groupList.add(groupId);
        map.put(ADSContext.ServerProperty.GROUPS, groupList);
        adsCtx.updateServer(map, null);
        return returnCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SubCommandNameEnum {
        CREATE_GROUP("create-group"),
        DELETE_GROUP("delete-group"),
        MODIFY_GROUP("modify-group"),
        LIST_GROUPS("list-groups"),
        LIST_MEMBERS("list-members"),
        LIST_MEMBERSHIP("list-membership"),
        ADD_TO_GROUP("add-to-group"),
        REMOVE_FROM_GROUP("remove-from-group");

        private final String name;
        private static final List<String> nameToSubCmdName;

        private SubCommandNameEnum(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static boolean isSubCommand(String name) {
            return nameToSubCmdName.contains(name);
        }

        static {
            nameToSubCmdName = new ArrayList<String>();
            for (SubCommandNameEnum subCmd : SubCommandNameEnum.values()) {
                nameToSubCmdName.add(subCmd.toString());
            }
        }
    }
}

